/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.recent;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.support.config.ConfigServer;

public class Recent
extends CMSObj {
    public static final int OBJ_TYPE = 315;
    public static final String DB_TABLE_NAME = "WCMRECENT";
    public static final String DB_ID_NAME = "RECENTID";
    private static int MAX_RECENT_NUM;
    private static int MAX_RECENT_DEFAULT;

    @Override
    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    @Override
    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    @Override
    public int getWCMType() {
        return 315;
    }

    public int getObjType() {
        return this.getPropertyAsInt("OBJTYPE", 0);
    }

    public boolean setObjType(int _nObjType) throws WCMException {
        return this.setProperty("OBJTYPE", _nObjType);
    }

    public int getObjId() {
        return this.getPropertyAsInt("OBJID", 0);
    }

    public boolean setObjId(int _nObjId) throws WCMException {
        return this.setProperty("OBJID", _nObjId);
    }

    @Override
    public boolean isValid() throws WCMException {
        if (this.isAddMode()) {
            if (this.getAllProperty().get("OBJTYPE") == null) {
                throw new WCMException(1106, I18NMessage.get(Recent.class, "Recent.label1", "\u5c5e\u6027ObjType\u6ca1\u6709\u8bbe\u7f6e(Recent.isValid)"));
            }
            if (this.getAllProperty().get("OBJID") == null) {
                throw new WCMException(1106, I18NMessage.get(Recent.class, "Recent.label2", "\u5c5e\u6027ObjId\u6ca1\u6709\u8bbe\u7f6e(Recent.isValid)"));
            }
            if (this.getAllProperty().get("CRTIME") == null) {
                throw new WCMException(1106, I18NMessage.get(Recent.class, "Recent.label3", "\u5c5e\u6027CrTime\u6ca1\u6709\u8bbe\u7f6e(Recent.isValid)"));
            }
            if (this.getAllProperty().get("CRUSER") == null) {
                throw new WCMException(1106, I18NMessage.get(Recent.class, "Recent.label4", "\u5c5e\u6027CrUser\u6ca1\u6709\u8bbe\u7f6e(Recent.isValid)"));
            }
        } else if (!this.isModified()) {
            throw new WCMException(1107, I18NMessage.get(Recent.class, "Recent.label5", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(Recent.isValid)"));
        }
        return true;
    }

    @Override
    public void insert(User _currUser) throws WCMException {
        if (this.isAddMode() && this.getAllProperty() != null) {
            if (this.getAllProperty().get("CRUSER") == null) {
                this.setCrUser(_currUser);
            }
            if (this.getAllProperty().get("CRTIME") == null) {
                this.setCrTime();
            }
            super.insert(_currUser);
        }
    }

    public static final Recent findById(int _nId) throws WCMException {
        if (_nId <= 0) {
            return null;
        }
        return (Recent)BaseObj.findById(Recent.class, _nId);
    }

    public static final Recent createNewInstance() throws WCMException {
        return (Recent)BaseObj.createNewInstance(Recent.class);
    }

    public static final Recent findByKey(Object _oKey) throws WCMException {
        return (Recent)BaseObj.findByKey(Recent.class, _oKey);
    }

    public static int getMaxNum() {
        if (MAX_RECENT_NUM > 0) {
            return MAX_RECENT_NUM;
        }
        ConfigServer configServer = ConfigServer.getServer();
        String sMaxNum = configServer.getInitProperty("MAX_RECENT_NUM");
        if (sMaxNum == null || sMaxNum.length() == 0) {
            return MAX_RECENT_DEFAULT;
        }
        try {
            return Integer.parseInt(sMaxNum);
        }
        catch (Exception ex) {
            return MAX_RECENT_DEFAULT;
        }
    }

    public boolean setObj(CMSObj _obj) throws WCMException {
        return this.setProperty("OBJTYPE", _obj.getWCMType()) && this.setProperty("OBJID", _obj.getId());
    }

    static {
        MAX_RECENT_DEFAULT = 10;
    }
}

