/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.customize;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.customize.UserSetting;
import com.trs.components.wcm.customize.UserSettings;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.common.WCMTypes;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import org.apache.log4j.Logger;

public class CustomizeMgr {
    private static Logger m_oLogger = Logger.getLogger((String)CustomizeMgr.class.getName());
    private static final int[] VALID_MOUDEL_TYPES = new int[]{306, 304, 309, 605, 102, 204};

    public boolean save(int _nMoudelType) throws WCMException {
        if (!this.isValidMoudelType(_nMoudelType)) {
            throw new WCMException(10, I18NMessage.get(CustomizeMgr.class, "CustomizeMgr.label1", "\u65e0\u6548\u7684\u529f\u80fd\u6a21\u5757\u7c7b\u578b[") + WCMTypes.getObjName(_nMoudelType, true) + "]!");
        }
        try {
            String sSQL = "SELECT COUNT(*) FROM WCMUserSetting WHERE ObjType=" + _nMoudelType + " AND UserId=" + ContextHelper.getLoginUser().getId();
            if (DBManager.getDBManager().sqlExecuteIntQuery(sSQL) != 0) {
                return true;
            }
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(CustomizeMgr.class, "CustomizeMgr.label2", "\u7cfb\u7edf\u5f02\u5e38!"), ex);
        }
        UserSetting currUserSetting = UserSetting.createNewInstance();
        currUserSetting.canEdit(ContextHelper.getLoginUser());
        currUserSetting.setUser(ContextHelper.getLoginUser());
        currUserSetting.setObjType(_nMoudelType);
        currUserSetting.setObjId(0);
        currUserSetting.insert(ContextHelper.getLoginUser());
        return true;
    }

    public boolean delete(int _nMoudelType) throws WCMException {
        if (ContextHelper.getLoginUser() == null) {
            throw new WCMException(10, I18NMessage.get(CustomizeMgr.class, "CustomizeMgr.label3", "\u65e0\u6548\u7684\u7528\u6237\u5bf9\u8c61!"));
        }
        String sSQL = "DELETE FROM WCMUserSetting WHERE ObjType=" + _nMoudelType + " AND UserId=" + ContextHelper.getLoginUser().getId();
        return this.getDBManager().sqlExecuteUpdate(sSQL) == 1;
    }

    public int[] getMoudels() throws WCMException {
        if (ContextHelper.getLoginUser() == null) {
            throw new WCMException(10, I18NMessage.get(CustomizeMgr.class, "CustomizeMgr.label3", "\u65e0\u6548\u7684\u7528\u6237\u5bf9\u8c61!"));
        }
        String sWhere = "UserId=" + ContextHelper.getLoginUser().getId() + " AND ObjType<>" + 101;
        WCMFilter aFilter = new WCMFilter("", sWhere, "");
        UserSettings aUserSettings = UserSettings.openWCMObjs(ContextHelper.getLoginUser(), aFilter);
        UserSetting currUserSetting = null;
        int[] nArgMoudels = new int[aUserSettings.size()];
        for (int i = 0; i < aUserSettings.size(); ++i) {
            currUserSetting = (UserSetting)aUserSettings.getAt(i);
            if (currUserSetting == null) continue;
            nArgMoudels[i] = currUserSetting.getObjType();
        }
        return nArgMoudels;
    }

    public boolean hasCustomized() throws Exception {
        String sSQL = "SELECT COUNT(*) FROM WCMUserSetting WHERE UserId=" + ContextHelper.getLoginUser().getId();
        return DBManager.getDBManager().sqlExecuteIntQuery(sSQL) > 0;
    }

    public boolean saveChannels(int[] _nArgChannelId) throws WCMException {
        if (_nArgChannelId == null || _nArgChannelId.length == 0) {
            return true;
        }
        String sSQL = "DELETE FROM WCMUserSetting WHERE ObjType=101 AND UserId=" + ContextHelper.getLoginUser().getId();
        this.getDBManager().sqlExecuteUpdate(sSQL);
        for (int i = 0; i < _nArgChannelId.length; ++i) {
            if (_nArgChannelId[i] <= 0) continue;
            this.saveChannel(_nArgChannelId[i]);
        }
        return true;
    }

    public boolean deleteChannels(int[] _nArgChannelId) throws WCMException {
        if (_nArgChannelId == null || _nArgChannelId.length == 0) {
            return true;
        }
        String sSQL = "DELETE FROM WCMUserSetting WHERE ObjType=101 AND UserId=" + ContextHelper.getLoginUser().getId();
        String[] sArgSQL = new String[_nArgChannelId.length];
        for (int i = 0; i < sArgSQL.length; ++i) {
            sArgSQL[i] = sSQL + " AND ObjId=" + _nArgChannelId[i];
        }
        return this.getDBManager().sqlExecuteUpdate(sArgSQL) == 1;
    }

    public Channels getChannels() throws WCMException {
        WCMFilter aFilter = new WCMFilter("", "UserId=" + ContextHelper.getLoginUser().getId() + " AND ObjType=" + 101, "RangeIndex desc,SettingId asc", "ObjId");
        UserSettings aUserSettings = UserSettings.openWCMObjs(ContextHelper.getLoginUser(), aFilter);
        String sChannelIds = "";
        UserSetting currUserSetting = null;
        for (int i = 0; i < aUserSettings.size(); ++i) {
            currUserSetting = (UserSetting)aUserSettings.getAt(i);
            if (currUserSetting == null) continue;
            if (sChannelIds.length() == 0) {
                sChannelIds = sChannelIds + currUserSetting.getObjId();
            }
            sChannelIds = sChannelIds + "," + currUserSetting.getObjId();
        }
        if (sChannelIds.length() == 0) {
            return Channels.createNewInstance(ContextHelper.getLoginUser());
        }
        return Channels.findByIds(ContextHelper.getLoginUser(), sChannelIds);
    }

    private boolean saveChannel(int _nChannelId) throws WCMException {
        Channel currChannel = Channel.findById(_nChannelId);
        if (currChannel == null) {
            return true;
        }
        try {
            String sSQL = "SELECT COUNT(*) FROM WCMUserSetting WHERE ObjType=101 AND UserId=" + ContextHelper.getLoginUser().getId() + " AND ObjId=" + _nChannelId;
            if (DBManager.getDBManager().sqlExecuteIntQuery(sSQL) != 0) {
                return true;
            }
        }
        catch (Exception ex) {
            m_oLogger.error((Object)I18NMessage.get(CustomizeMgr.class, "CustomizeMgr.label4", "\u7cfb\u7edf\u5f02\u5e38:"), (Throwable)ex);
            throw new WCMException(1100, I18NMessage.get(CustomizeMgr.class, "CustomizeMgr.label2", "\u7cfb\u7edf\u5f02\u5e38!"), ex);
        }
        UserSetting currUserSetting = UserSetting.createNewInstance();
        currUserSetting.canEdit(ContextHelper.getLoginUser());
        currUserSetting.setUser(ContextHelper.getLoginUser());
        currUserSetting.setObjType(101);
        currUserSetting.setObjId(_nChannelId);
        currUserSetting.insert(ContextHelper.getLoginUser());
        return true;
    }

    private boolean isValidMoudelType(int _nMoudelType) {
        int[] nValidTypes = VALID_MOUDEL_TYPES;
        for (int i = 0; i < nValidTypes.length; ++i) {
            if (_nMoudelType != nValidTypes[i]) continue;
            return true;
        }
        return false;
    }

    protected DBManager getDBManager() throws WCMException {
        DBManager currDBManager = DBManager.getDBManager();
        if (currDBManager == null || !currDBManager.isStarted()) {
            throw new WCMException(10, I18NMessage.get(CustomizeMgr.class, "CustomizeMgr.label5", "DBManaer\u914d\u7f6e\u4e0d\u6b63\u786e\uff01"));
        }
        if (!currDBManager.isStarted()) {
            throw new WCMException(10, I18NMessage.get(CustomizeMgr.class, "CustomizeMgr.label6", "DBManaer\u6ca1\u6709\u542f\u52a8\uff01"));
        }
        return currDBManager;
    }

    public UserSetting find(User _currUser, int _nRegionNumber) throws WCMException {
        if (_currUser == null) {
            throw new WCMException(10, I18NMessage.get(CustomizeMgr.class, "CustomizeMgr.label7", "\u65e0\u6cd5\u7684\u7528\u6237\u5bf9\u8c61!"));
        }
        User loginUser = ContextHelper.getLoginUser();
        if (!_currUser.equals(loginUser)) {
            throw new WCMException(1002, I18NMessage.get(CustomizeMgr.class, "CustomizeMgr.label8", "\u5bf9\u4e0d\u8d77,\u60a8\u65e0\u6743\u67e5\u770b\u5176\u5b83\u7528\u6237\u7684\u5b9a\u5236!"));
        }
        WCMFilter aFilter = new WCMFilter("", "UserId=" + _currUser.getId() + " AND Region=" + _nRegionNumber, "");
        UserSettings userSettings = UserSettings.openWCMObjs(_currUser, aFilter);
        UserSetting userSetting = null;
        if (!userSettings.isEmpty()) {
            userSetting = (UserSetting)userSettings.getAt(0);
        }
        return userSetting;
    }

    public void saveSetting(BaseObj _baseObj, int _nOrder, int _nRegionNumber) throws WCMException {
        this.saveSetting(_baseObj, _nOrder, _nRegionNumber, null);
    }

    public void saveSetting(BaseObj _baseObj, int _nOrder, int _nRegionNumber, String _sValue) throws WCMException {
        UserSetting userSetting = UserSetting.createNewInstance();
        userSetting.setObjId(_baseObj.getId());
        userSetting.setObjType(_baseObj.getWCMType());
        userSetting.setOrder(_nOrder);
        userSetting.setRegion(_nRegionNumber);
        userSetting.setUser(ContextHelper.getLoginUser());
        if (_sValue != null) {
            userSetting.setValue(_sValue);
        }
        userSetting.save();
    }
}

