/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.domain;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.components.wcm.content.domain.SiteMemberMgr;
import com.trs.components.wcm.content.persistent.SiteMember;
import com.trs.components.wcm.content.persistent.SiteMembers;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.BaseIdsMan;
import com.trs.infra.common.WCMException;

public class SiteMemberIdsMan
extends BaseIdsMan {
    private SiteMembers m_oSiteMembers;
    private WebSite m_site;
    private SiteMemberMgr m_siteMemberMgr;
    private int m_nMemberType;

    protected SiteMemberIdsMan() {
    }

    public SiteMemberIdsMan(WebSite _site, int _nMemberType) throws WCMException {
        if (_site == null) {
            throw new WCMException(10, I18NMessage.get(SiteMemberIdsMan.class, "SiteMemberIdsMan.label1", "\u65e0\u6548\u7684\u7ad9\u70b9!"));
        }
        this.m_site = _site;
        this.m_siteMemberMgr = (SiteMemberMgr)DreamFactory.createObjectById("SiteMemberMgr");
        this.m_nMemberType = _nMemberType;
        this.m_oSiteMembers = this.m_siteMemberMgr.getSiteMembers(_site.getId(), _nMemberType);
    }

    @Override
    protected int getExistsSize() {
        return this.m_oSiteMembers.size();
    }

    @Override
    protected int getExistsIdAt(int _nExistsIndex) {
        SiteMember member = (SiteMember)this.m_oSiteMembers.getAt(_nExistsIndex);
        if (member == null) {
            return -1;
        }
        return member.getObjId();
    }

    @Override
    protected void deleteExists(int _nExistsIndex) throws WCMException {
        this.m_oSiteMembers.removeAt(_nExistsIndex, true);
    }

    @Override
    protected void addRelation(int _nNewId) throws WCMException {
        SiteMember member = new SiteMember();
        member.setSiteId(this.m_site.getId());
        member.setObjId(_nNewId);
        member.setObjType(this.m_nMemberType);
        member.save(ContextHelper.getLoginUser());
    }
}

