/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.domain;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.job.Schedule;
import com.trs.components.wcm.content.domain.DocumentPriMgr;
import com.trs.components.wcm.content.persistent.ChnlDoc;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.listener.IObjectLCListenerOnAdd;
import com.trs.infra.persistent.listener.IObjectLCListenerOnDel;
import com.trs.infra.persistent.listener.IObjectLCListenerOnModify;
import com.trs.infra.util.CMyDateTime;
import org.apache.log4j.Logger;

public class ChnlDocLCListenerForPri
implements IObjectLCListenerOnAdd,
IObjectLCListenerOnDel,
IObjectLCListenerOnModify {
    private static Logger logger = Logger.getLogger(ChnlDocLCListenerForPri.class);
    private DocumentPriMgr m_oPriMgr = (DocumentPriMgr)DreamFactory.createObjectById("DocumentPriMgr");

    @Override
    public void notifyOnAddObj(BaseObj _oObjAdded) throws WCMException {
        if (!(_oObjAdded instanceof ChnlDoc)) {
            logger.error((Object)("Listener[" + this.getClass() + I18NMessage.get(ChnlDocLCListenerForPri.class, "ChnlDocLCListenerForPri.label1", "]\u4e0d\u80fd\u76d1\u542c\u5bf9\u8c61[") + _oObjAdded.getClass() + I18NMessage.get(ChnlDocLCListenerForPri.class, "ChnlDocLCListenerForPri.label2", "]\u7684\u65b0\u589e\uff01")));
            return;
        }
        ChnlDoc currChnlDoc = (ChnlDoc)_oObjAdded;
        if (!currChnlDoc.isTopped()) {
            return;
        }
        CMyDateTime dt = currChnlDoc.getInvalidTime();
        if (dt != null && !dt.isNull()) {
            this.m_oPriMgr.createSchedule(currChnlDoc, currChnlDoc.getInvalidTime());
        }
    }

    @Override
    public void notifyOnDelObj(BaseObj _oObjDeleted, int _nEventType) throws WCMException {
        if (!(_oObjDeleted instanceof ChnlDoc)) {
            logger.error((Object)("Listener[" + this.getClass() + I18NMessage.get(ChnlDocLCListenerForPri.class, "ChnlDocLCListenerForPri.label1", "]\u4e0d\u80fd\u76d1\u542c\u5bf9\u8c61[") + _oObjDeleted.getClass() + I18NMessage.get(ChnlDocLCListenerForPri.class, "ChnlDocLCListenerForPri.label3", "]\u7684\u5220\u9664\uff01")));
            return;
        }
        ChnlDoc currChnlDoc = (ChnlDoc)_oObjDeleted;
        Schedule delSchedule = this.m_oPriMgr.findSchedule(currChnlDoc);
        if (delSchedule != null) {
            delSchedule.delete(ContextHelper.getLoginUser());
        }
    }

    @Override
    public void notifyOnModifyObj(BaseObj _oObjModified, int _nEventType) throws WCMException {
        if (_oObjModified == null || !(_oObjModified instanceof ChnlDoc)) {
            return;
        }
        ChnlDoc chnldoc = (ChnlDoc)_oObjModified;
        if (!chnldoc.isChangeProperty("INVALIDTIME") && !chnldoc.isChangeProperty("DOCORDERPRI")) {
            return;
        }
        CMyDateTime dtTopPriInvalid = this.getNewTopPriInvalidTime(chnldoc);
        Schedule schedule = this.m_oPriMgr.findSchedule(chnldoc);
        if (schedule == null) {
            if (dtTopPriInvalid != null) {
                this.m_oPriMgr.createSchedule(chnldoc, dtTopPriInvalid);
            }
        } else if (dtTopPriInvalid == null || ChnlDoc.NOT_ON_TOP == chnldoc.getNewPropertyAsInt("DOCORDERPRI", 1)) {
            schedule.delete();
        } else {
            User user = ContextHelper.getLoginUser();
            if (!schedule.canEdit(user)) {
                throw new WCMException(1013, I18NMessage.get(ChnlDocLCListenerForPri.class, "ChnlDocLCListenerForPri.label5", "\u64a4\u6d88\u6587\u6863\u7f6e\u9876\u7684\u8ba1\u5212\u5df2\u88ab") + schedule.getLockerUser() + I18NMessage.get(ChnlDocLCListenerForPri.class, "ChnlDocLCListenerForPri.label6", "\u9501\u5b9a,\u66f4\u6539\u8ba1\u5212\u5931\u8d25!"));
            }
            schedule.setExeTime(dtTopPriInvalid);
            schedule.save(user);
        }
    }

    private CMyDateTime getNewTopPriInvalidTime(ChnlDoc _chnldoc) {
        CMyDateTime dt = (CMyDateTime)_chnldoc.getNewProperty("INVALIDTIME");
        if (dt == null || dt.isNull()) {
            return null;
        }
        return dt;
    }

    public static void main(String[] args) {
        try {
            IObjectLCListenerOnModify iObjectLCListenerOnModify = (IObjectLCListenerOnModify)Class.forName("com.trs.components.wcm.content.domain.ChnlDocLCListenerForPri").newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

