/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.stat;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.util.database.FieldInfo;
import java.util.Enumeration;
import org.apache.log4j.Logger;

public class BonusRule
extends CMSObj {
    private static Logger slogger = Logger.getLogger(BonusRule.class);
    public static final int OBJ_TYPE = 631000141;
    public static final String DB_TABLE_NAME = "XWCMBONUSRULE";
    public static final String DB_ID_NAME = "BONUSRULEID";
    public static final int ISSUEDAMOUNT_BONUS = 1;
    public static final int HITS_BONUS = 2;

    @Override
    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    @Override
    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    @Override
    public int getWCMType() {
        return 631000141;
    }

    public int getBonusType() {
        return this.getPropertyAsInt("BONUSTYPE", 1);
    }

    public boolean setBonusType(int _nBonusType) throws WCMException {
        return this.setProperty("BONUSTYPE", _nBonusType);
    }

    public String getRange() {
        return this.getPropertyAsString("RANGE");
    }

    public boolean setRange(String _sRange) throws WCMException {
        return this.setProperty("RANGE", _sRange);
    }

    public float getPricePerUnit() {
        return (float)this.getPropertyAsDouble("PRICEPERUNIT", 0.0);
    }

    public boolean setPricePerUnit(float _fPricePerUnit) throws WCMException {
        return this.setProperty("PRICEPERUNIT", _fPricePerUnit);
    }

    @Override
    public boolean isValid() throws WCMException {
        if (!this.isAddMode() && !this.isModified()) {
            throw new WCMException(1107, "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(BonusRule.isValid)");
        }
        return true;
    }

    @Override
    public void insert(User _currUser) throws WCMException {
        if (this.isAddMode() && this.isModified()) {
            if (this.getProperty("BONUSTYPE") == null) {
                this.setBonusType(1);
            }
            if (this.getProperty("RANGE") == null) {
                this.setRange("0,500");
            }
            if (this.getProperty("PRICEPERUNIT") == null) {
                this.setPricePerUnit(0.0f);
            }
            super.insert(_currUser);
        }
    }

    @Override
    protected String createInsertSQL() throws WCMException {
        String sTableName = this.getDbTableName();
        FieldInfo fi = null;
        boolean bFirst = true;
        Enumeration<String> enumKey = null;
        this.sClobFields_toUpdate = null;
        String strSQL = "INSERT INTO " + sTableName + "(";
        String strValues = " VALUES(";
        enumKey = this.getProperties().keys();
        while (enumKey.hasMoreElements()) {
            String sValue;
            String sKey = enumKey.nextElement();
            int nDBType = this.getDBManager().getDBTypeAsInt();
            fi = this.getDBManager().getFieldInfo(sTableName, sKey);
            if (fi == null) {
                slogger.warn((Object)("The field[" + sTableName + "." + sKey + "] not exists! Ignore to insert!"));
                continue;
            }
            if (nDBType == 7) {
                sKey = "`" + sKey + "`";
            } else if (nDBType == 9) {
                sKey = "\"" + sKey + "\"";
            }
            switch (fi.getDataType().getType()) {
                case 2005: {
                    String string = this.sClobFields_toUpdate = this.sClobFields_toUpdate == null ? sKey : this.sClobFields_toUpdate + "," + sKey;
                    if (nDBType == 6 || nDBType == 3 || nDBType == 5) {
                        sValue = "clob('')";
                        break;
                    }
                    if (nDBType == 7 || nDBType == 10) {
                        sValue = "' '";
                        break;
                    }
                    sValue = "empty_clob()";
                    break;
                }
                case -1: {
                    if (nDBType == 3 || nDBType == 5 || nDBType == 7) {
                        String string = this.sClobFields_toUpdate = this.sClobFields_toUpdate == null ? sKey : this.sClobFields_toUpdate + "," + sKey;
                        if (nDBType == 7) {
                            sValue = "' '";
                            break;
                        }
                        sValue = "clob('')";
                        break;
                    }
                    sValue = "?";
                    break;
                }
                default: {
                    sValue = "?";
                }
            }
            if (bFirst) {
                strSQL = strSQL + sKey;
                strValues = strValues + sValue;
                bFirst = false;
                continue;
            }
            strSQL = strSQL + "," + sKey;
            strValues = strValues + "," + sValue;
        }
        if (bFirst) {
            return null;
        }
        return strSQL + ") " + strValues + ")";
    }

    @Override
    protected synchronized String createUpdateSQL() throws WCMException {
        boolean bFirst = true;
        FieldInfo fi = null;
        String sTableName = this.getDbTableName();
        this.sClobFields_toUpdate = null;
        String strSQL = "UPDATE " + sTableName + " SET  ";
        Enumeration<String> enumKey = this.getNewProperties().keys();
        block4: while (enumKey.hasMoreElements()) {
            String sKey = enumKey.nextElement();
            int nDBType = this.getDBManager().getDBTypeAsInt();
            fi = this.getDBManager().getFieldInfo(sTableName, sKey);
            if (fi == null) {
                slogger.warn((Object)("The field[" + sTableName + "." + sKey + "] not exists! Ignore to update!"));
                continue;
            }
            if (nDBType == 7) {
                sKey = "`" + sKey + "`";
            } else if (nDBType == 9) {
                sKey = "\"" + sKey + "\"";
            }
            if (bFirst) {
                bFirst = false;
            } else {
                strSQL = strSQL + ",";
            }
            switch (fi.getDataType().getType()) {
                case 2005: {
                    String string = this.sClobFields_toUpdate = this.sClobFields_toUpdate == null ? sKey : this.sClobFields_toUpdate + "," + sKey;
                    if (nDBType == 6 || nDBType == 3 || nDBType == 5) {
                        strSQL = strSQL + sKey + "=clob('')";
                        continue block4;
                    }
                    if (nDBType == 7 || nDBType == 10) {
                        strSQL = strSQL + sKey + "=' '";
                        continue block4;
                    }
                    strSQL = strSQL + sKey + "=empty_clob()";
                    continue block4;
                }
                case -1: {
                    if (nDBType == 3 || nDBType == 5 || nDBType == 7) {
                        if (nDBType == 7) {
                            strSQL = strSQL + sKey + "=' '";
                        }
                        strSQL = strSQL + sKey + "=clob('')";
                        continue block4;
                    }
                    strSQL = strSQL + sKey + "=?";
                    continue block4;
                }
            }
            strSQL = strSQL + sKey + "=?";
        }
        if (bFirst) {
            return null;
        }
        strSQL = strSQL + " where " + this.getIdFieldName() + "=?";
        return strSQL;
    }

    public static final BonusRule findById(int _nId) throws WCMException {
        if (_nId <= 0) {
            return null;
        }
        return (BonusRule)BaseObj.findById(BonusRule.class, _nId);
    }

    public static final BonusRule createNewInstance() throws WCMException {
        return (BonusRule)BaseObj.createNewInstance(BonusRule.class);
    }

    public static final BonusRule findByKey(Object _oKey) throws WCMException {
        return (BonusRule)BaseObj.findByKey(BonusRule.class, _oKey);
    }
}

