/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.infoview.persistent;

import com.trs.components.infoview.InfoViewConstants;
import com.trs.components.infoview.persistent.InfoViewData;
import com.trs.components.wcm.content.ViewDocument;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.ChnlDoc;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.database.CDBText;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.StringTokenizer;

public class InfoViewDocument
extends ViewDocument {
    private InfoViewData m_oInfoViewData = null;

    public InfoViewDocument(HashMap _hsMap) {
        super(_hsMap);
    }

    @Override
    public ChnlDoc getChnlDoc() throws WCMException {
        return ChnlDoc.findByDocAndChnl(this.getDocId(), this.getChannelId());
    }

    public InfoViewData getInfoViewData() throws WCMException {
        if (this.m_oInfoViewData == null) {
            this.m_oInfoViewData = InfoViewData.findById2(this.getInfoViewId(), this.getChnlDoc().getDocumentId());
        }
        return this.m_oInfoViewData;
    }

    @Override
    public Document getDocument() throws WCMException {
        return this.getChnlDoc().getDocument();
    }

    @Override
    public int getId() {
        int nRecId = super.getId();
        if (nRecId <= 0) {
            nRecId = this.getChnlDocProperty("RECID", 0);
        }
        return nRecId;
    }

    @Override
    public int getDocId() {
        int nDocId = super.getDocId();
        if (nDocId <= 0) {
            nDocId = this.getPropertyAsInt("DocumentId", this.getPropertyAsInt("DocId", 0));
        }
        return nDocId;
    }

    public int getInfoViewId() {
        return this.getPropertyAsInt("InfoViewId", 0);
    }

    public boolean isInfoViewDocument() {
        return this.getInfoViewId() > 0;
    }

    public String getTrueTableName() {
        return InfoViewConstants.makeTrueTableName(this.getInfoViewId()).toUpperCase();
    }

    public static InfoViewDocument findSelfByDocument(Document _oDocument) throws WCMException {
        Channel oChannel = _oDocument.getChannel();
        HashMap<Integer, Channel> hPublicCache = new HashMap<Integer, Channel>(1);
        if (oChannel != null) {
            hPublicCache.put(KEY_CURR_HOST, oChannel);
        }
        InfoViewDocument oResultViewDocument = new InfoViewDocument(hPublicCache);
        oResultViewDocument.setId(0);
        oResultViewDocument.cloneDocumentProperties(_oDocument);
        int nInfoViewId = _oDocument.getFlag();
        oResultViewDocument.setDocId(_oDocument.getId());
        if (nInfoViewId > 0) {
            oResultViewDocument.loadDatasOfInfoView(nInfoViewId, "*");
        }
        return oResultViewDocument;
    }

    public void cloneDocumentProperties(Document _oDoc) {
        this.m_hProperties = _oDoc.getProperties();
    }

    public static InfoViewDocument findByDocument(Document _oDocument, String _sSelectFieldsOfChnlDoc, String _sSelectFieldsOfDocument, String _sSelectFieldsOfInfoView) throws WCMException {
        int nInfoViewId;
        String sSelectFieldsOfDocument;
        Channel oChannel = _oDocument.getChannel();
        String sSelectFieldsOfChnlDoc = null;
        if (_sSelectFieldsOfChnlDoc == null) {
            sSelectFieldsOfChnlDoc = "DOCID,RECID,CHNLID,DOCCHANNEL";
        } else {
            sSelectFieldsOfChnlDoc = _sSelectFieldsOfChnlDoc.toUpperCase();
            if (sSelectFieldsOfChnlDoc.indexOf(" FROM ") >= 0) {
                return null;
            }
        }
        HashMap<Integer, Channel> hPublicCache = new HashMap<Integer, Channel>(1);
        if (oChannel != null) {
            hPublicCache.put(KEY_CURR_HOST, oChannel);
        }
        ChnlDoc oChnlDoc = ChnlDoc.findByDocument(_oDocument);
        InfoViewDocument oResultViewDocument = new InfoViewDocument(hPublicCache);
        oResultViewDocument.setId(oChnlDoc.getId());
        if (!oResultViewDocument.loadDatasOfChnlDoc(sSelectFieldsOfChnlDoc)) {
            return null;
        }
        if (_sSelectFieldsOfDocument != null && _sSelectFieldsOfDocument.trim().length() != 0 && (sSelectFieldsOfDocument = _sSelectFieldsOfDocument.toUpperCase()).indexOf(" FROM ") == -1) {
            oResultViewDocument.loadDatasOfDocument(sSelectFieldsOfDocument);
        }
        if ((nInfoViewId = _oDocument.getFlag()) > 0 && !CMyString.isEmpty(_sSelectFieldsOfInfoView) && (_sSelectFieldsOfInfoView = _sSelectFieldsOfInfoView.toUpperCase()).indexOf(" FROM ") == -1) {
            oResultViewDocument.loadDatasOfInfoView(nInfoViewId, _sSelectFieldsOfInfoView);
        }
        return oResultViewDocument;
    }

    public static InfoViewDocument findById(BaseChannel _host, int _nChnlDocRecId, String _sSelectFieldsOfChnlDoc, String _sSelectFieldsOfDocument, int _nInfoViewId, String _sSelectFieldsOfInfoView) throws WCMException {
        String sSelectFieldsOfDocument;
        String sSelectFieldsOfChnlDoc = null;
        if (_sSelectFieldsOfChnlDoc == null) {
            sSelectFieldsOfChnlDoc = "DOCID,RECID,CHNLID,DOCCHANNEL";
        } else {
            sSelectFieldsOfChnlDoc = _sSelectFieldsOfChnlDoc.toUpperCase();
            if (sSelectFieldsOfChnlDoc.indexOf(" FROM ") >= 0) {
                return null;
            }
        }
        HashMap<Integer, BaseChannel> hPublicCache = new HashMap<Integer, BaseChannel>(1);
        if (_host != null) {
            hPublicCache.put(KEY_CURR_HOST, _host);
        }
        InfoViewDocument oResultViewDocument = new InfoViewDocument(hPublicCache);
        oResultViewDocument.setId(_nChnlDocRecId);
        if (!oResultViewDocument.loadDatasOfChnlDoc(sSelectFieldsOfChnlDoc)) {
            return null;
        }
        if (_sSelectFieldsOfDocument != null && _sSelectFieldsOfDocument.trim().length() != 0 && (sSelectFieldsOfDocument = _sSelectFieldsOfDocument.toUpperCase()).indexOf(" FROM ") == -1) {
            oResultViewDocument.loadDatasOfDocument(sSelectFieldsOfDocument);
        }
        if (_nInfoViewId > 0 && !CMyString.isEmpty(_sSelectFieldsOfInfoView) && (_sSelectFieldsOfInfoView = _sSelectFieldsOfInfoView.toUpperCase()).indexOf(" FROM ") == -1) {
            oResultViewDocument.loadDatasOfInfoView(_nInfoViewId, _sSelectFieldsOfInfoView);
        }
        return oResultViewDocument;
    }

    private boolean loadDatasOfInfoView(int _nInfoViewId, String _sSelectFields) throws WCMException {
        Connection oConn = null;
        PreparedStatement oPreStmt = null;
        ResultSet rsData = null;
        String sTableName = InfoViewConstants.makeTrueTableName(_nInfoViewId);
        String strSQL = "select " + _sSelectFields + " from " + sTableName + " where " + "DocumentId" + "=?";
        try {
            oConn = this.getDBManager().getConnection();
            oPreStmt = oConn.prepareStatement(strSQL);
            oPreStmt.setMaxRows(1);
            oPreStmt.setFetchSize(1);
            oPreStmt.setInt(1, this.getDocId());
            rsData = oPreStmt.executeQuery();
            if (!rsData.next()) {
                boolean bl = false;
                return bl;
            }
            this.setLoadText(true);
            ResultSetMetaData rsmdData = rsData.getMetaData();
            this.readFromRs(rsData, rsmdData);
            boolean bl = true;
            return bl;
        }
        catch (SQLException ex) {
            throw new WCMException(40, I18NMessage.get(InfoViewDocument.class, "InfoViewDocument.label1", "\u8f7d\u5165Document\u6570\u636e[RecId=") + this.getDocId() + I18NMessage.get(InfoViewDocument.class, "InfoViewDocument.label2", "]\u53d1\u751f\u6570\u636e\u5e93\u5f02\u5e38\uff1a\n") + strSQL, ex);
        }
        catch (Exception ex) {
            throw new WCMException(0, I18NMessage.get(InfoViewDocument.class, "InfoViewDocument.label3", "\u8f7d\u5165Document\u6570\u636e\u5931\u8d25"), ex);
        }
        finally {
            try {
                if (rsData != null) {
                    rsData.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (oPreStmt != null) {
                    oPreStmt.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (oConn != null) {
                this.getDBManager().freeConnection(oConn);
            }
        }
    }

    @Override
    public String toString() {
        StringBuffer buff = new StringBuffer(64);
        buff.append("CMSObj[Type=");
        buff.append(this.getWCMType());
        buff.append(",Id=");
        buff.append(this.getId());
        buff.append("]," + this.getProperties());
        return buff.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean loadTextsFromDB(String _sTextFields) throws WCMException {
        boolean bl;
        Connection oConn = null;
        boolean bOk = false;
        Statement oStmt = null;
        String strSQL = null;
        String strSelect = "DocumentId," + _sTextFields;
        try {
            strSQL = "select " + CMyString.filterForSQL2(strSelect) + " from " + this.getTrueTableName() + " where " + "DocumentId" + "=" + this.getDocId();
            oConn = this.getDBManager().getConnection();
            oStmt = oConn.createStatement();
            ResultSet rsData = oStmt.executeQuery(strSQL);
            if (rsData.next()) {
                StringTokenizer stFields = new StringTokenizer(_sTextFields, ",");
                while (stFields.hasMoreElements()) {
                    String sField = (String)stFields.nextElement();
                    CDBText dbText = new CDBText(this.getDBManager().getDBType());
                    dbText.readFromRs(rsData, sField);
                    this.getProperties(true).put(sField, dbText);
                }
                bOk = true;
            }
            rsData.close();
            bl = bOk;
        }
        catch (Exception ex) {
            try {
                throw new WCMException(40, I18NMessage.get(InfoViewDocument.class, "InfoViewDocument.label4", "\u88c5\u8f7d\u5927\u6587\u672c\u5b57\u6bb5[") + strSQL + I18NMessage.get(InfoViewDocument.class, "InfoViewDocument.label5", "]\u65f6\u5931\u8d25\uff08") + this.getClass().getName() + "loadTextFromDB\uff09", ex);
            }
            catch (Throwable throwable) {
                try {
                    if (oStmt != null) {
                        oStmt.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (oConn != null) {
                    this.getDBManager().freeConnection(oConn);
                }
                throw throwable;
            }
        }
        try {
            if (oStmt != null) {
                oStmt.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (oConn != null) {
            this.getDBManager().freeConnection(oConn);
        }
        return bl;
    }
}

