/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.infoview.persistent;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.content.CMSObj;
import com.trs.components.infoview.InfoViewConstants;
import com.trs.components.infoview.InfoViewHelper;
import com.trs.components.infoview.InfoViewMgr;
import com.trs.components.infoview.persistent.InfoViewField;
import com.trs.components.infoview.persistent.InfoViewFields;
import com.trs.components.infoview.persistent.InfoViewGroup;
import com.trs.components.infoview.persistent.InfoViewGroups;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class InfoView
extends CMSObj {
    public static final int OBJ_TYPE = 1104;
    public static final String DB_TABLE_NAME = "WCMINFOVIEW";
    public static final String DB_ID_NAME = "INFOVIEWID";
    private HashMap m_oMapFields;
    private ArrayList m_oFieldList;
    private List m_oGroupList = null;
    private HashMap m_oMapGroups = null;

    public static final InfoView findById(int id) throws WCMException {
        if (id <= 0) {
            return null;
        }
        return (InfoView)BaseObj.findById(InfoView.class, id);
    }

    public static final InfoView createNewInstance() throws WCMException {
        return (InfoView)BaseObj.createNewInstance(InfoView.class);
    }

    @Override
    public int getWCMType() {
        return 1104;
    }

    @Override
    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    @Override
    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    @Override
    public boolean isValid() throws WCMException {
        if (this.isAddMode()) {
            if (this.getProperty("INFOVIEWNAME") == null) {
                throw new WCMException(1106, I18NMessage.get(InfoView.class, "InfoView.label1", "\u5c5e\u6027INFOVIEWNAME\u6ca1\u6709\u8bbe\u7f6e"));
            }
            if (this.getProperty("TITLEPATTERN") == null) {
                this.setTitlePattern(I18NMessage.get(InfoView.class, "InfoView.label2", "\u81ea\u5b9a\u4e49\u8868\u5355\u6570\u636e"));
            }
        }
        return true;
    }

    private List getFieldList() {
        if (this.m_oFieldList == null) {
            this.m_oMapFields = new HashMap();
            this.m_oFieldList = new ArrayList();
        }
        return this.m_oFieldList;
    }

    public void addField(InfoViewField field) {
        if (field == null) {
            return;
        }
        field.setOwner(this);
        this.getFieldList().add(field);
        this.m_oMapFields.put(field.getName(), field);
    }

    public InfoViewField getField(String name) throws WCMException {
        if (this.m_oMapFields == null) {
            this.allFields();
        }
        return (InfoViewField)this.m_oMapFields.get(name);
    }

    public List allFields() throws WCMException {
        this.m_oFieldList = null;
        this.loadFields();
        return this.getFieldList();
    }

    public List allGroups() throws WCMException {
        this.m_oGroupList = null;
        this.loadGroups();
        return this.getGroupList();
    }

    private List getGroupList() {
        if (this.m_oGroupList == null) {
            this.m_oMapGroups = new HashMap();
            this.m_oGroupList = new ArrayList();
        }
        return this.m_oGroupList;
    }

    public void addGroup(InfoViewGroup group) {
        if (group == null) {
            return;
        }
        this.getGroupList().add(group);
        this.m_oMapGroups.put(group.getName(), group);
    }

    private synchronized void loadGroups() throws WCMException {
        InfoViewGroups groups = null;
        WCMFilter filter = new WCMFilter("", "INFOVIEWID=" + this.getId(), "");
        try {
            groups = new InfoViewGroups(ContextHelper.getLoginUser());
            groups.open(filter);
            for (int i = 0; i < groups.size(); ++i) {
                this.addGroup((InfoViewGroup)groups.getAt(i));
            }
        }
        catch (WCMException ex) {
            throw new WCMException(1100, I18NMessage.get(InfoView.class, "InfoView.label3", "\u83b7\u53d6\u81ea\u5b9a\u4e49\u8868\u5355\u7684\u6570\u636e\u8282\u96c6\u5408\u51fa\u9519"), ex);
        }
    }

    public void removeField(InfoViewField field) {
        if (field == null) {
            return;
        }
        if (this.m_oFieldList != null) {
            this.m_oFieldList.remove(field);
        }
        if (this.m_oMapFields != null) {
            this.m_oMapFields.remove(field.getName());
        }
    }

    private synchronized void loadFields() throws WCMException {
        InfoViewFields fields = null;
        WCMFilter filter = new WCMFilter("", "INFOVIEWID=" + this.getId(), "");
        try {
            fields = new InfoViewFields(ContextHelper.getLoginUser());
            fields.open(filter);
            for (int i = 0; i < fields.size(); ++i) {
                this.addField((InfoViewField)fields.getAt(i));
            }
        }
        catch (WCMException ex) {
            throw new WCMException(1100, I18NMessage.get(InfoView.class, "InfoView.label4", "\u83b7\u53d6\u81ea\u5b9a\u4e49\u8868\u5355\u7684\u6570\u636e\u9879\u96c6\u5408\u51fa\u9519"), ex);
        }
    }

    public int getSiteID() {
        return this.getPropertyAsInt("SITEID", 0);
    }

    public boolean setSiteID(int _iSiteID) throws WCMException {
        return this.setProperty("SITEID", _iSiteID);
    }

    public String getName() {
        return (String)this.getProperty("INFOVIEWNAME");
    }

    public boolean setName(String _sName) throws WCMException {
        return this.setProperty("INFOVIEWNAME", _sName);
    }

    public String getDesc() {
        return (String)this.getProperty("INFOVIEWDESC");
    }

    public boolean setDesc(String _sDesc) throws WCMException {
        return this.setProperty("INFOVIEWDESC", _sDesc);
    }

    public String getTitlePattern() {
        return (String)this.getProperty("TITLEPATTERN");
    }

    public boolean setTitlePattern(String _sTitlePattern) throws WCMException {
        return this.setProperty("TITLEPATTERN", _sTitlePattern);
    }

    public boolean isNeedVerifycode() {
        return this.getPropertyAsBoolean("NEEDVERIFYCODE", true);
    }

    public boolean setNeedVerifycode(boolean isNeedVerifycode) throws WCMException {
        return this.setProperty("NEEDVERIFYCODE", isNeedVerifycode);
    }

    public String getInfoViewPath() {
        return (String)this.getProperty("INFOVIEWPATH");
    }

    public boolean setInfoViewPath(String _sInfoViewPath) throws WCMException {
        return this.setProperty("INFOVIEWPATH", _sInfoViewPath);
    }

    public String getInfoPathFile() {
        return (String)this.getProperty("INFOPATHFILE");
    }

    public boolean setInfoPathFile(String _sInfoPathFile) throws WCMException {
        return this.setProperty("INFOPATHFILE", _sInfoPathFile);
    }

    public String getNewInfoPathFile() {
        return this.getNewPropertyAsString("INFOPATHFILE");
    }

    public String getAllFileList() {
        return (String)this.getProperty("ALLFILELIST");
    }

    public boolean setAllFileList(String _sAllFileList) throws WCMException {
        return this.setProperty("ALLFILELIST", _sAllFileList);
    }

    public String getXSLTFile() {
        return (String)this.getProperty("XSLTFILE");
    }

    public boolean setXSLTFilet(String _sXSLTFile) throws WCMException {
        return this.setProperty("XSLTFILE", _sXSLTFile);
    }

    public String getNewXSLTFile() {
        return (String)this.getProperty("NEWXSLTFILE");
    }

    public boolean setNewXSLTFilet(String _sXSLTFile) throws WCMException {
        return this.setProperty("NEWXSLTFILE", _sXSLTFile);
    }

    public String getSchemaFile() {
        return (String)this.getProperty("SCHEMAFILE");
    }

    public boolean setSchemaFile(String _sSchemaFile) throws WCMException {
        return this.setProperty("SCHEMAFILE", _sSchemaFile);
    }

    public String getTemplateFile() {
        return (String)this.getProperty("TEMPLATEFILE");
    }

    public boolean setTemplateFile(String _sTemplateFile) throws WCMException {
        return this.setProperty("TEMPLATEFILE", _sTemplateFile);
    }

    public String getTemplateFileContent() throws WCMException {
        InfoViewMgr ivm = (InfoViewMgr)DreamFactory.createObjectById("InfoViewMgr");
        return ivm.getTemplateFileContent(this);
    }

    public boolean hasDocSerial() {
        return this.getPropertyAsBoolean("HASDOCSERIAL", false);
    }

    public boolean setDocSerial(boolean zDocSerial) throws WCMException {
        return this.setProperty("HASDOCSERIAL", zDocSerial);
    }

    public String getSerialPattern() {
        return (String)this.getProperty("SERIALPATTERN");
    }

    public boolean setSerialPattern(String _sTemplateFile) throws WCMException {
        return this.setProperty("SERIALPATTERN", _sTemplateFile);
    }

    public int getSerialPeriod() {
        return this.getPropertyAsInt("SERIALPERIOD", 0);
    }

    public boolean setSerialPeriod(int _iSerialPeriod) throws WCMException {
        return this.setProperty("SERIALPERIOD", _iSerialPeriod);
    }

    public String getSerialField() {
        return (String)this.getProperty("SERIALFIELD");
    }

    public boolean setSerialField(String _sTemplateFile) throws WCMException {
        return this.setProperty("SERIALFIELD", _sTemplateFile);
    }

    public boolean isReplyNoticeRequired() {
        return this.getPropertyAsBoolean("REPLYNOTICEREQUIRED", false);
    }

    public boolean setReplyNoticeRequired(boolean _zRequired) throws WCMException {
        return this.setProperty("REPLYNOTICEREQUIRED", _zRequired);
    }

    public String getNoticeRelatedField() {
        return this.getPropertyAsString("NOTICERELATEDFIELD");
    }

    public boolean setNoticeRelatedField(String _sRelatedField) throws WCMException {
        return this.setProperty("NOTICERELATEDFIELD", _sRelatedField);
    }

    public String getNoticeSubjectPattern() {
        return this.getPropertyAsString("NOTICESUBJECTPATTERN");
    }

    public boolean setNoticeSubjectPattern(String _sSubPattern) throws WCMException {
        return this.setProperty("NOTICESUBJECTPATTERN", _sSubPattern);
    }

    public String getNoticeContentPattern() {
        return this.getPropertyAsString("NOTICECONTENTPATTERN");
    }

    public boolean setNoticeContentPattern(String _sContentPattern) throws WCMException {
        return this.setProperty("NOTICECONTENTPATTERN", _sContentPattern);
    }

    public String getOutlineFields() {
        return this.getPropertyAsString("OutlineFields");
    }

    public boolean setOutlineFields(String _sOutlineFields) throws WCMException {
        return this.setProperty("OutlineFields", _sOutlineFields) && this.setOutlineDBFields(this.getDBFieldsByFields(_sOutlineFields));
    }

    public String getSearchFields() {
        return this.getPropertyAsString("SearchFields");
    }

    public boolean setSearchFields(String _sSearchFields) throws WCMException {
        return this.setProperty("SearchFields", _sSearchFields) && this.setSearchDBFields(this.getDBFieldsByFields(_sSearchFields));
    }

    public String getDocContentPattern() {
        return this.getPropertyAsString("DocContentPattern");
    }

    public boolean setDocContentPattern(String _sDocContentPattern) throws WCMException {
        return this.setProperty("DocContentPattern", _sDocContentPattern);
    }

    private String getDBFieldsByFields(String outlineFields) {
        return InfoViewHelper.getDBFieldsByFields(this, outlineFields, true);
    }

    public String getOutlineDBFields() {
        String sResult = this.getPropertyAsString("OutlineDBFields");
        if (CMyString.isEmpty(sResult)) {
            String sOutlineFields = this.getOutlineFields();
            return this.getDBFieldsByFields(sOutlineFields);
        }
        return sResult;
    }

    public boolean setOutlineDBFields(String _sOutlineFields) throws WCMException {
        return this.setProperty("OutlineDBFields", _sOutlineFields);
    }

    public String getOrderField() {
        return this.getPropertyAsString("OrderField");
    }

    public boolean setOrderField(String _sOrderField) throws WCMException {
        return this.setProperty("OrderField", _sOrderField);
    }

    public String getSearchDBFields() {
        String sResult = this.getPropertyAsString("SearchDBFields");
        if (CMyString.isEmpty(sResult)) {
            String sSearchFields = this.getSearchFields();
            return this.getDBFieldsByFields(sSearchFields);
        }
        return sResult;
    }

    public boolean setSearchDBFields(String _sSearchFields) throws WCMException {
        return this.setProperty("SearchDBFields", _sSearchFields);
    }

    public String getTrueTableName() {
        return InfoViewConstants.makeTrueTableName(this.getId());
    }
}

