/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.infoview.helper;

import com.trs.components.infoview.db.InfoviewXMLDataUpdator;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.infra.common.WCMException;
import java.util.HashMap;
import java.util.List;

public abstract class BaseInfoViewFieldValueCreator {
    private Document m_oDocument;
    private InfoviewXMLDataUpdator m_oUpdator;

    public void setDocument(Document _document) {
        this.m_oDocument = _document;
    }

    public Document getDocument() {
        return this.m_oDocument;
    }

    public void createInfoviewXMLDataUpdator() throws WCMException {
        String sDocContent = this.m_oDocument.getContent();
        this.m_oUpdator = new InfoviewXMLDataUpdator(sDocContent);
    }

    public void setInfoViewFieldValue(String _sFieldName, String _sValue) throws WCMException {
        this.m_oUpdator.setProperty(_sFieldName, _sValue);
    }

    public List getInfoViewFieldValue(String sFieldName) throws WCMException {
        return this.m_oUpdator.getFieldValue(sFieldName);
    }

    public void setInfoViewRepeatFieldValue(String _sFieldName, String _sValue, int index) throws WCMException {
        this.m_oUpdator.setRepeatField(_sFieldName, _sValue, index);
    }

    public void addInfoViewRepeatData(String _sFieldName, HashMap _hValue) {
        String sSelfFieldName = _sFieldName.split("_")[1];
        int nSize = this.m_oUpdator.getRepeatFieldSize(sSelfFieldName);
        if (nSize > 0) {
            this.m_oUpdator.addRepeatFieldLine(sSelfFieldName, _hValue);
        } else {
            this.m_oUpdator.addRepeatFieldGroup(_sFieldName, _hValue);
        }
    }

    public void addInfoViewField(String _sFieldName, String _sValue) {
        this.m_oUpdator.addInfoViewField(_sFieldName, _sValue);
    }

    public void updateDocument() throws WCMException {
        this.m_oDocument.setContent(this.m_oUpdator.update(null));
    }

    public int getRepeatFieldIndex(String _sFieldName, String _sFieldValue) throws WCMException {
        List valueList = this.getInfoViewFieldValue(_sFieldName);
        if (valueList == null) {
            return 0;
        }
        for (int i = 0; i < valueList.size(); ++i) {
            if (!valueList.get(i).equals(_sFieldValue)) continue;
            return i + 1;
        }
        return 0;
    }

    protected abstract String getCreatorName();

    public abstract int[] registerRelateInfoViews();

    public abstract void setInfoViewFieldValueBeforeSaveDoc() throws WCMException;
}

