/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.infoview;

import com.trs.cms.auth.persistent.User;
import com.trs.components.wcm.content.persistent.Appendix;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class InfoviewDataProcessor {
    private String m_sAppendixFilePath = null;
    private User m_oCurrUser = null;

    public InfoviewDataProcessor(User _currUser, String _sAppendixFilePath) {
        this.m_oCurrUser = _currUser;
        this.m_sAppendixFilePath = CMyString.setStrEndWith(_sAppendixFilePath, File.separatorChar);
    }

    public com.trs.components.wcm.content.persistent.Document processInfoViewAppendix(com.trs.components.wcm.content.persistent.Document _document) throws Exception {
        Document dom4jDocument = null;
        try {
            StringReader reader = new StringReader(_document.getContent());
            SAXReader xmlReader = new SAXReader();
            dom4jDocument = xmlReader.read((Reader)reader);
        }
        catch (Exception e) {
            throw new WCMException("\u6784\u9020DOM4J\u5bf9\u8c61\u5931\u8d25", e);
        }
        List fileNodes = dom4jDocument.selectNodes("//@FileName");
        this.processAppendix(_document, fileNodes);
        _document.setContent(dom4jDocument.asXML());
        return _document;
    }

    private void processAppendix(com.trs.components.wcm.content.persistent.Document _document, List _nodes) throws Exception {
        FilesMan filesMan = FilesMan.getFilesMan();
        for (int i = 0; i < _nodes.size(); ++i) {
            Node tempNode = (Node)_nodes.get(i);
            Element parent = tempNode.getParent();
            String sAppSrcFile = parent.getTextTrim();
            String sAbsoluteFile = this.m_sAppendixFilePath + sAppSrcFile;
            if (!CMyFile.fileExists(sAbsoluteFile)) continue;
            int nFlag = 10;
            String pathFlag = "P0";
            if (sAppSrcFile == null || sAppSrcFile.equals("")) continue;
            if (sAppSrcFile.charAt(0) == 'W') {
                nFlag = 20;
                pathFlag = "W0";
            }
            String sFileDesc = parent.attributeValue("FileName");
            String sFileExt = CMyFile.extractFileExt(sAppSrcFile);
            String sNewAppFileName = filesMan.getNextFilePathName(pathFlag, sFileExt);
            CMyFile.copyFile(sAbsoluteFile, sNewAppFileName);
            sNewAppFileName = CMyFile.extractFileName(sNewAppFileName);
            parent.setText(sNewAppFileName);
            Appendix appendix = new Appendix();
            appendix.setFlag(nFlag);
            appendix.setSrcFile(sAppSrcFile);
            appendix.setFile(sNewAppFileName);
            appendix.setFileExt(sFileExt);
            appendix.setDesc(CMyString.showNull(sFileDesc, sAppSrcFile));
            appendix.setRelatedColumn(parent.getName());
            appendix.setDocId(_document.getId());
            appendix.setUsedByVersion(_document.getVersion(), true);
            appendix.setSerialNo(i);
            appendix.save(this.m_oCurrUser);
        }
    }
}

