/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.publisher;

import com.trs.components.common.publish.domain.publisher.IEventAfterPublishContent;
import com.trs.components.common.publish.domain.publisher.IPublishEventServer;
import com.trs.components.common.publish.domain.publisher.PublishPageContext;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.infra.BaseServer;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.DebugTimer;
import com.trs.infra.util.WCMDiscoveryFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class PublishEventServer
extends BaseServer
implements IPublishEventServer {
    private static Logger logger = Logger.getLogger(PublishEventServer.class);
    private ArrayList m_arEventAfterPublishContent = null;

    @Override
    protected void doShutdown() {
        this.m_arEventAfterPublishContent.clear();
        this.m_arEventAfterPublishContent = null;
    }

    @Override
    protected boolean doStart() throws WCMException {
        if (this.m_arEventAfterPublishContent != null) {
            return true;
        }
        ArrayList<String> arTemp = new ArrayList<String>(2);
        Iterator itEvents = WCMDiscoveryFactory.getDiscovery().getImplementors(IEventAfterPublishContent.class.getName());
        while (itEvents.hasNext()) {
            String sEventClassName = (String)itEvents.next();
            try {
                Class.forName(sEventClassName).newInstance();
                if (arTemp.indexOf(sEventClassName) >= 0) continue;
                arTemp.add(sEventClassName);
            }
            catch (Throwable e) {
                logger.error((Object)("Fail to init the Implementors[" + sEventClassName + "] of IEventAfterPublishContent!"), e);
            }
        }
        this.m_arEventAfterPublishContent = arTemp;
        return true;
    }

    @Override
    public void onSuccess(IPublishContent _content, String _sPageURL, PublishPageContext _oPageContext) throws WCMException {
        if (this.m_arEventAfterPublishContent == null) {
            this.doStart();
        }
        DebugTimer debugTimer = new DebugTimer();
        int nSize = this.m_arEventAfterPublishContent.size();
        for (int i = 0; i < nSize; ++i) {
            String sEventClassName = (String)this.m_arEventAfterPublishContent.get(i);
            if (logger.isDebugEnabled()) {
                debugTimer.start();
                logger.debug((Object)("Excute the event[" + sEventClassName + "]....."));
            }
            try {
                IEventAfterPublishContent event = (IEventAfterPublishContent)Class.forName(sEventClassName).newInstance();
                event.onSuccess(_content, _sPageURL, _oPageContext);
            }
            catch (Throwable e) {
                logger.error((Object)("Fail to execute the Implementors[" + sEventClassName + "] of IEventAfterPublishContent on success!"), e);
            }
            if (!logger.isDebugEnabled()) continue;
            debugTimer.stop();
            logger.debug((Object)("Excute the event[" + sEventClassName + "] use [" + debugTimer.getTime() + "]ms!"));
        }
    }

    @Override
    public void onFail(IPublishContent _content, String _sPageURL, PublishPageContext _oPageContext) throws WCMException {
        if (this.m_arEventAfterPublishContent == null) {
            this.doStart();
        }
        DebugTimer debugTimer = new DebugTimer();
        int nSize = this.m_arEventAfterPublishContent.size();
        for (int i = 0; i < nSize; ++i) {
            String sEventClassName = (String)this.m_arEventAfterPublishContent.get(i);
            if (logger.isDebugEnabled()) {
                debugTimer.start();
                logger.debug((Object)("Excute the event[" + sEventClassName + "]....."));
            }
            try {
                IEventAfterPublishContent event = (IEventAfterPublishContent)Class.forName(sEventClassName).newInstance();
                event.onFail(_content, _sPageURL, _oPageContext);
            }
            catch (Throwable e) {
                logger.error((Object)("Fail to execute the Implementors[" + sEventClassName + "] of IEventAfterPublishContent on fail!"), e);
            }
            if (!logger.isDebugEnabled()) continue;
            debugTimer.stop();
            logger.debug((Object)("Excute the event[" + sEventClassName + "] use [" + debugTimer.getTime() + "]ms!"));
        }
    }

    @Override
    public List getEvents() throws WCMException {
        if (this.m_arEventAfterPublishContent == null) {
            this.doStart();
        }
        return this.m_arEventAfterPublishContent;
    }
}

