/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.distribute;

import com.trs.components.common.publish.PublishConstants;
import com.trs.components.common.publish.domain.distribute.IFileDistristributor;
import com.trs.components.common.publish.persistent.distribute.PublishDistribution;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.store.FileService;
import com.trs.mlf.log.LogUserUtil;
import com.trs.mlf.simplelog.LogConstant;
import com.trs.mlf.simplelog.SimpleLogServer;
import java.io.File;
import org.apache.log4j.Logger;

public class FileDistributorImpFileLocal
implements IFileDistristributor {
    private static final Logger s_logger = Logger.getLogger(FileDistributorImpFileLocal.class);
    private static final Object s_locker = new Object();
    private int m_iDistributionID;
    private String m_sRootDirectory;

    @Override
    public int getConfigID() {
        return this.m_iDistributionID;
    }

    @Override
    public void setTargetRoot(PublishDistribution _distribution) throws Exception {
        this.m_iDistributionID = _distribution.getId();
        this.m_sRootDirectory = CMyString.setStrEndWith(_distribution.getDataPath(), File.separatorChar);
        if (CMyString.isEmpty(this.m_sRootDirectory)) {
            throw new Exception("Root directory of local distribution target [ID=" + _distribution.getId() + "] not set!");
        }
    }

    @Override
    public void distributeFile(String _sLocal, String _sPath, boolean _bCheckDstFileExits) throws Exception {
        String sDestPathName = this.reviseDestPath(_sPath);
        this.insureDestPath(sDestPathName);
        sDestPathName = sDestPathName + CMyFile.extractFileName(_sLocal);
        if (_bCheckDstFileExits && CMyFile.fileExists(sDestPathName)) {
            return;
        }
        boolean isSuccess = false;
        isSuccess = CMyFile.copyFile(_sLocal, sDestPathName, true);
        if (isSuccess) {
            SimpleLogServer.distribute(LogConstant.Module.OTHERMODULE.desc, LogUserUtil.getLogUser(), "", String.format("\u6dfb\u52a0\u6216\u4fee\u6539\u6587\u4ef6[%s]\uff0c\u8def\u5f84[%s]", CMyFile.extractFileName(_sLocal), sDestPathName));
        }
    }

    @Override
    public boolean renameFile(String _sSourceFile, String _sTargetFile, String _sFullDataPath) throws Exception {
        String sDestPath = this.reviseDestPath(_sFullDataPath);
        String sSourcePathName = sDestPath + _sSourceFile;
        String sTragetPathName = sDestPath + _sTargetFile;
        if (s_logger.isDebugEnabled()) {
            SimpleLogServer.distribute(LogConstant.Module.OTHERMODULE.desc, LogUserUtil.getLogUser(), "", String.format("\u91cd\u547d\u540d[%s]\u5230[%s]", sSourcePathName, sTragetPathName));
        }
        return CMyFile.moveFile(sSourcePathName, sTragetPathName);
    }

    @Override
    public boolean withdrawFile(String _sFile, String _sPath) throws Exception {
        String sFilePathName = this.reviseDestPath(_sPath) + _sFile;
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("to delete file [" + sFilePathName + "]"));
        }
        boolean isSuccess = false;
        isSuccess = CMyFile.deleteFile(sFilePathName);
        if (isSuccess) {
            SimpleLogServer.distribute(LogConstant.Module.OTHERMODULE.desc, LogUserUtil.getLogUser(), "", String.format("\u5220\u9664\u6587\u4ef6[%s]\uff0c\u8def\u5f84[%s]", _sFile, sFilePathName));
        }
        return isSuccess;
    }

    @Override
    public boolean withdrawPath(String _sPath) throws Exception {
        String sPathName = this.reviseDestPath(_sPath);
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("to delete path [" + sPathName + "]"));
        }
        boolean isSuccess = false;
        isSuccess = this.renamePath(sPathName);
        if (isSuccess) {
            SimpleLogServer.distribute(LogConstant.Module.OTHERMODULE.desc, LogUserUtil.getLogUser(), "", String.format("\u5220\u9664\u6587\u4ef6\u8def\u5f84[%s]", sPathName));
        }
        return isSuccess;
    }

    private boolean renamePath(String path) {
        FileService file = new FileService(path);
        if (!file.exists() && !file.isDirectory()) {
            return true;
        }
        return file.renameTo(new FileService(file.getParentFileStore(), PublishConstants.makeDeletedPathName(file.getName())));
    }

    private String reviseDestPath(String _sSubPath) {
        if (File.separatorChar != '/') {
            _sSubPath = _sSubPath.replace('/', File.separatorChar);
        }
        return this.m_sRootDirectory + CMyString.setStrEndWith(_sSubPath, File.separatorChar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insureDestPath(String _sPath) throws WCMException {
        FileService file = new FileService(_sPath);
        if (file.exists()) {
            return;
        }
        try {
            Object object = s_locker;
            synchronized (object) {
                file = new FileService(_sPath);
                if (!file.exists()) {
                    file.mkdirs();
                }
            }
        }
        catch (Exception ex) {
            throw new WCMException(50, "Failed to create directroy [" + _sPath + "] on disk!", ex);
        }
        file = new FileService(_sPath);
        if (!file.exists()) {
            throw new WCMException(50, "Failed to create directroy [" + _sPath + "] on disk![Double Check]");
        }
    }
}

