/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.distribute;

import com.trs.cms.auth.persistent.User;
import com.trs.components.common.message.notify.NotificationServer;
import com.trs.components.common.message.notify.Notifier;
import com.trs.components.common.publish.persistent.distribute.PublishDistribution;
import com.trs.components.common.publish.persistent.distribute.PublishDistributions;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.cache.ICacheMgr;
import com.trs.infra.util.ftp.FtpMgr;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.aton.container.ContainerUtil;

public class FileDistributorFtpCacheMgr
implements ICacheMgr {
    private static Logger logger = Logger.getLogger(FileDistributorFtpCacheMgr.class);
    private Map m_hFtpMgrCache = null;

    private Map getFtpMgrCache() {
        if (this.m_hFtpMgrCache == null) {
            this.init();
        }
        return this.m_hFtpMgrCache;
    }

    @Override
    public synchronized void clear() {
        if (this.m_hFtpMgrCache == null) {
            return;
        }
        ContainerUtil.clearContainer((Map)this.m_hFtpMgrCache);
        this.m_hFtpMgrCache = null;
    }

    public FtpMgr lookupFtpMgr(PublishDistribution _distribution) {
        return (FtpMgr)this.getFtpMgrCache().get(_distribution.getKey());
    }

    @Override
    public synchronized boolean init() {
        if (this.m_hFtpMgrCache != null) {
            return true;
        }
        HashMap aCache = null;
        try {
            PublishDistributions aPublishDistributions = PublishDistributions.openWCMObjs(User.getSystem(), new WCMFilter("", "TargetType='FTP'", ""));
            int nCount = aPublishDistributions.size();
            aCache = new HashMap(nCount);
            for (int i = 0; i < nCount; ++i) {
                this.putDistribution((PublishDistribution)aPublishDistributions.getAt(i), aCache);
            }
        }
        catch (WCMException ex) {
            logger.error((Object)I18NMessage.get(FileDistributorFtpCacheMgr.class, "FileDistributorFtpCacheMgr.label1", "\u521d\u59cb\u5316FTP\u5206\u53d1\u7f13\u51b2\u670d\u52a1\u5668\u5931\u8d25\uff01"), (Throwable)ex);
            return false;
        }
        this.m_hFtpMgrCache = aCache;
        return true;
    }

    @Override
    public boolean reinit() {
        this.clear();
        this.init();
        return false;
    }

    @Override
    public void notifyOnAddObj(BaseObj _oObjAdded) {
        PublishDistribution aPublishDistribution = (PublishDistribution)_oObjAdded;
        if (aPublishDistribution.getTargetType().equalsIgnoreCase("FTP")) {
            this.putDistribution(aPublishDistribution, this.getFtpMgrCache());
        }
    }

    @Override
    public void notifyOnDelObj(BaseObj _oObjDeleted, int _nEventType) {
        PublishDistribution aPublishDistribution = (PublishDistribution)_oObjDeleted;
        if (aPublishDistribution.getTargetType().equalsIgnoreCase("FTP")) {
            this.removeDistribution(aPublishDistribution);
        }
    }

    @Override
    public void notifyOnModifyObj(BaseObj _oObjModified, int _nEventType) {
        PublishDistribution aPublishDistribution = (PublishDistribution)_oObjModified;
        if (aPublishDistribution.getTargetType().equalsIgnoreCase("FTP")) {
            this.removeDistribution(aPublishDistribution);
            this.putDistribution(aPublishDistribution, this.getFtpMgrCache());
        }
    }

    private void putDistribution(PublishDistribution _distribution, Map _cache) {
        Integer key = _distribution.getKey();
        if (_cache.get(key) != null) {
            return;
        }
        FtpMgr aMgr = this.makeFtpMgr(_distribution);
        if (aMgr == null) {
            return;
        }
        _cache.put(key, aMgr);
    }

    private FtpMgr makeFtpMgr(PublishDistribution _distribution) {
        FtpMgr aMgr = new FtpMgr();
        aMgr.setCheckWriteAuth(true);
        try {
            aMgr.init(_distribution.getTargetServer(), _distribution.getLoginUser(), _distribution.getLoginPassword(), _distribution.getDataPath(), false, 10);
            return aMgr;
        }
        catch (Exception ex) {
            String EVENT = "Publish.WhenMakeFTPConnectionError";
            if (NotificationServer.getInstance().needNotifyForEvent("Publish.WhenMakeFTPConnectionError")) {
                Notifier notifier = new Notifier();
                notifier.setParameter("FTPDistributionInfo", _distribution.toString());
                notifier.setParameter("Message", I18NMessage.get(FileDistributorFtpCacheMgr.class, "FileDistributorFtpCacheMgr.label2", "\u5efa\u7acbFTP\u8fde\u63a5\u5931\u8d25!\n\u5206\u53d1\u4fe1\u606f\u4e3a\uff1a") + _distribution);
                try {
                    notifier.executeOnEvent("Publish.WhenMakeFTPConnectionError");
                }
                catch (WCMException e) {
                    e.printStackTrace();
                }
            }
            logger.error((Object)(I18NMessage.get(FileDistributorFtpCacheMgr.class, "FileDistributorFtpCacheMgr.label3", "\u521d\u59cb\u5316\u5206\u53d1\u76ee\u5f55\u7684FTP\u5931\u8d25\uff01") + _distribution), (Throwable)ex);
            return null;
        }
    }

    private void removeDistribution(PublishDistribution _distribution) {
        Integer key = _distribution.getKey();
        FtpMgr aMgr = (FtpMgr)this.getFtpMgrCache().get(key);
        if (aMgr != null) {
            aMgr.clear();
            this.getFtpMgrCache().remove(key);
        }
    }
}

