/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.address;

import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.address.Contact;
import com.trs.components.common.message.ISendWorker;
import com.trs.components.common.message.Message;
import com.trs.components.common.message.MessageSendingMapper;
import com.trs.components.common.message.MessageServer;
import com.trs.components.common.message.MsgSendWorker;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyString;

public class ContactMsgSender {
    public static void send(String _sTitle, String _sContent, String _sSendType, Contact _toContact) throws WCMException {
        if (_sSendType == null || _sSendType.length() == 0) {
            throw new WCMException(10, I18NMessage.get(ContactMsgSender.class, "ContactMsgSender.label1", "\u6ca1\u6709\u6307\u5b9a\u53d1\u9001\u7c7b\u578b!"));
        }
        if (_toContact == null) {
            throw new WCMException(10, I18NMessage.get(ContactMsgSender.class, "ContactMsgSender.label2", "\u65e0\u6548\u7684\u8054\u7cfb\u4eba\u5bf9\u8c61[null]!"));
        }
        if (_toContact.isSystemUser()) {
            ContactMsgSender.sendToSystemUser(_sTitle, _sContent, _sSendType, _toContact);
        } else {
            ContactMsgSender.sendTo(_sTitle, _sContent, _sSendType, _toContact);
        }
    }

    private static void sendTo(String _sTitle, String _sContent, String _sSendType, Contact _toContact) throws WCMException {
        Message message = Message.createNewInstance();
        message.setTitle(_sTitle);
        message.setBody(_sContent);
        message.setCrUser(_toContact.getCrUser());
        String[] arSendTypeNames = CMyString.split(_sSendType, ",");
        ISendWorker worker = null;
        for (int i = 0; i < arSendTypeNames.length; ++i) {
            String sBeanId = MessageSendingMapper.getInstance().getWorker(arSendTypeNames[i]);
            if (sBeanId == null) {
                throw new WCMException(1354, "Unknown message send type: " + arSendTypeNames[i]);
            }
            worker = (ISendWorker)DreamFactory.createObjectById(sBeanId);
            if (worker instanceof MsgSendWorker) {
                return;
            }
            worker.send(message, new ContactAdapter(_toContact));
        }
    }

    private static void sendToSystemUser(String _sTitle, String _sContent, String _sSendType, Contact _toContact) throws WCMException {
        Message message = Message.createNewInstance();
        message.setTitle(_sTitle);
        message.setBody(_sContent);
        message.setCrUser(_toContact.getCrUser());
        message.setReceivers(204, _toContact.getSystemUserId());
        message.setSendTypes(_sSendType);
        MessageServer.send(message);
    }

    private static class ContactAdapter
    extends User {
        private Contact m_contact;

        public ContactAdapter(Contact _contact) {
            this.m_contact = _contact;
        }

        @Override
        public String getName() {
            return this.m_contact.getUserName();
        }

        @Override
        public String getMobile() {
            return this.m_contact.getMobile();
        }

        @Override
        public String getEmail() {
            return this.m_contact.getEmail();
        }
    }
}

