/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.process;

import com.trs.cms.process.engine.FlowDoc;
import com.trs.cms.process.engine.FlowDocs;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;

public class FlowEngineHelper {
    public static String makeTogetherComments(int _nParentFlowDocId) throws WCMException {
        WCMFilter filter = new WCMFilter("", "Flag=? and PreFlowDocId in(select FlowDocId from WCMFlowDoc where Worked=1 and ParentId=? )", "WorkTime Desc", "FlowDocId,PostUser,PostDesc");
        filter.addSearchValues(10);
        filter.addSearchValues(_nParentFlowDocId);
        return FlowEngineHelper.makeComments(filter);
    }

    private static String makeComments(WCMFilter _filter) throws WCMException {
        FlowDocs flowDocs = new FlowDocs(null);
        flowDocs.setMaxSize(100);
        flowDocs.setMaxBufferSize(101);
        flowDocs.open(_filter);
        StringBuffer sbResult = new StringBuffer(flowDocs.size() * 100);
        int nSize = flowDocs.size();
        for (int i = 0; i < nSize; ++i) {
            String sPostDesc;
            FlowDoc flowDoc = (FlowDoc)flowDocs.getAt(i);
            if (flowDoc == null || (sPostDesc = flowDoc.getPostDesc()) == null || (sPostDesc = sPostDesc.trim()).length() == 0) continue;
            sbResult.append("~~");
            sbResult.append(flowDoc.getPostUserTrueName());
            sbResult.append("~~");
            sbResult.append(sPostDesc);
        }
        return sbResult.toString();
    }

    public static String makeSeperateComments(FlowDoc _currFlowDoc) throws WCMException {
        WCMFilter filter = new WCMFilter("", "ObjType=? and ObjId=? and WorkModal=? and Worked=1", "WorkTime Desc", "FlowDocId,PostUser,PostDesc");
        filter.addSearchValues(_currFlowDoc.getContentType());
        filter.addSearchValues(_currFlowDoc.getContentId());
        filter.addSearchValues(11);
        return FlowEngineHelper.makeComments(filter);
    }

    public static String[] parseComments(FlowDoc _flowDoc) {
        String sPostDesc = _flowDoc.getPostDesc();
        if (sPostDesc == null || (sPostDesc = sPostDesc.trim()).length() == 0) {
            return null;
        }
        if (!sPostDesc.startsWith("~~")) {
            return new String[]{_flowDoc.getPostUserTrueName(), sPostDesc};
        }
        return sPostDesc.substring("~~".length()).split("~~");
    }

    public static void main(String[] args) {
        String sPostDesc = "~~user1~~121313123~~user2~~1213";
        if (!sPostDesc.startsWith("~~")) {
            System.out.println(I18NMessage.get(FlowEngineHelper.class, "FlowEngineHelper.label1", "\u5355\u4eba"));
        }
        System.out.println(sPostDesc.substring("~~".length()).split("~~").length);
    }
}

