/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.auth.domain;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.GroupMgr;
import com.trs.cms.auth.domain.UserMgr;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.Role;
import com.trs.cms.auth.persistent.RoleUser;
import com.trs.cms.auth.persistent.RoleUsers;
import com.trs.cms.auth.persistent.Roles;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.IdFilterSqlUtil;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import org.apache.log4j.Logger;

public class RoleMgr {
    private static final Logger m_oLogger = Logger.getLogger((String)RoleMgr.class.getName());

    public boolean addUser(User _dstUser, Role _theRole) throws WCMException {
        if (_dstUser == null || !_dstUser.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(RoleMgr.class, "RoleMgr.label1", "\u8981\u52a0\u5165\u89d2\u8272\u7684\u7528\u6237\u5bf9\u8c61\u65e0\u6548\uff08Role.addUser\uff09"));
        }
        if (ContextHelper.getLoginUser() == null || !ContextHelper.getLoginUser().isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(RoleMgr.class, "RoleMgr.label2", "\u6267\u884c\u6dfb\u52a0\u64cd\u4f5c\u7684\u7528\u6237\u5bf9\u8c61\u65e0\u6548\uff08Role.addUser\uff09"));
        }
        if (_theRole == null || !_theRole.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(RoleMgr.class, "RoleMgr.label3", "\u6307\u5b9a\u7684\u89d2\u8272\u65e0\u6548!"));
        }
        try {
            RoleUser newRoleUser = this.getRoleUser(_dstUser, _theRole);
            if (newRoleUser != null) {
                return false;
            }
            newRoleUser = RoleUser.createNewInstance();
            newRoleUser.setRoleId(_theRole.getId());
            newRoleUser.setUserId(_dstUser.getId());
            newRoleUser.setCrUser(ContextHelper.getLoginUser());
            newRoleUser.insert(ContextHelper.getLoginUser());
        }
        catch (Exception ex) {
            throw new WCMException(0, I18NMessage.get(RoleMgr.class, "RoleMgr.label4", "\u6dfb\u52a0\u6307\u5b9a\u7528\u6237\u5230\u89d2\u8272\u65f6\u51fa\u9519!"), ex);
        }
        return true;
    }

    public boolean addUser(Role _theRole, int _nSiteId, User _dstUser) throws WCMException {
        if (_dstUser == null || !_dstUser.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(RoleMgr.class, "RoleMgr.label1", "\u8981\u52a0\u5165\u89d2\u8272\u7684\u7528\u6237\u5bf9\u8c61\u65e0\u6548\uff08Role.addUser\uff09"));
        }
        if (ContextHelper.getLoginUser() == null || !ContextHelper.getLoginUser().isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(RoleMgr.class, "RoleMgr.label2", "\u6267\u884c\u6dfb\u52a0\u64cd\u4f5c\u7684\u7528\u6237\u5bf9\u8c61\u65e0\u6548\uff08Role.addUser\uff09"));
        }
        if (_theRole == null || !_theRole.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(RoleMgr.class, "RoleMgr.label3", "\u6307\u5b9a\u7684\u89d2\u8272\u65e0\u6548!"));
        }
        try {
            RoleUser newRoleUser = this.getRoleUser(_theRole, _nSiteId, _dstUser);
            if (newRoleUser != null) {
                return false;
            }
            newRoleUser = RoleUser.createNewInstance();
            newRoleUser.setRoleId(_theRole.getId());
            newRoleUser.setUserId(_dstUser.getId());
            newRoleUser.setSiteId(_nSiteId);
            newRoleUser.setCrUser(ContextHelper.getLoginUser());
            newRoleUser.insert(ContextHelper.getLoginUser());
        }
        catch (Exception ex) {
            throw new WCMException(0, I18NMessage.get(RoleMgr.class, "RoleMgr.label4", "\u6dfb\u52a0\u6307\u5b9a\u7528\u6237\u5230\u89d2\u8272\u65f6\u51fa\u9519!"), ex);
        }
        return true;
    }

    public boolean removeUser(User _dstUser, Role _theRole) throws WCMException {
        if (_dstUser == null || !_dstUser.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(RoleMgr.class, "RoleMgr.label5", "\u8981\u4ece\u89d2\u8272\u4e2d\u5220\u9664\u7684\u7528\u6237\u5bf9\u8c61\u65e0\u6548\uff08Role.removeUser\uff09"));
        }
        if (ContextHelper.getLoginUser() == null || !ContextHelper.getLoginUser().isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(RoleMgr.class, "RoleMgr.label6", "\u6267\u884c\u5220\u9664\u64cd\u4f5c\u7684\u7528\u6237\u65e0\u6548\uff08Role.removeUser\uff09"));
        }
        if ("admin".equals(_dstUser.getName()) && _theRole.getId() == 1) {
            throw new WCMException(10, I18NMessage.get(RoleMgr.class, "RoleMgr.label20", "\u4e0d\u80fd\u5c06admin\u7528\u6237\u4ece\u7cfb\u7edf\u7ba1\u7406\u5458\u89d2\u8272\u4e2d\u79fb\u9664\uff08Role.removeUser\uff09"));
        }
        if (_theRole == null || !_theRole.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(RoleMgr.class, "RoleMgr.label3", "\u6307\u5b9a\u7684\u89d2\u8272\u65e0\u6548!"));
        }
        try {
            RoleUser aRoleUser = this.getRoleUser(_dstUser, _theRole);
            if (aRoleUser == null) {
                return false;
            }
            aRoleUser.delete(ContextHelper.getLoginUser());
        }
        catch (Exception ex) {
            throw new WCMException(0, I18NMessage.get(RoleMgr.class, "RoleMgr.label7", "\u4ece\u89d2\u8272\u4e2d\u5220\u9664\u6307\u5b9a\u7528\u6237\u65f6\u5931\u8d25"), ex);
        }
        return true;
    }

    public boolean removeUser(Role _theRole, int _nSiteId, User _dstUser) throws WCMException {
        if (_dstUser == null || !_dstUser.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(RoleMgr.class, "RoleMgr.label5", "\u8981\u4ece\u89d2\u8272\u4e2d\u5220\u9664\u7684\u7528\u6237\u5bf9\u8c61\u65e0\u6548\uff08Role.removeUser\uff09"));
        }
        if (ContextHelper.getLoginUser() == null || !ContextHelper.getLoginUser().isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(RoleMgr.class, "RoleMgr.label6", "\u6267\u884c\u5220\u9664\u64cd\u4f5c\u7684\u7528\u6237\u65e0\u6548\uff08Role.removeUser\uff09"));
        }
        if ("admin".equals(_dstUser.getName()) && _theRole.getId() == 1) {
            throw new WCMException(10, I18NMessage.get(RoleMgr.class, "RoleMgr.label20", "\u4e0d\u80fd\u5c06admin\u7528\u6237\u4ece\u7cfb\u7edf\u7ba1\u7406\u5458\u89d2\u8272\u4e2d\u79fb\u9664\uff08Role.removeUser\uff09"));
        }
        if (_theRole == null || !_theRole.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(RoleMgr.class, "RoleMgr.label3", "\u6307\u5b9a\u7684\u89d2\u8272\u65e0\u6548!"));
        }
        try {
            RoleUser aRoleUser = this.getRoleUser(_theRole, _nSiteId, _dstUser);
            if (aRoleUser == null) {
                return false;
            }
            aRoleUser.delete(ContextHelper.getLoginUser());
        }
        catch (Exception ex) {
            throw new WCMException(0, I18NMessage.get(RoleMgr.class, "RoleMgr.label7", "\u4ece\u89d2\u8272\u4e2d\u5220\u9664\u6307\u5b9a\u7528\u6237\u65f6\u5931\u8d25"), ex);
        }
        return true;
    }

    public Roles getRoles() throws WCMException {
        WCMFilter aFilter = new WCMFilter("WCMROLE", "", "");
        return Roles.openWCMObjs(ContextHelper.getLoginUser(), aFilter);
    }

    public Users getUsers(Role _dstRole, int _nSiteId, WCMFilter _filter) throws WCMException {
        if (_dstRole == null) {
            throw new WCMException(10, I18NMessage.get(RoleMgr.class, "RoleMgr.label8", "\u65e0\u6548\u7684\u89d2\u8272\u5bf9\u8c61,\u65e0\u6cd5\u83b7\u53d6\u62c5\u4efb\u8be5\u89d2\u8272\u7684\u7528\u6237!"));
        }
        WCMFilter aFilter = new WCMFilter("", "EXISTS(SELECT RoleId FROM WCMRoleUser WHERE WCMRoleUser.UserId=WCMUser.UserId AND RoleId=? AND SITEID=?)", "", "UserId");
        aFilter.addSearchValues(_dstRole.getId());
        aFilter.addSearchValues(_nSiteId);
        aFilter.mergeWith(_filter);
        return Users.openWCMObjs(ContextHelper.getLoginUser(), aFilter);
    }

    public Users getUsers(Role _dstRole, WCMFilter _filter) throws WCMException {
        if (_dstRole == null) {
            throw new WCMException(10, I18NMessage.get(RoleMgr.class, "RoleMgr.label8", "\u65e0\u6548\u7684\u89d2\u8272\u5bf9\u8c61,\u65e0\u6cd5\u83b7\u53d6\u62c5\u4efb\u8be5\u89d2\u8272\u7684\u7528\u6237!"));
        }
        WCMFilter aFilter = new WCMFilter("", "EXISTS(SELECT RoleId FROM WCMRoleUser WHERE WCMRoleUser.UserId=WCMUser.UserId AND RoleId=" + _dstRole.getId() + " and SiteId=" + -1 + ")", "", "UserId");
        aFilter.mergeWith(_filter);
        return Users.openWCMObjs(ContextHelper.getLoginUser(), aFilter);
    }

    public Users getUsersBySystemRoleForUser(Role _dstRole, int _nSiteId, WCMFilter _filter) throws WCMException {
        if (_dstRole == null) {
            throw new WCMException(10, I18NMessage.get(RoleMgr.class, "RoleMgr.label8", "\u65e0\u6548\u7684\u89d2\u8272\u5bf9\u8c61,\u65e0\u6cd5\u83b7\u53d6\u62c5\u4efb\u8be5\u89d2\u8272\u7684\u7528\u6237!"));
        }
        User loginUser = ContextHelper.getLoginUser();
        if (loginUser.isSecurityAdmin()) {
            return this.getUsers(_dstRole, _nSiteId, _filter);
        }
        GroupMgr groupMgr = (GroupMgr)DreamFactory.createObjectById("GroupMgr");
        Groups groups = groupMgr.getOffspringGroups(loginUser, null);
        String sGroupIds = groups.getIdListAsString();
        if (CMyString.isEmpty(sGroupIds)) {
            sGroupIds = "0";
        }
        String sSQL = IdFilterSqlUtil.makeAsString("GroupId", sGroupIds);
        String sWhere = "exists (select 1 from WCMRoleUser where RoleId=? and SiteId = ? and WCMRoleUser.UserId = WCMUser.UserId) and exists(select 1 from WCMGrpUser where " + sSQL + " and WCMUser.UserId=WCMGrpUser.UserId)";
        WCMFilter aFilter = new WCMFilter("", sWhere, "", "UserId");
        aFilter.addSearchValues(_dstRole.getId());
        aFilter.addSearchValues(_nSiteId);
        aFilter.mergeWith(_filter);
        return Users.openWCMObjs(ContextHelper.getLoginUser(), aFilter);
    }

    public Users getUsersBySpecailForUser(Role _dstRole, WCMFilter _filter) throws WCMException {
        if (_dstRole == null) {
            throw new WCMException(10, I18NMessage.get(RoleMgr.class, "RoleMgr.label8", "\u65e0\u6548\u7684\u89d2\u8272\u5bf9\u8c61,\u65e0\u6cd5\u83b7\u53d6\u62c5\u4efb\u8be5\u89d2\u8272\u7684\u7528\u6237!"));
        }
        User loginUser = ContextHelper.getLoginUser();
        if (loginUser.isSecurityAdmin()) {
            return this.getUsers(_dstRole, _filter);
        }
        GroupMgr groupMgr = (GroupMgr)DreamFactory.createObjectById("GroupMgr");
        Groups groups = groupMgr.getOffspringGroups(loginUser, null);
        String sGroupIds = groups.getIdListAsString();
        if (CMyString.isEmpty(sGroupIds)) {
            sGroupIds = "0";
        }
        String sSQL = IdFilterSqlUtil.makeAsString("GroupId", sGroupIds);
        String sWhere = "exists (select 1 from WCMRoleUser where RoleId=? and SiteId=? and WCMRoleUser.UserId = WCMUser.UserId) and exists(select 1 from WCMGrpUser where " + sSQL + " and WCMUser.UserId=WCMGrpUser.UserId)";
        WCMFilter aFilter = new WCMFilter("", sWhere, "", "UserId");
        aFilter.addSearchValues(_dstRole.getId());
        aFilter.addSearchValues(-1);
        aFilter.mergeWith(_filter);
        return Users.openWCMObjs(ContextHelper.getLoginUser(), aFilter);
    }

    public boolean delete(Role _roleToDelete, boolean _bDrop) throws WCMException {
        if (_roleToDelete == null) {
            throw new WCMException(10, I18NMessage.get(RoleMgr.class, "RoleMgr.label9", "\u65e0\u6548\u7684\u89d2\u8272\u5bf9\u8c61,\u65e0\u6cd5\u5220\u9664!"));
        }
        if (!_bDrop) {
            throw new WCMException(10, I18NMessage.get(RoleMgr.class, "RoleMgr.label10", "\u4e0d\u652f\u6301\u5c06\u89d2\u8272\u5220\u9664\u5230\u56de\u6536\u7ad9\u7684\u64cd\u4f5c\uff01"));
        }
        if (_roleToDelete.isSysDefined()) {
            throw new WCMException(1100, I18NMessage.get(RoleMgr.class, "RoleMgr.label11", "\u89d2\u8272[") + _roleToDelete.getName() + I18NMessage.get(RoleMgr.class, "RoleMgr.label12", "]\u662f\u7cfb\u7edf\u9884\u5b9a\u4e49\u7684\u89d2\u8272,\u4e0d\u5141\u8bb8\u5220\u9664!"));
        }
        Users currUsers = this.getUsers(_roleToDelete, null);
        if (currUsers != null && !currUsers.isEmpty()) {
            for (int i = 0; i < currUsers.size(); ++i) {
                this.removeUser((User)currUsers.getAt(i), _roleToDelete);
            }
        }
        _roleToDelete.delete(ContextHelper.getLoginUser());
        return true;
    }

    public Role save(Role _currRole) throws WCMException {
        m_oLogger.debug((Object)I18NMessage.get(RoleMgr.class, "RoleMgr.label13", "\u3010LOG\u3011\u5f00\u59cb\u4fdd\u5b58\u89d2\u8272\uff1aRoleMgr.save"));
        if (_currRole == null) {
            throw new WCMException(10, I18NMessage.get(RoleMgr.class, "RoleMgr.label14", "\u89d2\u8272\u5bf9\u8c61\u4e3a\u7a7a,\u65e0\u6cd5\u4fdd\u5b58!"));
        }
        this.validate(_currRole);
        _currRole = this.prepareSave(_currRole);
        _currRole.save(ContextHelper.getLoginUser());
        return _currRole;
    }

    private void validate(Role _currRole) throws WCMException {
        User loginUser = ContextHelper.getLoginUser();
        if (_currRole == null) {
            throw new WCMException(20, I18NMessage.get(RoleMgr.class, "RoleMgr.label15", "\u89d2\u8272\u4e3a\u7a7a\uff01"));
        }
        if (!loginUser.isSecurityAdmin() && _currRole.getRoleType() == -1) {
            throw new WCMException(1002, I18NMessage.get(RoleMgr.class, "RoleMgr.label19", "\u60a8\u6ca1\u6709\u6743\u9650\u521b\u5efa\u7cfb\u7edf\u7ea7\u89d2\u8272\uff01"));
        }
        if (_currRole.getName() == null || _currRole.getName().trim().length() == 0) {
            throw new WCMException(10, I18NMessage.get(RoleMgr.class, "RoleMgr.label16", "\u89d2\u8272\u540d\u4e3a\u7a7a\uff01"));
        }
        String sRoleName = _currRole.getName();
        if (_currRole.isAddMode() && this.getByName(sRoleName) != null) {
            throw new WCMException(10, CMyString.format(I18NMessage.get(RoleMgr.class, "RoleMgr.label17", "\u89d2\u8272\u540d[{0}]\u5df2\u7ecf\u5b58\u5728\uff01"), new String[]{sRoleName}));
        }
        String sRelateSiteIds = _currRole.getFinalPropertyAsString("RelateSiteIds");
        if (_currRole.isAddMode() && _currRole.getRoleType() == -2 && CMyString.isEmpty(sRelateSiteIds)) {
            throw new WCMException(1106, CMyString.format(I18NMessage.get(RoleMgr.class, "RoleMgr.label18", "\u7ad9\u70b9\u7ea7\u89d2\u8272[{0}]\u6240\u5c5e\u7ad9\u70b9\u4e3a\u7a7a\uff01"), new String[]{sRoleName}));
        }
        sRelateSiteIds = null;
    }

    private Role prepareSave(Role _currRole) throws WCMException {
        if (_currRole.getProperty("SYSDEFINED") == null) {
            _currRole.setSysDefined(false);
        }
        return _currRole;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Role getByName(String _sRoleName) throws WCMException {
        WCMFilter aFilter = new WCMFilter("WCMROLE", "RoleName='" + CMyString.filterForSQL(_sRoleName) + "'", "", "RoleId", 1);
        Roles aRoles = Roles.openWCMObjs(ContextHelper.getLoginUser(), aFilter);
        if (aRoles.isEmpty()) {
            return null;
        }
        try {
            Role role = (Role)aRoles.getAt(0);
            return role;
        }
        finally {
            if (aRoles != null) {
                aRoles.clear();
            }
        }
    }

    private RoleUser getRoleUser(User _dstUser, Role _theRole) throws WCMException {
        WCMFilter aFilter = new WCMFilter("WCMROLEUSER", "UserId=" + _dstUser.getId() + " AND RoleId=" + _theRole.getId(), "", "", 1);
        RoleUsers aRoleUsers = RoleUsers.openWCMObjs(ContextHelper.getLoginUser(), aFilter);
        if (aRoleUsers.isEmpty()) {
            return null;
        }
        return (RoleUser)aRoleUsers.getAt(0);
    }

    private RoleUser getRoleUser(Role _theRole, int _nSiteId, User _dstUser) throws WCMException {
        WCMFilter aFilter = new WCMFilter("WCMROLEUSER", "UserId=" + _dstUser.getId() + " AND RoleId=" + _theRole.getId() + " AND SiteId=" + _nSiteId, "", "", 1);
        RoleUsers aRoleUsers = RoleUsers.openWCMObjs(ContextHelper.getLoginUser(), aFilter);
        if (aRoleUsers.isEmpty()) {
            return null;
        }
        return (RoleUser)aRoleUsers.getAt(0);
    }

    public RoleUsers getRoleUsers(Role _theRole, WCMFilter _filter) throws WCMException {
        WCMFilter aFilter = new WCMFilter("WCMROLEUSER", "RoleId=" + _theRole.getId(), "");
        aFilter.mergeWith(_filter);
        return RoleUsers.openWCMObjs(ContextHelper.getLoginUser(), aFilter);
    }

    public RoleUsers getRoleUsers(User _theUser, WCMFilter _filter) throws WCMException {
        WCMFilter aFilter = new WCMFilter("WCMROLEUSER", "UserId=" + _theUser.getId(), "");
        aFilter.mergeWith(_filter);
        return RoleUsers.openWCMObjs(ContextHelper.getLoginUser(), aFilter);
    }

    public boolean isRoleManagers(User _user) throws WCMException {
        if (_user == null) {
            return false;
        }
        String sWhere = "ROLENAME=? and exists(select 1 from WCMRoleUser where WCMRoleUser.UserId=? and WCMRoleUser.RoleId=WCMRole.RoleId)";
        WCMFilter aFilter = new WCMFilter(null, sWhere, null);
        aFilter.addSearchValues("RoleManagers");
        aFilter.addSearchValues(_user.getId());
        Roles roles = Roles.openWCMObjs(ContextHelper.getLoginUser(), aFilter);
        return roles != null && !roles.isEmpty();
    }

    public Roles getRolesForUser(User _user, WCMFilter _filter) throws WCMException {
        if (_user == null) {
            return Roles.createNewInstance(null);
        }
        if (_user.isSecurityAdmin()) {
            return Roles.openWCMObjs(ContextHelper.getLoginUser(), _filter);
        }
        WCMFilter aFilter = this.makeRoleFilterForOthers(_user, _filter, false);
        return Roles.openWCMObjs(ContextHelper.getLoginUser(), aFilter);
    }

    private WCMFilter makeRoleFilterForOthers(User _user, WCMFilter _filter, boolean _bIncludeEveryone) throws WCMException {
        if (_user == null || _user.isSecurityAdmin()) {
            throw new WCMException("\u63a5\u53e3\u8c03\u7528\u9519\u8bef\uff0c\u6b64\u63a5\u53e3\u53ea\u4f9b\u975e\u7cfb\u7edf\u7ba1\u7406\u5458\u7528\u6237\u4f7f\u7528");
        }
        String sWhere = "WCMRole.RoleRange=1";
        GroupMgr groupMgr = (GroupMgr)DreamFactory.createObjectById("GroupMgr");
        Groups groups = groupMgr.getOffspringGroups(_user, null);
        String sGroupIds = groups.getIdListAsString();
        if (CMyString.isEmpty(sGroupIds)) {
            sGroupIds = "0";
        }
        String sSQL = IdFilterSqlUtil.makeAsString("WCMGrpRole.GroupId", sGroupIds);
        sWhere = sWhere + " or exists(select 1 from WCMGrpRole where WCMGrpRole.RoleId=WCMRole.RoleId and " + sSQL + ")";
        if (_bIncludeEveryone) {
            sWhere = sWhere + " or WCMRole.RoleId=2";
        }
        WCMFilter aFilter = new WCMFilter(null, sWhere, null);
        aFilter.mergeWith(_filter);
        return aFilter;
    }

    public Roles getRolesForUser(User _user, WCMFilter _filter, boolean _bIncludeEveryone) throws WCMException {
        if (_user == null) {
            return Roles.createNewInstance(null);
        }
        if (_user.isSecurityAdmin()) {
            return Roles.openWCMObjs(ContextHelper.getLoginUser(), _filter);
        }
        WCMFilter aFilter = this.makeRoleFilterForOthers(_user, _filter, _bIncludeEveryone);
        return Roles.openWCMObjs(ContextHelper.getLoginUser(), aFilter);
    }

    public void setRoleUsers(Role role, int _nSiteId, Users _users) throws WCMException {
        User user;
        int i;
        Users originalUsers = this.getUsers(role, _nSiteId, null);
        UserMgr userMgr = (UserMgr)DreamFactory.createObjectById("UserMgr");
        User loginUser = ContextHelper.getLoginUser();
        if (!loginUser.isSecurityAdmin()) {
            Users oCanMgrUsers = userMgr.getCanManagerUsers(loginUser);
            for (int i2 = originalUsers.size() - 1; i2 >= 0; --i2) {
                User oOriginalUser = (User)originalUsers.getAt(i2);
                if (oOriginalUser == null || oCanMgrUsers.indexOf(oOriginalUser.getId()) >= 0) continue;
                originalUsers.remove(oOriginalUser, false);
            }
        }
        int length = _users.size();
        for (i = 0; i < length; ++i) {
            user = (User)_users.getAt(i);
            if (user == null) continue;
            int nIndex = originalUsers.indexOf(user.getId());
            if (nIndex >= 0) {
                originalUsers.removeAt(nIndex, false);
                continue;
            }
            this.addUser(role, _nSiteId, user);
        }
        length = originalUsers.size();
        for (i = 0; i < length; ++i) {
            user = (User)originalUsers.getAt(i);
            if (user == null) continue;
            this.removeUser(role, _nSiteId, user);
        }
    }

    public Roles getSystemRolesOfUser(User _user, int nSiteId, WCMFilter _filter) throws WCMException {
        if (_user == null) {
            return Roles.createNewInstance(null);
        }
        String sWhere = "WCMRole.RoleType=-1 and exists(select 1 from WCMRoleUser where WCMRoleUser.RoleId=WCMRole.RoleId and  WCMRoleUser.UserId=? and WCMRoleUser.SiteId=?)";
        WCMFilter aFilter = new WCMFilter(null, sWhere, null);
        aFilter.addSearchValues(_user.getId());
        aFilter.addSearchValues(nSiteId);
        aFilter.mergeWith(_filter);
        return Roles.openWCMObjs(ContextHelper.getLoginUser(), aFilter);
    }

    public Roles getSpecialRolesOfUser(User _user, WCMFilter _filter) throws WCMException {
        if (_user == null) {
            return Roles.createNewInstance(null);
        }
        String sWhere = "WCMRole.RoleType=0 and exists(select 1 from WCMRoleUser where WCMRoleUser.RoleId=WCMRole.RoleId and  WCMRoleUser.UserId=? and WCMRoleUser.SiteId=?)";
        WCMFilter aFilter = new WCMFilter(null, sWhere, null);
        aFilter.addSearchValues(_user.getId());
        aFilter.addSearchValues(-1);
        aFilter.mergeWith(_filter);
        return Roles.openWCMObjs(ContextHelper.getLoginUser(), aFilter);
    }

    public void setSystemRolesOfUser(User _user, int _nSiteId, Roles roles) throws WCMException {
        Role role;
        int i;
        Roles originalRoles = this.getSystemRolesOfUser(_user, _nSiteId, null);
        int length = roles.size();
        for (i = 0; i < length; ++i) {
            role = (Role)roles.getAt(i);
            if (role == null) continue;
            int nIndex = originalRoles.indexOf(role.getId());
            if (nIndex >= 0) {
                originalRoles.removeAt(nIndex, false);
                continue;
            }
            this.addUser(role, _nSiteId, _user);
        }
        length = originalRoles.size();
        for (i = 0; i < length; ++i) {
            role = (Role)originalRoles.getAt(i);
            if (role == null) continue;
            this.removeUser(role, _nSiteId, _user);
        }
    }

    public void setSpecailRolesOfUser(User _user, Roles _roles) throws WCMException {
        Role role;
        int i;
        Roles originalRoles = this.getSpecialRolesOfUser(_user, null);
        int length = _roles.size();
        for (i = 0; i < length; ++i) {
            role = (Role)_roles.getAt(i);
            if (role == null) continue;
            int nIndex = originalRoles.indexOf(role.getId());
            if (nIndex >= 0) {
                originalRoles.removeAt(nIndex, false);
                continue;
            }
            this.addUser(role, -1, _user);
        }
        length = originalRoles.size();
        for (i = 0; i < length; ++i) {
            role = (Role)originalRoles.getAt(i);
            if (role == null) continue;
            this.removeUser(role, -1, _user);
        }
    }

    public Role findRoleByName(String sRoleName) throws WCMException {
        WCMFilter filter = new WCMFilter(null, "ROLENAME=?", "ROLEID desc");
        filter.addSearchValues(sRoleName);
        Roles oRoles = Roles.openWCMObjs(ContextHelper.getLoginUser(), filter);
        int nSize = oRoles.size();
        for (int i = 0; i < nSize; ++i) {
            Role oRole = (Role)oRoles.getAt(i);
            if (oRole == null) continue;
            return oRole;
        }
        return null;
    }
}

