/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms;

import com.trs.DreamFactory;
import com.trs.infra.BaseServer;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.util.WCMDiscoveryFactory;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class ObjectTypeServer
extends BaseServer {
    private static Map m_objTypeClazzs = new HashMap();
    private static Logger m_logger = Logger.getLogger(ObjectTypeServer.class);

    @Override
    protected void doShutdown() {
        m_objTypeClazzs.clear();
    }

    @Override
    protected boolean doStart() throws WCMException {
        String iterfaceName = BaseObj.class.getName();
        Iterator itrImplementors = WCMDiscoveryFactory.getDiscovery().getImplementors(iterfaceName);
        if (itrImplementors == null) {
            return true;
        }
        while (itrImplementors.hasNext()) {
            String sImplementor = (String)itrImplementors.next();
            this.register(sImplementor);
        }
        return true;
    }

    public void register(String _sClazz) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(_sClazz);
        }
        catch (Exception e) {
            m_logger.debug((Object)(I18NMessage.get(ObjectTypeServer.class, "ObjectTypeServer.label1", "\u52a0\u8f7d\u7c7b[") + _sClazz + I18NMessage.get(ObjectTypeServer.class, "ObjectTypeServer.label2", "]\u51fa\u73b0\u9519\u8bef")), (Throwable)e);
        }
        ObjectTypeServer.register(clazz);
    }

    public static void register(Class _oClazz) {
        try {
            Field objTypeField = _oClazz.getField("OBJ_TYPE");
            Integer oObjType = (Integer)objTypeField.get(null);
            ObjectTypeServer.register(oObjType, _oClazz);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void register(int _nObjType, String _sClazz) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(_sClazz);
        }
        catch (Exception e) {
            m_logger.debug((Object)(I18NMessage.get(ObjectTypeServer.class, "ObjectTypeServer.label1", "\u52a0\u8f7d\u7c7b[") + _sClazz + I18NMessage.get(ObjectTypeServer.class, "ObjectTypeServer.label2", "]\u51fa\u73b0\u9519\u8bef")), (Throwable)e);
        }
        ObjectTypeServer.register(_nObjType, clazz);
    }

    public static void register(int _nObjType, Class _oClazz) {
        ObjectTypeServer.register(new Integer(_nObjType), _oClazz);
    }

    public static void register(Integer _oObjType, Class _oClazz) {
        Class oldClazz;
        if (_oClazz.getName().indexOf(36) >= 0) {
            m_logger.debug((Object)(I18NMessage.get(ObjectTypeServer.class, "ObjectTypeServer.label3", "\u5ffd\u7565\u5185\u90e8\u7c7b[") + _oObjType + I18NMessage.get(ObjectTypeServer.class, "ObjectTypeServer.label4", "],\u7c7b[") + _oClazz.getName() + "]"));
            return;
        }
        if (m_logger.isDebugEnabled()) {
            m_logger.debug((Object)(I18NMessage.get(ObjectTypeServer.class, "ObjectTypeServer.label5", "\u6ce8\u518cobjType[") + _oObjType + I18NMessage.get(ObjectTypeServer.class, "ObjectTypeServer.label4", "],\u7c7b[") + _oClazz.getName() + "]"));
        }
        if ((oldClazz = (Class)m_objTypeClazzs.get(_oObjType)) == _oClazz) {
            return;
        }
        if (oldClazz != null) {
            StringBuffer sbError = new StringBuffer();
            sbError.append(I18NMessage.get(ObjectTypeServer.class, "ObjectTypeServer.label5", "\u6ce8\u518cobjType[")).append(_oObjType).append(I18NMessage.get(ObjectTypeServer.class, "ObjectTypeServer.label6", "]\u53d1\u751f\u51b2\u7a81;"));
            sbError.append(I18NMessage.get(ObjectTypeServer.class, "ObjectTypeServer.label7", "\u7c7b[")).append(oldClazz).append(",").append(_oClazz).append("];");
            m_logger.error((Object)sbError.toString());
        }
        m_objTypeClazzs.put(_oObjType, _oClazz);
    }

    public static Class get(int _nObjType) {
        ObjectTypeServer objectTypeServer = (ObjectTypeServer)DreamFactory.createObjectById("ObjectTypeServer");
        if (!objectTypeServer.isStarted()) {
            objectTypeServer.startup();
        }
        int nTryTimes = 1;
        int nMaxTimes = 10;
        while (objectTypeServer.isStarting()) {
            if (m_logger.isDebugEnabled()) {
                m_logger.debug((Object)("try times:" + nTryTimes), (Throwable)new Exception("For call stack inspect."));
            }
            if (++nTryTimes >= nMaxTimes) {
                m_logger.error((Object)("\u8fbe\u5230\u6700\u5927\u5c1d\u8bd5\u6b21\u6570[" + _nObjType + "]"), (Throwable)new Exception("For call stack inspect."));
                break;
            }
            try {
                Thread.currentThread();
                Thread.sleep(nTryTimes * 300);
            }
            catch (InterruptedException e) {
                m_logger.error((Object)("\u83b7\u53d6\u7c7b\u578b[" + _nObjType + "]\u5931\u8d25"), (Throwable)e);
            }
        }
        return (Class)m_objTypeClazzs.get(new Integer(_nObjType));
    }
}

