/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cluster.receiver;

import com.trs.DreamFactory;
import com.trs.cluster.IClusterMsgReceiver;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.listener.IObjectLCListenerOnAdd;
import com.trs.infra.persistent.listener.IObjectLCListenerOnDel;
import com.trs.infra.persistent.listener.IObjectLCListenerOnModify;
import org.apache.log4j.Logger;

public class ObjectLCMsgReceiver
implements IClusterMsgReceiver {
    private static Logger logger = Logger.getLogger(ObjectLCMsgReceiver.class);
    private static final int[] OBJECT_TYPES = new int[]{101, 101, 101, 202, 1886731157, 694710472, 955, 403, 403, 105, 864684658, 102, 953, 957, -1209578322, -1209578322, -1643208931, -1643208931, 204, 204, 951, 501, 1874605631, 1886731157, 701, 701, -1676813972};
    public static final String[] LISTENER_NAMES = new String[]{"IChildrenMgr", "IChannelNameMgr", "ChannelLCListener4EPress", "RightCacheMgr", "IMetaDataDefCacheMgr", "IClassInfoCacheMgr", "PublishDistributionCacheMgr", "IFlowCacheMgr", "RuleHostLCListnerForCache", "ReplaceCacheMgr", "IFolderPubStatusCacheMgr", "TemplateParseMgr", "ITemplateEmployCacheMgr", "TemplateArgumentCacheMgr", "GroupUserCacheMgr", "GroupAdminsCacheMgr", "IAdministratorCacheMgr", "RoleUserCacheMgr", "IUserCacheMgr", "UserLCListenerForLogin", "TagBeanLCListener", "ScheduleLCListenerForServer", "IMetaDataDefCacheMgr", "IMetaDataDefCacheMgr", "PathConfigLCListener", "ConfigServer", "IPublishTaskDispatcher"};

    @Override
    public void receive(BaseObj _oEventObject, int _nEventType) throws Exception {
        if (_oEventObject == null) {
            throw new WCMException("\u6d88\u606f\u4e2d\u5fc3\u4f20\u5165\u7684\u5bf9\u8c61\u6709\u8bef\uff01\u6ca1\u6709\u4f20\u5165\u6301\u4e45\u5316\u5bf9\u8c61\uff01");
        }
        int[] pCurrIndexs = this.makeCurrListenerIndexs(_oEventObject);
        for (int i = 0; i < pCurrIndexs.length && pCurrIndexs[i] != -1; ++i) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(LISTENER_NAMES[pCurrIndexs[i]] + "......."));
            }
            this.notifyListener(pCurrIndexs[i], _oEventObject, _nEventType);
        }
    }

    private int[] makeCurrListenerIndexs(BaseObj _oEventObject) throws WCMException {
        int nObjType = _oEventObject.getWCMType();
        int[] pCurrIndexs = new int[LISTENER_NAMES.length];
        for (int i = 0; i < pCurrIndexs.length; ++i) {
            pCurrIndexs[i] = -1;
        }
        int nCurrIndexPos = 0;
        for (int i = 0; i < OBJECT_TYPES.length; ++i) {
            if (nObjType != OBJECT_TYPES[i]) continue;
            pCurrIndexs[nCurrIndexPos++] = i;
        }
        if (pCurrIndexs[0] == -1) {
            throw new WCMException("\u7cfb\u7edf\u6545\u969c\uff1f[Type=" + _oEventObject.getWCMType() + ", ID=" + _oEventObject.getId() + "]");
        }
        return pCurrIndexs;
    }

    private void notifyListener(int _nListenerIndex, BaseObj _oEventObject, int _nEventType) throws WCMException {
        Object listener = DreamFactory.createObjectById(LISTENER_NAMES[_nListenerIndex]);
        switch (_nEventType) {
            case 1: {
                if (!(listener instanceof IObjectLCListenerOnAdd)) break;
                ((IObjectLCListenerOnAdd)listener).notifyOnAddObj(_oEventObject);
                break;
            }
            case 2: {
                if (!(listener instanceof IObjectLCListenerOnModify)) break;
                ((IObjectLCListenerOnModify)listener).notifyOnModifyObj(_oEventObject, 2);
                break;
            }
            case 3: {
                if (!(listener instanceof IObjectLCListenerOnDel)) break;
                ((IObjectLCListenerOnDel)listener).notifyOnDelObj(_oEventObject, 4);
            }
        }
    }

    @Override
    public void receive(String _sContent, String[] _pParameters) throws Exception {
    }

    @Override
    public String[] registerMoniterMessages() {
        return null;
    }

    @Override
    public int[] registerMoniterWCMObjTypesOnAdd() {
        int[] pResult = null;
        for (int i = 0; i < OBJECT_TYPES.length; ++i) {
            int nObjectType = OBJECT_TYPES[i];
            Object listener = DreamFactory.createObjectById(LISTENER_NAMES[i]);
            if (!(listener instanceof IObjectLCListenerOnAdd)) continue;
            if (pResult == null) {
                pResult = new int[1];
            } else {
                if (this.isAdd(nObjectType, pResult)) continue;
                int[] pTemp = new int[pResult.length + 1];
                System.arraycopy(pResult, 0, pTemp, 0, pResult.length);
                pResult = pTemp;
            }
            pResult[pResult.length - 1] = nObjectType;
        }
        return pResult;
    }

    @Override
    public int[] registerMoniterWCMObjTypesOnDel() {
        int[] pResult = null;
        for (int i = 0; i < OBJECT_TYPES.length; ++i) {
            int nObjectType = OBJECT_TYPES[i];
            Object listener = DreamFactory.createObjectById(LISTENER_NAMES[i]);
            if (!(listener instanceof IObjectLCListenerOnDel)) continue;
            if (pResult == null) {
                pResult = new int[1];
            } else {
                if (this.isAdd(nObjectType, pResult)) continue;
                int[] pTemp = new int[pResult.length + 1];
                System.arraycopy(pResult, 0, pTemp, 0, pResult.length);
                pResult = pTemp;
            }
            pResult[pResult.length - 1] = nObjectType;
        }
        return pResult;
    }

    @Override
    public int[] registerMoniterWCMObjTypesOnModify() {
        int[] pResult = null;
        for (int i = 0; i < OBJECT_TYPES.length; ++i) {
            int nObjectType = OBJECT_TYPES[i];
            Object listener = DreamFactory.createObjectById(LISTENER_NAMES[i]);
            if (!(listener instanceof IObjectLCListenerOnModify)) continue;
            if (pResult == null) {
                pResult = new int[1];
            } else {
                if (this.isAdd(nObjectType, pResult)) continue;
                int[] pTemp = new int[pResult.length + 1];
                System.arraycopy(pResult, 0, pTemp, 0, pResult.length);
                pResult = pTemp;
            }
            pResult[pResult.length - 1] = nObjectType;
        }
        return pResult;
    }

    private boolean isAdd(int _nObjType, int[] _pResult) {
        for (int i = 0; i < _pResult.length; ++i) {
            if (_pResult[i] != _nObjType) continue;
            return true;
        }
        return false;
    }
}

