/*
 * Decompiled with CFR 0.152.
 */
package com.trs.bigfile;

import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.Roles;
import com.trs.cms.auth.persistent.User;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyString;

public class BigFileRoleAuth {
    private static final String CONF_KEY_ROLE = "BIGFILE_ROLE_ID";
    private static final String CONF_KEY_GROUP = "BIGFILE_GROUP_ID";

    public static boolean hasRight(User user) throws WCMException {
        Groups groups;
        if (user == null) {
            return false;
        }
        if (user.isAdministrator()) {
            return true;
        }
        ConfigServer server = ConfigServer.getServer();
        Roles roles = user.getRoles();
        if (roles != null && !roles.isEmpty()) {
            String roleId = server.getSysConfigValue(CONF_KEY_ROLE, "0");
            int[] nIds = CMyString.splitToInt(roleId, ",");
            int len = nIds.length;
            for (int i = 0; i < len; ++i) {
                if (roles.indexOf(nIds[i]) == -1) continue;
                return true;
            }
        }
        if ((groups = user.getGroups()) != null && !groups.isEmpty()) {
            String groupIds = server.getSysConfigValue(CONF_KEY_GROUP, "0");
            int[] nIds = CMyString.splitToInt(groupIds, ",");
            int len = nIds.length;
            for (int i = 0; i < len; ++i) {
                if (groups.indexOf(nIds[i]) == -1) continue;
                return true;
            }
        }
        return false;
    }
}

