/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice;

import com.trs.DreamFactory;
import com.trs.ajaxservice.WCMAJAXServiceHelper;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.content.domain.AutoTransmitMgr;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.ChannelSyn;
import com.trs.components.wcm.content.persistent.ChannelSyns;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.common.WCMTypes;
import com.trs.infra.util.CMyString;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.IGlueServiceProvider;

public class DocumentSynServiceProvider
implements IGlueServiceProvider {
    private AutoTransmitMgr m_oAutoTransmitMgr = (AutoTransmitMgr)DreamFactory.createObjectById("AutoTransmitMgr");

    @Override
    public void delete(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        Channel channel = this.findChannel(_methodContext);
        this.validateRight(loginUser, channel, 13, I18NMessage.get(DocumentSynServiceProvider.class, "DocumentSynServiceProvider.label1", "\u5220\u9664\u540c\u6b65\u4fe1\u606f"));
        ChannelSyns syns = ChannelSyns.findByIds(loginUser, _methodContext.getObjectIds());
        int nSize = syns.size();
        for (int i = 0; i < nSize; ++i) {
            ChannelSyn syn = (ChannelSyn)syns.getAt(i);
            if (syn == null) continue;
            this.m_oAutoTransmitMgr.delete(syn);
        }
    }

    @Override
    public Object query(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        Channel channel = this.findChannel(_methodContext);
        boolean bChannelAsTarget = _methodContext.getValue("ChannelAsTarget", false);
        this.validateRight(loginUser, channel, 13, I18NMessage.get(DocumentSynServiceProvider.class, "DocumentSynServiceProvider.label2", "\u83b7\u53d6\u540c\u6b65\u4fe1\u606f"));
        return this.m_oAutoTransmitMgr.getChannelSyns(channel, _methodContext.getExtraWCMFilter(), bChannelAsTarget);
    }

    @Override
    public int save(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        Channel channel = this.findChannel(_methodContext);
        int nChannelSynId = _methodContext.getObjectId();
        boolean bChannelAsTarget = _methodContext.getValue("ChannelAsTarget", false);
        this.validateRight(loginUser, channel, 13, I18NMessage.get(DocumentSynServiceProvider.class, "DocumentSynServiceProvider.label2", "\u83b7\u53d6\u540c\u6b65\u4fe1\u606f"));
        String[] pLogicFields = new String[]{"ChannelId", "DstChannelIds", "ChannelAsTarget"};
        ChannelSyn channelSyn = null;
        Channels dstChannels = Channels.findByIds(loginUser, _methodContext.getValue("DstChannelIds"));
        if (nChannelSynId == 0) {
            if (dstChannels.isEmpty()) {
                throw new WCMException(1101, I18NMessage.get(DocumentSynServiceProvider.class, "DocumentSynServiceProvider.label3", "DstChannelIds\u6ca1\u6709\u6307\u5b9a\uff01"));
            }
            int nSize = dstChannels.size();
            for (int i = 0; i < nSize; ++i) {
                Channel dstChannel = (Channel)dstChannels.getAt(i);
                if (dstChannel == null) continue;
                channelSyn = new ChannelSyn();
                if (bChannelAsTarget) {
                    channelSyn.setToChannelId(channel.getId());
                    channelSyn.setSrcChannelId(dstChannel.getId());
                } else {
                    channelSyn.setToChannelId(dstChannel.getId());
                    channelSyn.setSrcChannelId(channel.getId());
                }
                WCMAJAXServiceHelper.setWCMObjectProperties(loginUser, _methodContext, channelSyn, pLogicFields);
                channelSyn.save(loginUser);
            }
        } else {
            channelSyn = ChannelSyn.findById(nChannelSynId);
            if (channelSyn == null) {
                throw new WCMException(1101, I18NMessage.get(DocumentSynServiceProvider.class, "DocumentSynServiceProvider.label4", "\u680f\u76ee\u5206\u53d1\u5bf9\u8c61[ID=") + nChannelSynId + I18NMessage.get(DocumentSynServiceProvider.class, "DocumentSynServiceProvider.label5", "]\u6ca1\u6709\u627e\u5230\uff01"));
            }
            channelSyn.validCanEditAndLock(loginUser);
            WCMAJAXServiceHelper.setWCMObjectProperties(loginUser, _methodContext, channelSyn, pLogicFields);
            if (!dstChannels.isEmpty()) {
                int nDstChannelId = dstChannels.getIdAt(0);
                if (bChannelAsTarget) {
                    channelSyn.setSrcChannelId(nDstChannelId);
                } else {
                    channelSyn.setToChannelId(nDstChannelId);
                }
            }
            channelSyn.save(loginUser);
        }
        return channelSyn.getId();
    }

    @Override
    public Object findById(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        Channel channel = this.findChannel(_methodContext);
        int nChannelSynId = _methodContext.getObjectId();
        if (nChannelSynId <= 0) {
            return null;
        }
        this.validateRight(loginUser, channel, 13, I18NMessage.get(DocumentSynServiceProvider.class, "DocumentSynServiceProvider.label2", "\u83b7\u53d6\u540c\u6b65\u4fe1\u606f"));
        ChannelSyn channelSyn = ChannelSyn.findById(nChannelSynId);
        boolean isTarget = _methodContext.getValue("asTarget", false);
        if (channelSyn == null) {
            throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(nChannelSynId), WCMTypes.getLowerSynName(isTarget)}));
        }
        return channelSyn;
    }

    @Override
    public Object findByIds(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        Channel channel = this.findChannel(_methodContext);
        this.validateRight(loginUser, channel, 13, I18NMessage.get(DocumentSynServiceProvider.class, "DocumentSynServiceProvider.label2", "\u83b7\u53d6\u540c\u6b65\u4fe1\u606f"));
        return ChannelSyns.findByIds(loginUser, _methodContext.getObjectIds());
    }

    public String isValidDocumentSyn(MethodContext _methodContext) throws Throwable {
        boolean bChannelAsTarget = _methodContext.getValue("ChannelAsTarget", false);
        int[] pDstChannelIds = CMyString.splitToInt(_methodContext.getObjectIds(), ",");
        int nSrcChannelId = _methodContext.getValue("SrcChannelId", 0);
        StringBuffer sbInValidChannelIds = new StringBuffer(pDstChannelIds.length + _methodContext.getObjectIds().length());
        for (int i = 0; i < pDstChannelIds.length; ++i) {
            boolean bValid = false;
            bValid = bChannelAsTarget ? ChannelSyn.isValid(pDstChannelIds[i], nSrcChannelId) : ChannelSyn.isValid(nSrcChannelId, pDstChannelIds[i]);
            if (bValid) continue;
            Channel channel = Channel.findById(pDstChannelIds[i]);
            sbInValidChannelIds.append(channel.getDesc() + "[" + channel.getId() + "]\n");
        }
        _methodContext.setReturnHTML(true);
        return sbInValidChannelIds.toString();
    }

    public String isValidDocumentCollection(MethodContext _methodContext) throws Throwable {
        int[] pToChannelIds = CMyString.splitToInt(_methodContext.getObjectIds(), ",");
        int nDstChannelId = _methodContext.getValue("SrcChannelId", 0);
        StringBuffer sbInValidChannelIds = new StringBuffer(pToChannelIds.length + _methodContext.getObjectIds().length());
        boolean bFirst = true;
        for (int i = 0; i < pToChannelIds.length; ++i) {
            if (!ChannelSyn.isValid(pToChannelIds[i], nDstChannelId)) continue;
            if (bFirst) {
                bFirst = false;
            } else {
                sbInValidChannelIds.append(",");
            }
            sbInValidChannelIds.append(pToChannelIds[i]);
        }
        return sbInValidChannelIds.toString();
    }

    private Channel findChannel(MethodContext _methodContext) throws WCMException {
        int nChannelId = _methodContext.getValue("ChannelId", 0);
        return this.findChannelById(nChannelId);
    }

    private Channel findChannelById(int _nChannelId) throws WCMException {
        Channel channel = Channel.findById(_nChannelId);
        if (channel == null) {
            throw new WCMException(1100, I18NMessage.get(DocumentSynServiceProvider.class, "DocumentSynServiceProvider.label6", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u680f\u76ee[ID=") + _nChannelId + "]\uff01");
        }
        return channel;
    }

    private User getLoginUser() {
        User loginUser = ContextHelper.getLoginUser();
        ContextHelper.initContext(loginUser);
        return loginUser;
    }

    private void validateRight(User _loginUser, Channel _channel, int _nRightIndex, String _sOperDesc) throws WCMException {
        if (!AuthServer.hasRight(_loginUser, (CMSObj)_channel, _nRightIndex)) {
            throw new WCMException(I18NMessage.get(DocumentSynServiceProvider.class, "DocumentSynServiceProvider.label7", "\u5bf9\u4e0d\u8d77\uff0c\u60a8[") + _loginUser.getName() + I18NMessage.get(DocumentSynServiceProvider.class, "DocumentSynServiceProvider.label8", "]\u6ca1\u6709\u6743\u9650\u5728(") + _channel + I18NMessage.get(DocumentSynServiceProvider.class, "DocumentSynServiceProvider.label9", ")\u4e0a\u6267\u884c[") + _sOperDesc + I18NMessage.get(DocumentSynServiceProvider.class, "DocumentSynServiceProvider.label10", "]\u64cd\u4f5c\uff01"));
        }
    }
}

