/*
 * Decompiled with CFR 0.152.
 */
package com.trsupdate;

import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.Right;
import com.trs.cms.auth.persistent.RightValue;
import com.trs.cms.auth.persistent.Rights;
import com.trs.cms.auth.persistent.Role;
import com.trs.cms.auth.persistent.Roles;
import com.trs.cms.auth.persistent.User;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyBitsValue;
import com.trs.infra.util.DebugTimer;
import org.apache.log4j.Logger;

public class RegionRightUpdater {
    private static Logger logger = Logger.getLogger(RegionRightUpdater.class);
    private User m_oCurrUser = null;

    public RegionRightUpdater(User _oCurrUser) {
        this.m_oCurrUser = _oCurrUser;
    }

    public void updateRegionRight() throws WCMException {
        logger.warn((Object)"The system begin to add region right....");
        DebugTimer allTimer = new DebugTimer();
        allTimer.start();
        Rights oRights = Rights.openWCMObjs(this.m_oCurrUser, null);
        int nSize = oRights.size();
        for (int i = 0; i < nSize; ++i) {
            Right currRight = (Right)oRights.getAt(i);
            if (currRight == null) continue;
            RightValue rightValue = currRight.getValue();
            long lRightValue = currRight.getValueAsLong();
            int nObjType = currRight.getObjType();
            if (AuthServer.hasRight(lRightValue, 48) || (nObjType != 103 || !AuthServer.hasRight(lRightValue, 1)) && (nObjType != 101 || !AuthServer.hasRight(lRightValue, 13))) continue;
            rightValue.setBit(48, true);
            currRight.setValue(rightValue);
            currRight.save(this.m_oCurrUser);
            logger.info((Object)(currRight.getOperator() + "\u5728" + BaseChannel.findById(nObjType, currRight.getObjId()) + "\u4e0a\u7684\u6743\u9650\u503c\u6539\u53d8\u3002\u6539\u53d8\u524d\uff1a" + lRightValue + "; \u6539\u53d8\u540e\uff1a" + rightValue.getValue()));
        }
        WCMFilter aFilter = new WCMFilter("WCMROLE", "ROLETYPE=?", "");
        aFilter.addSearchValues(-1);
        Roles oSystemRoles = Roles.openWCMObjs(this.m_oCurrUser, aFilter);
        int nSize2 = oSystemRoles.size();
        for (int i = 0; i < nSize2; ++i) {
            long lRightValue;
            Role oCurrRole = (Role)oSystemRoles.getAt(i);
            if (oCurrRole == null || AuthServer.hasRight(lRightValue = oCurrRole.getRightValue(), 48) || !AuthServer.hasRight(lRightValue, 1) && !AuthServer.hasRight(lRightValue, 13)) continue;
            CMyBitsValue oBitsValue = new CMyBitsValue();
            oBitsValue.setValue(lRightValue);
            oBitsValue.setBit(48, true);
            oCurrRole.setRightValue(oBitsValue.getValue());
            oCurrRole.save(this.m_oCurrUser);
            logger.info((Object)(oCurrRole + "\u7684\u6743\u9650\u503c\u6539\u53d8\uff0c\u6539\u53d8\u524d\uff1a" + lRightValue + "; \u6539\u53d8\u540e\uff1a" + oBitsValue.getValue()));
        }
        allTimer.stop();
        logger.warn((Object)("The system end to add region right!use[" + allTimer.getTime() + "]ms"));
    }

    public static void main(String[] args) {
        try {
            RegionRightUpdater updater = new RegionRightUpdater(User.findByName("admin"));
            updater.updateRegionRight();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

