/*
 * Decompiled with CFR 0.152.
 */
package com.trs.webframework.xmlserver.server;

import com.trs.webframework.exception.ServiceInvocationException;
import com.trs.webframework.xmlserver.parser.XMLParsingInfoHolder;
import com.trs.webframework.xmlserver.server.IObserver;
import com.trs.webframework.xmlserver.server.IObserverable;
import com.trs.webframework.xmlserver.server.XMLParsingPausedException;
import java.util.ArrayList;
import java.util.Stack;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class XMLDataProcessingHandler
extends DefaultHandler
implements IObserverable {
    private static Logger logger = Logger.getLogger(XMLDataProcessingHandler.class);
    public static final int TAG_ROOT = "post-data".hashCode();
    public static final int TAG_METHOD = "method".hashCode();
    public static final int ATTR_TYPE = "type".hashCode();
    public static final int TAG_PARAMS = "parameters".hashCode();
    public static final int TAG_PARAM = "parameter".hashCode();
    private static final int TAG_ELEMENT = "element".hashCode();
    private Stack m_stkTagName = null;
    private boolean m_bUnderMethodAnalyzing = false;
    private boolean m_bUnderParametersAnalyzing = false;
    private ArrayList m_arObservers = null;
    private XMLParsingInfoHolder m_oParsingInfo = null;
    private int m_nParsingStatus;
    private Object[] m_pResult = new Object[100];
    private int m_nCurrResultIndex = 0;
    private Object m_oHanderArg = null;
    StringBuffer m_sbCurrentElementVal = new StringBuffer();

    public XMLDataProcessingHandler() {
        this(null);
    }

    public XMLDataProcessingHandler(Object _oHandlerArg) {
        this.m_arObservers = new ArrayList(5);
        this.m_oHanderArg = _oHandlerArg;
    }

    public void clear() {
        this.m_bUnderMethodAnalyzing = false;
        this.m_bUnderParametersAnalyzing = false;
        this.m_nParsingStatus = 0;
        this.m_oParsingInfo = new XMLParsingInfoHolder();
        this.m_stkTagName.clear();
        for (int i = 0; i < this.m_arObservers.size(); ++i) {
            IObserver observer = (IObserver)this.m_arObservers.get(i);
            observer.clear();
        }
    }

    @Override
    public void startDocument() {
        this.m_stkTagName = new Stack();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        int nTagName;
        String tagName = qName.toLowerCase().trim();
        this.m_stkTagName.push(tagName);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(">> begin to parse<" + qName + ">"));
        }
        if ((nTagName = tagName.hashCode()) == TAG_ROOT) {
            this.m_oParsingInfo = new XMLParsingInfoHolder();
        } else if (nTagName == TAG_METHOD) {
            String type = attributes.getValue("type");
            this.m_oParsingInfo.setMethodName(type);
            this.notifyObservers(this, 1);
            this.m_bUnderMethodAnalyzing = true;
        } else if (nTagName == TAG_PARAMS) {
            this.m_bUnderParametersAnalyzing = true;
        } else if (nTagName == TAG_ELEMENT) {
            // empty if block
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        this.notifyWhenParamParsingEnd(this.m_sbCurrentElementVal.toString(), qName);
        int nTagName = qName.toLowerCase().trim().hashCode();
        if (nTagName == TAG_METHOD) {
            this.m_bUnderMethodAnalyzing = false;
        } else if (nTagName == TAG_PARAMS) {
            this.m_bUnderParametersAnalyzing = false;
        } else if (nTagName == TAG_ELEMENT) {
            // empty if block
        }
        if (!this.m_stkTagName.isEmpty()) {
            this.m_stkTagName.pop();
        }
        if (this.m_sbCurrentElementVal != null) {
            this.m_sbCurrentElementVal.setLength(0);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (length <= 0) {
            return;
        }
        this.m_sbCurrentElementVal.append(ch, start, length);
    }

    private void notifyWhenParamParsingEnd(String sVal, String sQName) {
        int nTagName = sQName.toLowerCase().trim().hashCode();
        if (nTagName == TAG_ELEMENT || nTagName == TAG_PARAMS) {
            this.notifyObservers(this, 3);
            return;
        }
        if (sVal == null) {
            return;
        }
        if (this.m_bUnderMethodAnalyzing) {
            if (this.m_oParsingInfo.getInvocationId() == null) {
                this.m_oParsingInfo.setInvocationId(sVal);
                this.notifyObservers(this, 2);
            }
        } else if (this.m_bUnderParametersAnalyzing && !this.m_oParsingInfo.containsNamedParam(sQName)) {
            this.m_oParsingInfo.appendNamedParam(sQName, sVal);
            return;
        }
    }

    @Override
    public void endDocument() {
    }

    public XMLParsingInfoHolder getParsingInfo() {
        return this.m_oParsingInfo;
    }

    public int getParsingStatus() {
        return this.m_nParsingStatus;
    }

    public Object getResult() {
        int nActualResultCount = 0;
        int nStartIndex = 0;
        int nMaxResultLength = 100;
        for (int i = 0; i < this.m_pResult.length; ++i) {
            if (this.m_pResult[i] == null) continue;
            ++nActualResultCount;
            nStartIndex = i;
            if (!(this.m_pResult[i] instanceof String)) continue;
            nMaxResultLength += ((String)this.m_pResult[i]).length();
        }
        if (nActualResultCount == 1) {
            return this.m_pResult[nStartIndex];
        }
        StringBuffer sbResult = new StringBuffer(nMaxResultLength);
        sbResult.append("<MultiResult>\n");
        for (int i = 0; i < this.m_pResult.length; ++i) {
            if (this.m_pResult[i] == null || !(this.m_pResult[i] instanceof String)) continue;
            sbResult.append(this.m_pResult[i]);
            sbResult.append("\n");
        }
        sbResult.append("</MultiResult>");
        return sbResult.toString();
    }

    @Override
    public void notifyObservers(IObserverable _subject, int _status) {
        if (this.m_arObservers.size() == 0) {
            return;
        }
        this.m_nParsingStatus = _status;
        for (int i = 0; i < this.m_arObservers.size(); ++i) {
            IObserver observer = (IObserver)this.m_arObservers.get(i);
            try {
                observer.update(_subject, this.m_oHanderArg);
                continue;
            }
            catch (Throwable e) {
                logger.error((Object)("Fail to execute service![Observer=" + observer + "]"), e);
            }
        }
    }

    @Override
    public void attachObserver(IObserver _observer) {
        if (this.m_arObservers.contains(_observer)) {
            return;
        }
        this.m_arObservers.add(_observer);
    }

    @Override
    public void detachObserver(IObserver _observer) {
        if (!this.m_arObservers.contains(_observer)) {
            return;
        }
        this.m_arObservers.remove(_observer);
    }

    public void stopOnParsingError(ServiceInvocationException ex) {
        throw ex;
    }

    public void stopOnParsingCompleted(Object result) throws XMLParsingPausedException {
        this.m_pResult[this.m_nCurrResultIndex++] = result;
        this.clear();
    }
}

