/*
 * Decompiled with CFR 0.152.
 */
package com.trs.recycle.impl;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.DefaultObj;
import com.trs.cms.content.DefaultObjs;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.ObjectTypesFinder;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.cache.ICachedPOMgr;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.database.TableInfo;
import com.trs.recycle.IObjRecycleMgr;
import com.trs.recycle.ObjectRecycleXmlHandler;
import com.trs.recycle.RecycleObjConfXML;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import org.apache.log4j.Logger;

public abstract class ObjRecycleBaseMgr
implements IObjRecycleMgr {
    private static Logger s_logger = Logger.getLogger(ObjRecycleBaseMgr.class);
    public static final String RECYCLE_TABLE_SUFFIX = "RECYCLE";
    public static final String RECYCLEID = "RECYCLEID";

    public abstract void deleteRalation(BaseObj var1, User var2) throws WCMException;

    @Override
    public void dropObj(BaseObj baseObj, User user) throws WCMException {
        int nObjType = this.getObjType();
        BaseObj oriObject = null;
        try {
            oriObject = (BaseObj)ObjectTypesFinder.findObjectClassByType(nObjType).newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Hashtable<String, Object> recycleProp = baseObj.getAllProperty();
        recycleProp.remove(RECYCLEID);
        recycleProp.remove("HOSTID");
        recycleProp.remove("HOSTTYPE");
        recycleProp.remove("OPUSER");
        recycleProp.remove("OPTIME");
        int nOriObjId = ((Number)recycleProp.get(oriObject.getIdFieldName())).intValue();
        oriObject.setId(nOriObjId);
        oriObject.setProperties(recycleProp);
        this.deleteRalation(oriObject, user);
        baseObj.delete();
    }

    @Override
    public boolean delete(BaseObj baseObj, User user, int hostId, int hostType) throws WCMException {
        int nObjType = this.getObjType();
        if (!this.createRecycleTable(baseObj)) {
            return false;
        }
        this.insertIntoRecycleTable(baseObj, user, hostId, hostType);
        String sTableName = baseObj.getDbTableName();
        String sIdField = baseObj.getIdFieldName();
        String sDelSql = "delete from " + sTableName + " where " + sIdField + "=" + baseObj.getId();
        Connection oConn = null;
        PreparedStatement oPreStmt = null;
        try {
            oConn = this.getDBManager().getConnection();
            oPreStmt = oConn.prepareStatement(sDelSql);
            oPreStmt.executeUpdate();
        }
        catch (Exception e) {
            throw new WCMException("\u5220\u9664\u6570\u636e\u5931\u8d25\u3010ID\uff1a" + baseObj.getId() + "-Type:" + nObjType + "\u3011");
        }
        return false;
    }

    @Override
    public BaseObjs query(int objType, int hostId, int hostType) {
        Class clazz = ObjectTypesFinder.findObjectClassByType(objType);
        try {
            DBManager currDBManager;
            TableInfo oTable;
            BaseObj baseObj = (BaseObj)clazz.newInstance();
            String sDbRecycleTableName = this.getRecycleTableName(baseObj);
            WCMFilter oFilter = new WCMFilter();
            oFilter.setWhere("HOSTID=" + hostId + " and HOSTTYPE=" + hostType);
            if (hostId <= 0 || hostType <= 0) {
                oFilter = null;
            }
            if ((oTable = (currDBManager = DBManager.getDBManager()).getTableInfo(sDbRecycleTableName)) == null) {
                return DefaultObjs.createNewInstance(null);
            }
            DefaultObjs recycleObjs = DefaultObjs.openWCMObjs(this.getLoginUser(), oFilter, sDbRecycleTableName, RECYCLEID);
            return recycleObjs;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean restore(BaseObj baseObj) throws WCMException {
        int nOjbType = this.getObjType();
        RecycleObjConfXML objConfig = ObjectRecycleXmlHandler.newInstance().getObject(nOjbType);
        String sObjNameField = objConfig.getObjNameField();
        String sObjName = baseObj.getPropertyAsString(sObjNameField);
        String sDbTableName = baseObj.getDbTableName();
        String sSql = "select " + baseObj.getIdFieldName() + " from " + sDbTableName + " where " + sObjNameField + "=?";
        Connection oConn = null;
        PreparedStatement oPreStmt = null;
        try {
            oConn = this.getDBManager().getConnection();
            oPreStmt = oConn.prepareStatement(sSql);
            oPreStmt.setString(1, sObjName);
            ResultSet rsData = oPreStmt.executeQuery();
            if (rsData.next()) {
                Date date = new Date();
                SimpleDateFormat df = new SimpleDateFormat("yyyyMMddhhmmss");
                String sDate = df.format(date);
                String sNewObjName = baseObj.getPropertyAsString(sObjNameField) + "_R" + sDate;
                baseObj.setPropertyWithString(sObjNameField, sNewObjName);
            }
        }
        catch (Exception e) {
            throw new WCMException("\u67e5\u8be2\u539f\u6570\u636e\u5e93\u8bb0\u5f55\u5931\u8d25");
        }
        System.out.println("name:" + baseObj.getProperty(sObjNameField));
        this.insertIntoOriginalTable(baseObj);
        return true;
    }

    private boolean createRecycleTable(BaseObj baseObj) throws WCMException {
        String sTableName = this.getRecycleTableName(baseObj);
        DBManager currDBManager = DBManager.getDBManager();
        TableInfo oTable = currDBManager.getTableInfo(sTableName);
        if (oTable != null) {
            return true;
        }
        String sCreateTableSql = this.makeCreateTableSql(baseObj);
        try {
            currDBManager.sqlExecuteUpdate(sCreateTableSql);
        }
        catch (Exception e) {
            throw new WCMException("\u521b\u5efa\u56de\u6536\u7ad9\u8868\u51fa\u73b0\u5f02\u5e38\u3010Table:" + sTableName + "\u3011", e);
        }
        try {
            this.addTableField(baseObj);
        }
        catch (Exception e) {
            throw new WCMException("\u56de\u6536\u7ad9\u8868\u6dfb\u52a0\u5b57\u6bb5\u51fa\u73b0\u5f02\u5e38\u3010Table:" + sTableName + "\u3011", e);
        }
        currDBManager.reloadTableInfo(sTableName);
        return true;
    }

    private void addTableField(BaseObj baseObj) throws WCMException {
        String sTableName = this.getRecycleTableName(baseObj);
        String[] sAlterSql = new String[]{"alter table " + sTableName + " add RECYCLEID int", "alter table " + sTableName + " add OPUSER varchar(100)", "alter table " + sTableName + " add OPTIME date", "alter table " + sTableName + " add HOSTID int", "alter table " + sTableName + " add HOSTTYPE int"};
        this.getDBManager().sqlExecuteUpdate(sAlterSql);
    }

    public void insertIntoRecycleTable(BaseObj baseObj, User user, int hostId, int hostType) throws WCMException {
        CMyDateTime date = CMyDateTime.now();
        DefaultObj defaultObj = new DefaultObj(this.getRecycleTableName(baseObj), RECYCLEID){

            @Override
            public boolean isValid() {
                return true;
            }
        };
        Hashtable<String, Object> objParameters = baseObj.getProperties();
        Hashtable<String, Object> hParameters = new Hashtable<String, Object>(objParameters);
        hParameters.put("OPUSER", user.getName());
        hParameters.put("OPTIME", date);
        hParameters.put("HOSTID", hostId);
        hParameters.put("HOSTTYPE", hostType);
        defaultObj.setProperties(hParameters);
        try {
            defaultObj.insert();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void insertIntoOriginalTable(BaseObj baseObj) {
        System.out.println("33333==" + baseObj.getPropertyAsString("TEMPTEXT"));
        Connection oConn = null;
        PreparedStatement oPreStmt = null;
        try {
            Method insetMethod = BaseObj.class.getDeclaredMethod("createInsertSQL", null);
            Class[] args = new Class[]{PreparedStatement.class};
            Method setParametersMethod = BaseObj.class.getDeclaredMethod("setParameters", args);
            insetMethod.setAccessible(true);
            setParametersMethod.setAccessible(true);
            String sInsertSql = (String)insetMethod.invoke((Object)baseObj, null);
            oConn = this.getDBManager().getConnection();
            oPreStmt = oConn.prepareStatement(sInsertSql);
            setParametersMethod.invoke((Object)baseObj, oPreStmt);
            oPreStmt.executeUpdate();
            if (baseObj.isCached()) {
                baseObj.loadById(baseObj.getId(), null);
                ObjRecycleBaseMgr.getCachedPOMgr().notifyOnAddObj(baseObj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static ICachedPOMgr getCachedPOMgr() throws WCMException {
        ICachedPOMgr currCachedPOMgr = (ICachedPOMgr)DreamFactory.createObjectById("ICachedPOMgr");
        if (currCachedPOMgr == null) {
            throw new WCMException(10, "ICachedPOMgr Config Error!");
        }
        return currCachedPOMgr;
    }

    protected DBManager getDBManager() {
        DBManager currDBManager = DBManager.getDBManager();
        if (currDBManager == null || !currDBManager.isStarted()) {
            throw new Error(I18NMessage.get(BaseObj.class, "BaseObj.label42", "\u6570\u636e\u5e93\u6ca1\u6709\u6b63\u5e38\u542f\u52a8\uff01"));
        }
        return currDBManager;
    }

    private String makeCreateTableSql(BaseObj baseObj) {
        String sTableName = baseObj.getDbTableName();
        String sSql = "";
        int nDbType = this.getDBManager().getDBTypeAsInt();
        String sRecycleTableName = this.getRecycleTableName(baseObj);
        switch (nDbType) {
            case 2: 
            case 4: {
                sSql = "select * into " + sRecycleTableName + " from " + sTableName + " where 0=1";
                break;
            }
            default: {
                sSql = "create table " + sRecycleTableName + " as select * from " + sTableName + " where 0=1";
            }
        }
        return sSql;
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    private String getRecycleTableName(BaseObj baseObj) {
        return baseObj.getDbTableName() + RECYCLE_TABLE_SUFFIX;
    }
}

