/*
 * Decompiled with CFR 0.152.
 */
package com.trs.presentation.util;

import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;
import com.trs.presentation.util.PageParameter;
import com.trs.presentation.util.PageParameters;
import com.trs.presentation.util.RequestHelper;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class WhereSQLMaker {
    private static Logger logger = Logger.getLogger(WhereSQLMaker.class);
    public static final int TYPE_STRING_HASHCODE = -891985903;
    public static final int TYPE_INT_HASHCODE = 104431;
    public static final int TYPE_LONG_HASHCODE = 3327612;
    public static final int TYPE_FLOAT_HASHCODE = 97526364;
    public static final int TYPE_DOUBLE_HASHCODE = -1325958191;
    public static final int TYPE_DATE_HASHCODE = 3076014;
    public static final int TYPE_TIME_HASHCODE = 3560141;
    public static final int TYPE_DATETIME_HASHCODE = 1793702779;
    public static final int TYPE_BOOLEAN_HASHCODE = 64711720;
    PageParameters m_oPageParameters = null;
    private String m_sWhereSQL = null;
    private List m_listSearchValues = null;

    public WhereSQLMaker(PageParameters parameters) {
        this.m_oPageParameters = parameters;
    }

    public void makeWhereSQL(RequestHelper _currRequestHelper) throws WCMException {
        if (this.m_oPageParameters == null) {
            return;
        }
        String sWhereSQL = null;
        ArrayList<Object> listSearchValues = new ArrayList<Object>();
        int nSize = this.m_oPageParameters.size();
        for (int i = 0; i < nSize; ++i) {
            String sName;
            String sValue;
            PageParameter pageParameter = (PageParameter)this.m_oPageParameters.get(i);
            if (pageParameter == null || !pageParameter.isSearch() || (sValue = _currRequestHelper.getString(sName = pageParameter.getName())) == null || (sValue = sValue.trim()).length() == 0 || sValue.equals(pageParameter.getExcludeValue())) continue;
            sWhereSQL = sWhereSQL != null ? sWhereSQL + " and (" : "(";
            if (pageParameter.getSearchField() != null) {
                sName = pageParameter.getSearchField();
            }
            String sOperator = this.getSearchOperator(pageParameter);
            String[] pValues = null;
            pValues = "datetime".equalsIgnoreCase(pageParameter.getType()) ? new String[]{sValue} : CMyString.split(sValue, " ");
            boolean bFirst = true;
            for (int j = 0; j < pValues.length; ++j) {
                if (pValues[j].length() <= 0) continue;
                if (!bFirst) {
                    sWhereSQL = sWhereSQL + " and ";
                }
                bFirst = false;
                sWhereSQL = sWhereSQL + sName + " " + sOperator + " ? ";
                try {
                    listSearchValues.add(this.getSearchValue(pageParameter, pValues[j], sOperator));
                    continue;
                }
                catch (Exception e) {
                    throw new WCMException(I18NMessage.get(WhereSQLMaker.class, "WhereSQLMaker.label1", "\u6784\u9020\u5b57\u6bb5[") + sName + I18NMessage.get(WhereSQLMaker.class, "WhereSQLMaker.label2", "]\u7684\u67e5\u8be2\u5931\u8d25\uff01\u6570\u636e\u4e3a\uff1a") + sValue, e);
                }
            }
            sWhereSQL = sWhereSQL + ')';
        }
        this.setWhereSQL(sWhereSQL);
        this.setSearchValues(listSearchValues);
    }

    private String getSearchOperator(PageParameter _pageParameter) {
        String sOperator = _pageParameter.getSearchOperator();
        if (sOperator != null && (sOperator = sOperator.trim()).length() > 0) {
            return sOperator;
        }
        int nType = _pageParameter.getType().hashCode();
        switch (nType) {
            case -891985903: {
                return "like";
            }
        }
        return "=";
    }

    private Object getSearchValue(PageParameter _pageParameter, String _sValue, String _sOperator) throws CMyException {
        int nType = _pageParameter.getType().hashCode();
        CMyDateTime dtTemp = null;
        switch (nType) {
            case -891985903: {
                if (_sOperator.equalsIgnoreCase("LIKE")) {
                    return "%" + _sValue + "%";
                }
                return _sValue;
            }
            case 3076014: {
                if (_pageParameter.getSearchType() != null && _pageParameter.getSearchType().equals("long")) {
                    return this.convertDateToLong(_pageParameter, _sValue, "yyyy-MM-dd");
                }
                dtTemp = new CMyDateTime();
                dtTemp.setDateTimeWithString(_sValue, "yyyy-MM-dd");
                return dtTemp;
            }
            case 1793702779: {
                if (_pageParameter.getSearchType() != null && _pageParameter.getSearchType().equals("long")) {
                    return this.convertDateToLong(_pageParameter, _sValue, "yyyy-MM-dd HH:mm:ss");
                }
                dtTemp = new CMyDateTime();
                dtTemp.setDateTimeWithString(_sValue, "yyyy-MM-dd HH:mm:ss");
                return dtTemp;
            }
            case 3560141: {
                dtTemp = new CMyDateTime();
                dtTemp.setDateTimeWithString(_sValue, "HH:mm:ss");
                return dtTemp;
            }
            case 104431: 
            case 64711720: {
                return Integer.valueOf(_sValue);
            }
            case 97526364: {
                return Float.valueOf(_sValue);
            }
            case -1325958191: {
                return Double.valueOf(_sValue);
            }
        }
        return _sValue;
    }

    private Long convertDateToLong(PageParameter _pageParameter, String _sValue, String _sDateFormat) {
        long lTime = 0L;
        CMyDateTime dtTemp = new CMyDateTime();
        try {
            dtTemp.setDateTimeWithString(_sValue, _sDateFormat);
            lTime = dtTemp.getTimeInMillis();
        }
        catch (Exception e) {
            logger.error((Object)CMyString.format(I18NMessage.get(WhereSQLMaker.class, "WhereSQLMaker.label3", "\u67e5\u8be2\u4fe1\u606f[{0}]\u7684\u503c[{1}]\u4e0d\u662f\u65e5\u671f\u578b."), new String[]{_pageParameter.getName(), _sValue}), (Throwable)e);
        }
        return new Long(lTime);
    }

    public List getSearchValues() {
        return this.m_listSearchValues;
    }

    private void setSearchValues(List searchValues) {
        this.m_listSearchValues = searchValues;
    }

    public String getWhereSQL() {
        return this.m_sWhereSQL;
    }

    private void setWhereSQL(String whereSQL) {
        this.m_sWhereSQL = whereSQL;
    }
}

