/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.upgrade.sql;

import com.trs.infra.util.upgrade.Constants;
import com.trs.infra.util.upgrade.dbcompare.TableDiff;
import java.util.List;

public abstract class SchemaUpdSqlMaker {
    public String[] getSql(TableDiff diff) {
        if (diff.isNewtable()) {
            return new String[]{diff.toString() + Constants.SQL_SEPCHAR};
        }
        String name = diff.getTableName();
        return new String[]{this.getSql(name, diff.getNewcols(), 0), this.getSql(name, diff.getUpdcols(), 1), this.getSql(name, diff.getDelcols(), 2)};
    }

    protected String getSql(String tableName, List cols, int type) {
        if (cols.isEmpty()) {
            return "";
        }
        switch (type) {
            case 0: {
                return this.getSql4AddCols(tableName, cols);
            }
            case 1: {
                return this.getSql4ModifyCols(tableName, cols);
            }
            case 2: {
                return this.getSql4DelCols(tableName, cols);
            }
        }
        return "";
    }

    protected abstract String getSql4AddCols(String var1, List var2);

    protected abstract String getSql4ModifyCols(String var1, List var2);

    protected abstract String getSql4DelCols(String var1, List var2);
}

