/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.email;

import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyClassConfig;
import com.trs.infra.util.email.CMyMailException;
import com.trs.infra.util.email.SMTPServerConfig;
import com.trs.infra.util.email.SMTPServerConfigMapper;
import java.io.IOException;
import java.net.Socket;
import javax.net.ssl.SSLSocketFactory;

public class CMySMTPServer
extends CMyClassConfig {
    private static final int DEFAULT_PORT = 25;
    private static final boolean DEFAULT_AUTH = true;
    private String m_sServerName;
    private int m_sServerPort = 25;
    private boolean m_bAuth = true;
    private String m_sUserName;
    private String m_sPassword;
    private boolean m_bSSLServer = false;

    public void setServerName(String serverName) {
        this.m_sServerName = serverName;
    }

    public String getServerName() {
        return this.m_sServerName;
    }

    public void setServerPort(int serverPort) {
        this.m_sServerPort = serverPort;
    }

    public int getServerPort() {
        return this.m_sServerPort;
    }

    public void setAuth(boolean auth) {
        this.m_bAuth = auth;
    }

    public boolean needAuth() {
        return this.m_bAuth;
    }

    public void setUserName(String userName) {
        this.m_sUserName = userName;
    }

    public String getUserName() {
        return this.m_sUserName;
    }

    public void setPassword(String password) {
        this.m_sPassword = password;
    }

    public String getPassword() {
        return this.m_sPassword;
    }

    public void setSMTPConfig(SMTPServerConfig _mySMTPConfig) {
        this.setServerName(_mySMTPConfig.getName());
        this.setServerPort(_mySMTPConfig.getPort());
        this.setAuth(_mySMTPConfig.isAuth());
        this.setUserName(_mySMTPConfig.getUserName());
        this.setPassword(_mySMTPConfig.getPassword());
    }

    public static CMySMTPServer getDefaultSMTPServer() {
        CMySMTPServer currServer = new CMySMTPServer();
        SMTPServerConfig currConfig = SMTPServerConfigMapper.getInstance().getDefaultSMTPServerConfig();
        currServer.setSMTPConfig(currConfig);
        return currServer;
    }

    public static CMySMTPServer getSMTPServerByName(String _sServerName) {
        CMySMTPServer currServer = new CMySMTPServer();
        SMTPServerConfig currConfig = SMTPServerConfigMapper.getInstance().getSMTPServerConfigByName(_sServerName);
        currServer.setSMTPConfig(currConfig);
        return currServer;
    }

    public void validate() throws CMyMailException {
        if (this.getServerName() == null || this.getServerName().length() == 0) {
            throw new CMyMailException(I18NMessage.get(CMySMTPServer.class, "CMySMTPServer.label1", "\u90ae\u4ef6\u670d\u52a1\u5668\u540d\u79f0\u65e0\u6548\uff01"));
        }
        if (this.getServerPort() == 0) {
            throw new CMyMailException(I18NMessage.get(CMySMTPServer.class, "CMySMTPServer.label2", "\u90ae\u4ef6\u670d\u52a1\u5668\u7aef\u53e3\u4e0d\u80fd\u4e3a0\uff01"));
        }
    }

    public boolean canAuth() {
        return this.getUserName() != null && this.getPassword() != null;
    }

    public boolean isSSLServer() {
        return this.m_bSSLServer;
    }

    public void setSSLServer(boolean _bIsSSLServer) {
        this.m_bSSLServer = _bIsSSLServer;
    }

    public Socket createSocket() throws IOException {
        if (this.isSSLServer()) {
            SSLSocketFactory factory = (SSLSocketFactory)SSLSocketFactory.getDefault();
            return factory.createSocket(this.getServerName(), this.getServerPort());
        }
        return new Socket(this.getServerName(), this.getServerPort());
    }

    @Override
    public String toString() {
        String sInfo = "SMTP Server: " + this.getServerName() + ":" + this.getServerPort() + "\r\n";
        sInfo = this.needAuth() ? sInfo + "need auth, username: " + this.getUserName() + "" : sInfo + "do not need auth.";
        return sInfo;
    }
}

