/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.support.security;

import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.support.security.SecureKey;
import com.trs.infra.support.security.SecureKeys;
import com.trs.infra.util.BASE64DecoderStream;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.store.FileService;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;

public class SecureKeyMgr {
    public byte[] encrypt(String _sKeyName, byte[] _data) throws WCMException {
        SecureKey key = SecureKey.findByName(_sKeyName);
        this.assertNotNull(key, _sKeyName);
        String alg = key.getAlgorithm();
        if (!"DES".equals(alg)) {
            throw new WCMException(10, I18NMessage.get(SecureKeyMgr.class, "SecureKeyMgr.label1", "\u52a0\u5bc6\u5931\u8d25,\u4e0d\u662f\u6709\u6548\u7684\u52a0\u5bc6\u5bc6\u94a5[") + key + "]!");
        }
        try {
            Cipher cipher = Cipher.getInstance(alg);
            cipher.init(1, key.getPublicKey());
            return cipher.doFinal(_data);
        }
        catch (Exception e) {
            throw new WCMException(1100, I18NMessage.get(SecureKeyMgr.class, "SecureKeyMgr.label2", "\u52a0\u5bc6\u5931\u8d25!"), e);
        }
    }

    public byte[] decrypt(String _sKeyName, byte[] _bytes) throws WCMException {
        SecureKey key = SecureKey.findByName(_sKeyName);
        this.assertNotNull(key, _sKeyName);
        String alg = key.getAlgorithm();
        if (!"DES".equals(alg)) {
            throw new WCMException(10, I18NMessage.get(SecureKeyMgr.class, "SecureKeyMgr.label3", "\u89e3\u5bc6\u5931\u8d25,\u4e0d\u662f\u6709\u6548\u7684\u89e3\u5bc6\u5bc6\u94a5[") + key + "]!");
        }
        try {
            Cipher cipher = Cipher.getInstance(alg);
            cipher.init(2, key.getPrivateKey());
            return cipher.doFinal(_bytes);
        }
        catch (Exception e) {
            throw new WCMException(1100, I18NMessage.get(SecureKeyMgr.class, "SecureKeyMgr.label4", "\u89e3\u5bc6\u5931\u8d25!"), e);
        }
    }

    public byte[] sign(String _keyName, byte[] _data) throws WCMException {
        SecureKey key = SecureKey.findByName(_keyName);
        this.assertNotNull(key, _keyName);
        String alg = key.getAlgorithm();
        if (!"DSA".equals(alg)) {
            throw new WCMException(10, I18NMessage.get(SecureKeyMgr.class, "SecureKeyMgr.label5", "\u7b7e\u540d\u5931\u8d25,\u4e0d\u662f\u6709\u6548\u7684\u7b7e\u540d\u5bc6\u94a5[") + key + "]!");
        }
        try {
            Signature sign = Signature.getInstance(alg);
            sign.initSign((PrivateKey)key.getPrivateKey());
            sign.update(_data);
            return sign.sign();
        }
        catch (Exception e) {
            throw new WCMException(1100, I18NMessage.get(SecureKeyMgr.class, "SecureKeyMgr.label6", "\u7b7e\u540d\u5931\u8d25!"), e);
        }
    }

    public boolean verify(String _sKeyName, byte[] _data, byte[] _sign) throws WCMException {
        SecureKey key = SecureKey.findByName(_sKeyName);
        this.assertNotNull(key, _sKeyName);
        Key publicKey = key.getPublicKey();
        String alg = publicKey.getAlgorithm();
        if (!"DSA".equals(alg)) {
            throw new WCMException(10, I18NMessage.get(SecureKeyMgr.class, "SecureKeyMgr.label7", "\u6821\u9a8c\u7b7e\u540d\u5931\u8d25,\u4e0d\u662f\u6709\u6548\u7684\u7b7e\u540d\u5bc6\u94a5[") + key + "]!");
        }
        try {
            Signature sign = Signature.getInstance(alg);
            sign.initVerify((PublicKey)publicKey);
            sign.update(_data);
            return sign.verify(_sign);
        }
        catch (Exception e) {
            throw new WCMException(1100, I18NMessage.get(SecureKeyMgr.class, "SecureKeyMgr.label8", "\u6821\u9a8c\u7b7e\u540d\u5931\u8d25!"), e);
        }
    }

    public SecureKey save(SecureKey _secureKey) throws WCMException {
        if (!_secureKey.isAddMode()) {
            throw new WCMException(1100, I18NMessage.get(SecureKeyMgr.class, "SecureKeyMgr.label9", "\u4e0d\u80fd\u4fee\u6539SecureKey\u5bf9\u8c61!"));
        }
        String alg = _secureKey.getAlgorithm();
        if ("DES".equals(alg)) {
            try {
                KeyGenerator keyGen = KeyGenerator.getInstance(alg);
                keyGen.init(_secureKey.getKeySize());
                SecretKey key = keyGen.generateKey();
                _secureKey.setPrivateKey(key);
                _secureKey.setPublicKey(key);
            }
            catch (NoSuchAlgorithmException keyGen) {}
        } else if ("DSA".equals(alg)) {
            try {
                KeyPairGenerator keyGen = KeyPairGenerator.getInstance(alg);
                keyGen.initialize(_secureKey.getKeySize());
                KeyPair keyPair = keyGen.generateKeyPair();
                _secureKey.setPrivateKey(keyPair.getPrivate());
                _secureKey.setPublicKey(keyPair.getPublic());
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
        } else {
            throw new WCMException(1104, I18NMessage.get(SecureKeyMgr.class, "SecureKeyMgr.label10", "\u4e0d\u88ab\u652f\u6301\u7684\u7b97\u6cd5[") + alg + "]!");
        }
        _secureKey.insert();
        return _secureKey;
    }

    public SecureKeys getKeys(WCMFilter _filter) throws WCMException {
        return SecureKeys.openWCMObjs(_filter);
    }

    private void assertNotNull(SecureKey _secureKey, String _sKeyName) throws WCMException {
        if (_secureKey == null) {
            throw new WCMException(200006, I18NMessage.get(SecureKeyMgr.class, "SecureKeyMgr.label11", "\u6ca1\u6709\u627e\u5230[KeyName=") + _sKeyName + I18NMessage.get(SecureKeyMgr.class, "SecureKeyMgr.label12", "]\u7684SecureKey\u5bf9\u8c61!"));
        }
    }

    public String exportKey(String _sKeyName, boolean _zIsPrivate) throws WCMException {
        SecureKey secureKey = SecureKey.findByName(_sKeyName);
        this.assertNotNull(secureKey, _sKeyName);
        return this.exportKey(secureKey, _zIsPrivate);
    }

    public String exportKey(int _nKeyId, boolean _zIsPrivate) throws WCMException {
        SecureKey secureKey = SecureKey.findById(_nKeyId);
        if (secureKey == null) {
            throw new WCMException(200006, I18NMessage.get(SecureKeyMgr.class, "SecureKeyMgr.label13", "\u6ca1\u6709\u627e\u5230[id=") + _nKeyId + I18NMessage.get(SecureKeyMgr.class, "SecureKeyMgr.label14", "]\u7684\u5bc6\u94a5!"));
        }
        return this.exportKey(secureKey, _zIsPrivate);
    }

    private String exportKey(SecureKey _secureKey, boolean _zIsPrivate) throws WCMException {
        FilesMan fileMan = FilesMan.getFilesMan();
        String fn = fileMan.getNextFilePathName("ST", "dat");
        OutputStream fout = null;
        try {
            fout = new FileService(fn).getOutputStream();
            String keyInfo = null;
            keyInfo = _zIsPrivate ? _secureKey.getPropertyAsString("PRIVATEKEY") : _secureKey.getPropertyAsString("PUBLICKEY");
            fout.write(BASE64DecoderStream.decode(keyInfo));
            fout.close();
        }
        catch (Exception e) {
            throw new WCMException(50, I18NMessage.get(SecureKeyMgr.class, "SecureKeyMgr.label15", "\u751f\u6210\u5bc6\u94a5\u6587\u4ef6\u5931\u8d25\uff01"), e);
        }
        return CMyFile.extractFileName(fn);
    }
}

