/*
 * Decompiled with CFR 0.152.
 */
package com.trs.database.util;

import com.trs.infra.util.store.FileService;
import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Properties;

public class AllDDLMaker {
    private String conf = null;
    private String dbtype = null;
    private BufferedWriter writer = null;
    private Connection conn = null;
    private String tableNamePattern = null;
    private boolean doublelen = false;
    private boolean useNull = true;
    private Properties props = new Properties();

    public AllDDLMaker(String[] args) {
        this.conf = args[0];
        if (args.length > 1) {
            this.dbtype = args[1];
        }
        if (args.length > 2) {
            FileService file = new FileService(args[2]);
            if (!file.getParentFileStore().exists()) {
                file.getParentFileStore().mkdirs();
            }
            try {
                this.writer = new BufferedWriter(new OutputStreamWriter(file.getOutputStream(), "GBK"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void make() throws Exception {
        try {
            this.loadAndInit();
            if ("mysql.".equals(this.dbtype)) {
                this.makeTableDDL4MySql();
            } else {
                this.makeTableDDL();
            }
            this.makeIndexDDL();
        }
        finally {
            if (this.conn != null) {
                try {
                    this.conn.close();
                }
                catch (Exception exception) {}
            }
            if (this.writer != null) {
                try {
                    this.writer.flush();
                }
                catch (Exception exception) {}
                try {
                    this.writer.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void loadAndInit() throws Exception {
        InputStream ins = null;
        try {
            ins = new FileService(this.conf).getInputStream();
            this.props.load(ins);
        }
        finally {
            if (ins != null) {
                try {
                    ins.close();
                }
                catch (Exception exception) {}
            }
        }
        if (this.dbtype == null || this.dbtype.trim().length() == 0) {
            this.dbtype = this.props.getProperty("media.sql.dbtarget");
        }
        this.doublelen = "true".equals(this.props.getProperty("media.sql.doublelen"));
        this.doublelen = this.doublelen && !this.dbtype.equals("mssql");
        this.dbtype = this.dbtype.toLowerCase() + ".";
        this.useNull = "true".equals(this.props.getProperty(this.dbtype + "useNull"));
        this.tableNamePattern = this.props.getProperty("media.sql.tableNamePattern");
        if (this.tableNamePattern == null) {
            this.tableNamePattern = "%";
        }
        String username = this.props.getProperty("media.sql.dbuser");
        String password = this.props.getProperty("media.sql.dbpwd");
        String url = this.props.getProperty("media.sql.dburl");
        String driver = this.props.getProperty("media.sql.dbdriver");
        Class.forName(driver);
        this.conn = DriverManager.getConnection(url, username, password);
    }

    private void makeTableDDL() throws Exception {
        DatabaseMetaData dbMetaData = this.conn.getMetaData();
        ResultSet tables = dbMetaData.getTables(null, null, this.tableNamePattern, new String[]{"TABLE"});
        ResultSet columns = null;
        String tableName = null;
        String colName = null;
        int colType = 0;
        int colSize = 0;
        String def = null;
        ResultSet pks = null;
        String pk = null;
        StringBuffer buff = new StringBuffer(128);
        boolean zNotFirst = false;
        boolean zCharType = false;
        String typeName = null;
        while (tables.next()) {
            tableName = tables.getString(3).toUpperCase();
            buff.setLength(0);
            buff.append("CREATE TABLE ");
            buff.append('\"');
            buff.append(tableName);
            buff.append('\"');
            buff.append("(\n");
            pk = "";
            pks = dbMetaData.getPrimaryKeys(null, null, tableName);
            while (pks.next()) {
                pk = pk + ",\"" + pks.getString("COLUMN_NAME") + "\"";
            }
            pks.close();
            columns = dbMetaData.getColumns(null, null, tableName, null);
            zNotFirst = false;
            while (columns.next()) {
                if (zNotFirst) {
                    buff.append(",\n");
                }
                colName = columns.getString("COLUMN_NAME").toUpperCase();
                buff.append("\t");
                buff.append('\"');
                buff.append(colName);
                buff.append('\"');
                buff.append(" ");
                typeName = columns.getString("TYPE_NAME").toUpperCase();
                typeName = (String)this.props.get(this.dbtype + typeName);
                if (typeName == null) {
                    typeName = columns.getString("TYPE_NAME").toUpperCase();
                }
                buff.append(typeName.toUpperCase());
                colType = columns.getInt("DATA_TYPE");
                boolean bl = zCharType = 1 == colType || 12 == colType;
                if (zCharType) {
                    buff.append("(");
                    colSize = columns.getInt("COLUMN_SIZE");
                    if (this.doublelen) {
                        colSize = Math.min(colSize * 2, 4000);
                    }
                    buff.append(colSize);
                    buff.append(")");
                } else if (colType == 2) {
                    buff.append("(");
                    buff.append(columns.getInt("COLUMN_SIZE"));
                    buff.append(',');
                    buff.append(columns.getInt("DECIMAL_DIGITS"));
                    buff.append(")");
                }
                def = columns.getString("COLUMN_DEF");
                if (def != null) {
                    def = def.substring(1, def.length() - 1);
                    if (!zCharType) {
                        if (def.charAt(0) == 'g') {
                            def = this.props.getProperty(this.dbtype + "getdate");
                        } else {
                            while (def.indexOf(40) != -1) {
                                def = def.substring(1, def.length() - 1);
                            }
                        }
                    } else if (def.indexOf(39) == -1) {
                        def = '\'' + def + '\'';
                    }
                    buff.append(" DEFAULT ").append(def);
                }
                if (!"YES".equals(columns.getString("IS_NULLABLE"))) {
                    buff.append(" NOT NULL");
                } else if (this.useNull && pk.indexOf(colName) == -1) {
                    buff.append(" NULL");
                }
                zNotFirst = true;
            }
            columns.close();
            if (pk.length() > 1) {
                buff.append(",\n\tPRIMARY KEY (");
                buff.append(pk.substring(1));
                buff.append(")");
            }
            buff.append("\n);\n");
            if (this.writer != null) {
                this.writer.write(buff.toString());
                this.writer.flush();
                continue;
            }
            System.out.println(buff);
        }
        tables.close();
        this.props.clear();
    }

    private void makeTableDDL4MySql() throws Exception {
        DatabaseMetaData dbMetaData = this.conn.getMetaData();
        ResultSet tables = dbMetaData.getTables(null, null, this.tableNamePattern, new String[]{"TABLE"});
        ResultSet columns = null;
        String tableName = null;
        String colName = null;
        int colType = 0;
        int colSize = 0;
        String def = null;
        ResultSet pks = null;
        String pk = null;
        StringBuffer buff = new StringBuffer(128);
        boolean zNotFirst = false;
        boolean zCharType = false;
        boolean zFisrtTimeWithDefault = true;
        String typeName = null;
        while (tables.next()) {
            tableName = tables.getString(3).toUpperCase();
            buff.setLength(0);
            buff.append("CREATE TABLE ");
            buff.append('`');
            buff.append(tableName);
            buff.append('`');
            buff.append("(\n");
            pk = "";
            pks = dbMetaData.getPrimaryKeys(null, null, tableName);
            while (pks.next()) {
                pk = pk + ",`" + pks.getString("COLUMN_NAME") + "`";
            }
            pks.close();
            columns = dbMetaData.getColumns(null, null, tableName, null);
            zNotFirst = false;
            zFisrtTimeWithDefault = true;
            while (columns.next()) {
                if (zNotFirst) {
                    buff.append(",\n");
                }
                colName = columns.getString("COLUMN_NAME").toUpperCase();
                buff.append("\t");
                buff.append('`');
                buff.append(colName);
                buff.append('`');
                buff.append(" ");
                typeName = columns.getString("TYPE_NAME").toUpperCase();
                typeName = (String)this.props.get(this.dbtype + typeName);
                if (typeName == null) {
                    typeName = columns.getString("TYPE_NAME").toUpperCase();
                }
                buff.append(typeName.toUpperCase());
                colType = columns.getInt("DATA_TYPE");
                boolean bl = zCharType = 1 == colType || 12 == colType;
                if (zCharType) {
                    buff.append("(");
                    colSize = columns.getInt("COLUMN_SIZE");
                    if (this.doublelen) {
                        colSize = Math.min(colSize * 2, 4000);
                    }
                    buff.append(colSize);
                    buff.append(")");
                } else if (colType == 2) {
                    buff.append("(");
                    buff.append(columns.getInt("COLUMN_SIZE"));
                    buff.append(',');
                    buff.append(columns.getInt("DECIMAL_DIGITS"));
                    buff.append(")");
                }
                def = columns.getString("COLUMN_DEF");
                if (def != null) {
                    def = def.substring(1, def.length() - 1);
                    if (!zCharType) {
                        if (def.charAt(0) == 'g') {
                            if (zFisrtTimeWithDefault) {
                                def = this.props.getProperty(this.dbtype + "getdate");
                                zFisrtTimeWithDefault = false;
                            } else {
                                def = null;
                            }
                        } else {
                            while (def.indexOf(40) != -1) {
                                def = def.substring(1, def.length() - 1);
                            }
                        }
                    } else if (def.indexOf(39) == -1) {
                        def = '\'' + def + '\'';
                    }
                    if (def != null) {
                        buff.append(" DEFAULT ").append(def);
                    }
                }
                if (!"YES".equals(columns.getString("IS_NULLABLE"))) {
                    buff.append(" NOT NULL");
                } else if (this.useNull && pk.indexOf(colName) == -1) {
                    buff.append(" NULL");
                }
                zNotFirst = true;
            }
            columns.close();
            if (pk.length() > 1) {
                buff.append(",\n\tPRIMARY KEY (");
                buff.append(pk.substring(1));
                buff.append(")");
            }
            buff.append("\n);\n");
            if (this.writer != null) {
                this.writer.write(buff.toString());
                this.writer.flush();
                continue;
            }
            System.out.println(buff);
        }
        tables.close();
        this.props.clear();
    }

    private void makeIndexDDL() throws Exception {
        String sql = "select name from sysobjects where upper(name) like '%WCM%' and xtype='U' order by name asc";
        sql = sql.replaceAll("WCM", this.tableNamePattern.toUpperCase());
        Statement stmt = this.conn.createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        CallableStatement callableStmt = this.conn.prepareCall("sp_helpindex ?");
        ResultSet temprs = null;
        String indexName = null;
        String indexDesc = null;
        String indexKeys = null;
        String entryKey = null;
        HashSet<String> indexSet = new HashSet<String>(100, 0.2f);
        String tableName = null;
        StringBuffer buff = new StringBuffer(128);
        while (rs.next()) {
            tableName = rs.getString(1).toUpperCase();
            callableStmt.setString(1, tableName);
            try {
                temprs = callableStmt.executeQuery();
            }
            catch (Exception ex) {
                System.err.println("-- table has no index:" + tableName + ";");
                continue;
            }
            while (temprs.next()) {
                int dif;
                indexName = temprs.getString(1).toUpperCase();
                indexDesc = temprs.getString(2).toUpperCase();
                indexKeys = temprs.getString(3).toUpperCase();
                entryKey = tableName + "(" + indexKeys + ")";
                if (indexSet.contains(entryKey)) {
                    System.err.println("-- duplicate index on " + entryKey);
                    continue;
                }
                indexSet.add(entryKey);
                if (indexDesc.indexOf("PRIMARY KEY") != -1) continue;
                buff.setLength(0);
                buff.append("create ");
                if (indexDesc.indexOf("UNIQUE") != -1) {
                    buff.append("UNIQUE ");
                }
                if (indexDesc.indexOf("NONCLUSTERED") == -1 && indexDesc.indexOf("CLUSTERED") != -1) {
                    buff.append("CLUSTERED ");
                }
                buff.append("index ");
                if (!indexName.startsWith("IX_")) {
                    indexName = "IX_" + indexName;
                }
                if ((dif = indexName.length() - 30) >= 10) {
                    indexName = indexName.substring(0, 28) + dif;
                } else if (dif > 0) {
                    indexName = indexName.substring(0, 29) + dif;
                }
                buff.append(indexName);
                buff.append(" on ").append(tableName);
                buff.append('(');
                indexKeys = indexKeys.replaceAll("\\(-\\)", " desc");
                buff.append(indexKeys);
                buff.append(')');
                buff.append(';');
                buff.append('\n');
                if (this.writer != null) {
                    this.writer.write(buff.toString().toUpperCase());
                    this.writer.flush();
                    continue;
                }
                System.out.println(buff.toString().toUpperCase());
            }
            temprs.close();
        }
        rs.close();
        stmt.close();
        callableStmt.close();
    }

    public static void main(String[] args) {
        AllDDLMaker maker = new AllDDLMaker(args);
        try {
            maker.make();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

