/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.version;

import com.trs.DreamFactory;
import com.trs.cms.content.CMSObj;
import com.trs.components.metadata.center.MetaViewData;
import com.trs.components.wcm.content.WCMDocumentHelper;
import com.trs.components.wcm.content.domain.AppendixMgr;
import com.trs.components.wcm.content.persistent.Appendix;
import com.trs.components.wcm.content.persistent.Appendixes;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.version.AppendixUsedVersionMgr;
import com.trs.components.wcm.version.IObjSpecialHandler;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import org.apache.log4j.Logger;

public class AppendixSpecialHandler
implements IObjSpecialHandler {
    private AppendixUsedVersionMgr appendixUsedVersionMgr = (AppendixUsedVersionMgr)DreamFactory.createObjectById("IAppendixUsedVersionMgr");
    private static Logger logger = Logger.getLogger(AppendixSpecialHandler.class);

    @Override
    public String getCMSObjType() {
        return "";
    }

    @Override
    public void parseSpecialField(CMSObj _curObj, CMSObj _mainObj, int _nVersionNum) throws WCMException {
        Appendix docAppendix = (Appendix)_curObj;
        if (docAppendix.getFlag() == 40 || docAppendix.getFlag() == 30 || docAppendix.getPropertyAsString("RelatedColumn") != null) {
            return;
        }
        AppendixUsedVersionMgr appendixUsedVersionMgr = (AppendixUsedVersionMgr)DreamFactory.createObjectById("IAppendixUsedVersionMgr");
        appendixUsedVersionMgr.save(docAppendix.getFile());
    }

    @Override
    public void deleteSpecialField(CMSObj _curObj, CMSObj _mainObj, int _nVersionNum) throws WCMException {
        Appendix curAppendix = (Appendix)_curObj;
        AppendixMgr appendixMgr = (AppendixMgr)DreamFactory.createObjectById("AppendixMgr");
        WCMFilter filter = new WCMFilter("", "APPFILE=?", "");
        filter.addSearchValues(curAppendix.getFile());
        Appendixes appendixes = appendixMgr.getAppendixes(filter);
        boolean bInUseNow = appendixes.size() > 0 && appendixes.getAt(0).getPropertyAsLong("USEDVERSIONS", 0L) > 0L;
        this.appendixUsedVersionMgr.delete(curAppendix.getFile(), bInUseNow);
    }

    @Override
    public void recoverSpecialField(CMSObj _curObj, CMSObj _mainObj, int _nVersionNum) throws WCMException {
        Appendix currAppendix = (Appendix)_curObj;
        if (currAppendix.getId() != 0) {
            return;
        }
        Document doc = null;
        if (_mainObj instanceof Document) {
            doc = (Document)_mainObj;
        } else if (_mainObj instanceof MetaViewData) {
            doc = ((MetaViewData)_mainObj).getDocument();
        } else {
            return;
        }
        AppendixMgr appendixMgr = (AppendixMgr)DreamFactory.createObjectById("AppendixMgr");
        appendixMgr.deleteUnuseAppendixes(doc, "0", 10);
        appendixMgr.deleteUnuseAppendixes(doc, "0", 20);
        appendixMgr.deleteUnuseAppendixes(doc, "0", 40);
        WCMDocumentHelper.setAttachPicOfDocument(doc.getId(), 0);
    }
}

