/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.stat.domain;

import com.trs.components.wcm.stat.domain.ChartBuildException;
import com.trs.infra.I18NMessage;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;

public class ChartOption {
    public static final int PERIOD_DAY = 0;
    public static final int PERIOD_WEEK = 1;
    public static final int PERIOD_MONTH = 2;
    public static final int PERIOD_YEAR = 3;
    public static final String GROUPBY_DEFAULT = "UserId";
    public static String DEF_DATE_FORMAT = "yyyy-MM-dd HH:mm";
    private CMyDateTime m_dtStartStatTime;
    private CMyDateTime m_dtEndStatTime;
    private String m_sGroupBy;
    private String m_sStatTimeField;
    private String m_sCurrStageField;
    private int m_nPeriodType;
    private int m_nPeriodInterval = 1;
    private WCMFilter m_oExtraFilter = null;

    public ChartOption(CMyDateTime _dtStart, CMyDateTime _dtEnd, int _nPeriodType, String _sCurrStagField) {
        this.m_dtStartStatTime = _dtStart;
        this.m_dtEndStatTime = _dtEnd;
        this.m_nPeriodType = _nPeriodType;
        this.m_sCurrStageField = _sCurrStagField;
    }

    public ChartOption(CMyDateTime _dtStart, CMyDateTime _dtEnd, int _nPeriodType, String _sCurrStagField, String _sGroupBy, String _sStatTimeField) {
        this(_dtStart, _dtEnd, _nPeriodType, _sCurrStagField);
        this.m_sGroupBy = _sGroupBy;
        this.m_sStatTimeField = _sStatTimeField;
    }

    public void validate() {
        String sErrMsg = null;
        if (CMyString.isEmpty(this.m_sCurrStageField)) {
            sErrMsg = I18NMessage.get(ChartOption.class, "ChartOption.label1", "\u6ca1\u6709\u6307\u5b9a\u8981\u6d4f\u89c8\u7684\u8d8b\u52bf\u7edf\u8ba1\u5b57\u6bb5\uff01");
        }
        if (this.m_dtStartStatTime == null) {
            sErrMsg = I18NMessage.get(ChartOption.class, "ChartOption.label2", "\u6ca1\u6709\u6307\u5b9a\u5f00\u59cb\u65f6\u95f4\uff01");
        }
        if (this.m_dtEndStatTime == null) {
            this.m_dtEndStatTime = CMyDateTime.now();
        }
        if (this.m_dtEndStatTime.compareTo(this.m_dtStartStatTime) < 0L) {
            sErrMsg = I18NMessage.get(ChartOption.class, "ChartOption.label3", "\u7ed3\u675f\u65f6\u95f4\u65e9\u4e8e\u5f00\u59cb\u65f6\u95f4\uff01");
        }
        if (sErrMsg != null) {
            throw new ChartBuildException(sErrMsg);
        }
        if (this.m_nPeriodType < 0 || this.m_nPeriodType > 3) {
            this.m_nPeriodType = 0;
        }
        if (CMyString.isEmpty(this.m_sGroupBy)) {
            this.m_sGroupBy = GROUPBY_DEFAULT;
        }
        if (CMyString.isEmpty(this.m_sStatTimeField)) {
            this.m_sStatTimeField = "StatTime";
        }
    }

    public String getStartStatTimeAsString() {
        return this.m_dtStartStatTime.toString(DEF_DATE_FORMAT);
    }

    public String getEndStatTimeAsString() {
        return this.m_dtEndStatTime.toString(DEF_DATE_FORMAT);
    }

    public CMyDateTime getStartStatTime() {
        return this.m_dtStartStatTime;
    }

    public CMyDateTime getEndStatTime() {
        return this.m_dtEndStatTime;
    }

    public String getGroupBy() {
        return this.m_sGroupBy;
    }

    public String getStatTimeField() {
        return this.m_sStatTimeField;
    }

    public String getCurrStageField() {
        return this.m_sCurrStageField;
    }

    public int getPeriodType() {
        return this.m_nPeriodType;
    }

    public int getPeriodInterval() {
        if (this.m_nPeriodInterval <= 0) {
            this.m_nPeriodInterval = 1;
        }
        return this.m_nPeriodInterval;
    }

    public void setPeriodInterval(int periodInterval) {
        this.m_nPeriodInterval = periodInterval;
    }

    public void setStartStatTime(CMyDateTime startStatTime) {
        this.m_dtStartStatTime = startStatTime;
    }

    public void setEndStatTime(CMyDateTime endStatTime) {
        this.m_dtEndStatTime = endStatTime;
    }

    public void setGroupBy(String groupBy) {
        this.m_sGroupBy = groupBy;
    }

    public void setStatTimeField(String statTimeField) {
        this.m_sStatTimeField = statTimeField;
    }

    public void setCurrStageField(String currStageField) {
        this.m_sCurrStageField = currStageField;
    }

    public void setPeriodType(int periodType) {
        this.m_nPeriodType = periodType;
    }

    public WCMFilter getExtraFilter() {
        return this.m_oExtraFilter;
    }

    public void setExtraFilter(WCMFilter _filter) {
        this.m_oExtraFilter = _filter;
    }
}

