/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish.tagparser;

import com.trs.DreamFactory;
import com.trs.components.common.publish.domain.publisher.PublishPathCompass;
import com.trs.components.common.publish.domain.publisher.PublishSyncGlobalTuner;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.ITagParser;
import com.trs.components.common.publish.domain.tagparser.TagBeanAttrInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.template.TemplateQuote;
import com.trs.components.metadata.center.MetaViewData;
import com.trs.components.metadata.publish.PublishContentViewDataImpl;
import com.trs.components.wcm.content.domain.AppendixMgr;
import com.trs.components.wcm.content.persistent.Appendix;
import com.trs.components.wcm.content.persistent.Appendixes;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.publish.element.PublishContentDocumentImpl;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.NamesRegister;
import com.trs.infra.util.html.HtmlUtil;
import com.trs.infra.util.store.FileService;
import com.trs.infra.util.store.FileStore;
import java.io.File;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class XWCMFileAppendixTagParser
implements ITagParser {
    private static Logger logger = Logger.getLogger(XWCMFileAppendixTagParser.class);
    private static NamesRegister s_oAppendixTypeRegister = new NamesRegister();
    private Document m_oDocument = null;
    private TagItem m_tagItem = null;
    private static TagBeanInfo s_TagBeanInfo;
    private static int n_maxRepeatTimes;

    @Override
    public TemplateQuote[] analyzeQuotes(IPublishFolder arg0) throws WCMException {
        return null;
    }

    @Override
    public TagBeanInfo getBeanInfo() {
        if (s_TagBeanInfo == null) {
            TagBeanAttrInfo tbai = null;
            TagBeanInfo tbi = new TagBeanInfo();
            tbi.setName("TRS_FILE");
            tbi.setDesc("TRS_FILE");
            tbi.setType(TagBeanInfo.BodyType.IGNORE);
            tbai = new TagBeanAttrInfo();
            tbai.setName("FIELD");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("UrlIsAbs");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setEnumValue(new String[]{"true", "false"});
            tbai.setDefaultValue("false");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("INDEX");
            tbai.setType(TagBeanAttrInfo.Type.INTEGER);
            tbai.setDefaultValue("0");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("PATTERN");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("EXTRA");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
        }
        return s_TagBeanInfo;
    }

    private AppendixMgr getAppMgr() {
        return (AppendixMgr)DreamFactory.createObjectById("AppendixMgr");
    }

    @Override
    public void setTagItem(TagItem _item) {
        this.m_tagItem = _item;
    }

    @Override
    public String[] parse(PublishTagContext _context) throws WCMException {
        Appendixes aApps;
        IPublishElement upperHost = _context.getUpperHost();
        this.m_oDocument = this.getDocument(_context);
        if (this.m_oDocument == null) {
            return null;
        }
        String sUploadPathName = null;
        int nAppType = 10;
        int nIndex = _context.getAttribute("INDEX", 0);
        String sTagAttr = (String)_context.getAttributes().get("PATTERN");
        if (CMyString.isEmpty(sTagAttr)) {
            sTagAttr = "${NAME}_${CRTIME}.${EXT}";
        }
        if ((aApps = this.getAllAppendixes(_context, nAppType)) == null || aApps.size() == 0) {
            logger.debug((Object)("\u6587\u6863\u6ca1\u6709\u6587\u4ef6\u9644\u4ef6[CHANNELID=" + this.m_oDocument.getChannelId() + ",DOCID=" + this.m_oDocument.getDocId() + "]"));
            return null;
        }
        if (nIndex <= 0) {
            StringBuffer sResult = new StringBuffer();
            for (int i = 0; i < aApps.size(); ++i) {
                Appendix appendix = (Appendix)aApps.getAt(i);
                sUploadPathName = this.findSrcPathName(appendix);
                if (!CMyFile.fileExists(sUploadPathName)) {
                    String sErrorInfo = "\u76f8\u5173\u7684\u6587\u4ef6\u5728\u670d\u52a1\u5668\u4e0a\u4e0d\u5b58\u5728\uff01[\u6587\u4ef6\u540d=" + appendix.getFile() + "\uff0c\u9644\u4ef6ID=" + appendix.getId() + ", \u6587\u6863ID=" + this.m_oDocument.getId() + ", \u6587\u6863\u6807\u9898=" + this.m_oDocument.getTitle() + "]";
                    logger.error((Object)sErrorInfo);
                    throw new WCMException(sErrorInfo);
                }
                String sSerFileName = CMyFile.extractFileName(sUploadPathName);
                String sNewFileName = this.makeAppFileName(sUploadPathName, sTagAttr, appendix);
                this.distributeFile(_context, upperHost, sSerFileName, sNewFileName);
                String sField = _context.getAttribute("FIELD");
                String sBeginHtml = (String)_context.getAttributes().get("BEGINHTML");
                String sEndHtml = (String)_context.getAttributes().get("ENDHTML");
                if (CMyString.isEmpty(sField)) {
                    PublishPathCompass compass = _context.getPathCompass();
                    String sRelativeFileHref = HtmlUtil.calRelativePath(compass.getAbsoluteHttpPath(upperHost), _context.getPageHttpPath()) + sNewFileName;
                    if (!CMyString.isEmpty(sBeginHtml)) {
                        sResult.append(sBeginHtml);
                    }
                    sResult.append("<a href=\"");
                    sResult.append(sRelativeFileHref);
                    sResult.append("\" target=\"_blank\">");
                    sResult.append(sNewFileName);
                    sResult.append("</a>");
                    if (!CMyString.isEmpty(sEndHtml)) {
                        sResult.append(sEndHtml);
                    }
                }
                if (CMyString.isEmpty(sField) || !sField.toUpperCase().equalsIgnoreCase("_RECURL")) continue;
                String sURL = XWCMFileAppendixTagParser.getApdHttpPath(_context) + sNewFileName;
                if (!_context.getAttribute("UrlIsAbs", false)) {
                    sURL = HtmlUtil.calRelativePath(sURL, _context.getPageHttpPath());
                }
                sResult.append(sURL);
            }
            return new String[]{sResult.toString()};
        }
        if (nIndex > 0 && nIndex <= aApps.size()) {
            Appendix appendix = (Appendix)aApps.getAt(nIndex - 1);
            sUploadPathName = this.findSrcPathName(appendix);
            if (CMyString.isEmpty(sUploadPathName)) {
                String sErrorInfo = "\u76f8\u5173\u7684\u6587\u4ef6\u5728\u670d\u52a1\u5668\u4e0a\u4e0d\u5b58\u5728\uff01[\u6587\u4ef6\u540d=" + appendix.getFile() + "\uff0c\u9644\u4ef6ID=" + appendix.getId() + ", \u6587\u6863ID=" + this.m_oDocument.getId() + ", \u6587\u6863\u6807\u9898=" + this.m_oDocument.getTitle() + "]";
                logger.error((Object)sErrorInfo);
                throw new WCMException(sErrorInfo);
            }
            if (!CMyFile.fileExists(sUploadPathName)) {
                String sErrorInfo = "\u76f8\u5173\u7684\u6587\u4ef6\u5728\u670d\u52a1\u5668\u4e0a\u4e0d\u5b58\u5728\uff01[\u6587\u4ef6\u540d=" + appendix.getFile() + "\uff0c\u9644\u4ef6ID=" + appendix.getId() + ", \u6587\u6863ID=" + this.m_oDocument.getId() + ", \u6587\u6863\u6807\u9898=" + this.m_oDocument.getTitle() + "]";
                logger.error((Object)sErrorInfo);
                throw new WCMException(sErrorInfo);
            }
            String sSerFileName = CMyFile.extractFileName(sUploadPathName);
            String sNewFileName = this.makeAppFileName(sUploadPathName, sTagAttr, appendix);
            this.distributeFile(_context, upperHost, sSerFileName, sNewFileName);
            PublishPathCompass compass = _context.getPathCompass();
            String sRelativeFileHref = HtmlUtil.calRelativePath(compass.getAbsoluteHttpPath(upperHost), _context.getPageHttpPath()) + sNewFileName;
            StringBuffer sResult = new StringBuffer();
            String sField = _context.getAttribute("FIELD");
            if (CMyString.isEmpty(sField)) {
                sResult.append("<a href=\"");
                sResult.append(sRelativeFileHref);
                sResult.append("\" target=\"_blank\">");
                sResult.append(sNewFileName);
                sResult.append("</a>");
            }
            if (sField != null && sField.toUpperCase().equalsIgnoreCase("_RECURL")) {
                String sURL = XWCMFileAppendixTagParser.getApdHttpPath(_context) + sNewFileName;
                if (!_context.getAttribute("UrlIsAbs", false)) {
                    sURL = HtmlUtil.calRelativePath(sURL, _context.getPageHttpPath());
                }
                sResult.append(sURL);
            }
            return new String[]{sResult.toString()};
        }
        String sErrorInfo = "\u4f60\u8bbe\u7f6e\u7684index\u8d85\u51fa\u4e86\u6587\u6863\u5305\u542b\u7684\u6587\u4ef6\u9644\u4ef6\u603b\u6570[\u680f\u76eeID=" + this.m_oDocument.getChannelId() + ",\u6587\u6863ID=" + this.m_oDocument.getId() + "]";
        logger.error((Object)sErrorInfo);
        throw new WCMException(sErrorInfo);
    }

    protected static String getApdHttpPath(PublishTagContext _context) throws WCMException {
        IPublishElement apdOwner = _context.getUpperHost();
        if (apdOwner == null) {
            throw new WCMException("\u6ca1\u6709\u627e\u5230UpperHost\u5bf9\u8c61!");
        }
        if (!(apdOwner instanceof IPublishContent)) {
            throw new WCMException("\u5f53\u524dUpperHost[" + apdOwner.getInfo() + "]\u4e0d\u662fIPublishContent\u5bf9\u8c61");
        }
        PublishPathCompass compass = _context.getPathCompass();
        return compass.getAbsoluteHttpPath(apdOwner);
    }

    private String makeAppFileName(String sUploadPathName, String sTagAttr, Appendix appendix) throws WCMException {
        String sFileFullName = appendix.getSrcFile();
        String sSrcFileExt = CMyFile.extractFileExt(sUploadPathName);
        int nLength = sFileFullName.length() - sSrcFileExt.length() - 1;
        if (nLength <= 0) {
            String sErrorInfo = "\u4e0a\u4f20\u6587\u6863\u7684\u6587\u4ef6\u540d\u4e3a\u7a7a\uff01[\u6587\u4ef6\u540d=" + appendix.getFile() + "\uff0c\u9644\u4ef6ID=" + appendix.getId() + ", \u6587\u6863ID=" + this.m_oDocument.getId() + ", \u6587\u6863\u6807\u9898=" + this.m_oDocument.getTitle() + "]";
            logger.error((Object)sErrorInfo);
            throw new WCMException(sErrorInfo);
        }
        String sSrcFileName = sFileFullName.substring(0, nLength);
        int nChnlId = this.m_oDocument.getChannelId();
        Channel channel = (Channel)Channel.findById(Channel.class, nChnlId);
        String sExp_StockNo = channel.getProperties().get("EXP_STOCKNO") + "";
        String sExp_StockName = channel.getProperties().get("EXP_CSNAME") + "";
        int nDocId = this.m_oDocument.getId();
        int nAppId = appendix.getId();
        CMyDateTime dTime = this.m_oDocument.getCrTime();
        String sChnlId = nChnlId + "";
        String sDocId = nDocId + "";
        String sAppId = nAppId + "";
        String sCrTime = dTime.toString("yyyyMMddHH");
        HashMap<String, String> hMap = new HashMap<String, String>();
        hMap.put("NAME", sSrcFileName);
        hMap.put("CHNLID", sChnlId);
        hMap.put("DOCID", sDocId);
        hMap.put("CRTIME", sCrTime);
        hMap.put("EXT", sSrcFileExt);
        hMap.put("APPID", sAppId);
        hMap.put("EXPSTOCKNO", sExp_StockNo);
        hMap.put("EXPSTOCKNAME", sExp_StockName);
        String sNewFileName = CMyString.parsePageVariables(sTagAttr, hMap);
        return sNewFileName;
    }

    private void distributeFile(PublishTagContext _context, IPublishElement _upperHost, String _sOldFileName, String _sNewFileName) throws WCMException {
        FileService oBackupFile;
        String sFileName = _sOldFileName;
        String sPhysicalPath = FilesMan.getFilesMan().mapFilePath(sFileName, 0);
        String sSrcFilePathName = sPhysicalPath + sFileName;
        if (!CMyFile.fileExists(sSrcFilePathName)) {
            _context.addWarning(_upperHost.getInfo() + "-\u6587\u4ef6", _upperHost.getId(), "\u5728\u78c1\u76d8\u4e0a\u6ca1\u6709\u627e\u5230(" + _upperHost.getInfo() + ")\u7684\u6587\u4ef6[" + sFileName + "]");
            return;
        }
        FileService oSrcFile = new FileService(sSrcFilePathName);
        PublishPathCompass compass = _context.getPathCompass();
        boolean bPreview = _context.isPreview();
        String sLocalPath = CMyString.setStrEndWith(compass.getLocalPath(_upperHost, bPreview), File.separatorChar);
        PublishSyncGlobalTuner.insureLocalPathExists(sLocalPath);
        String sBackupFileFullPath = sPhysicalPath + _sNewFileName;
        if (!CMyString.isEmpty(sBackupFileFullPath) && !CMyString.isEmpty(CMyFile.extractFileName(sBackupFileFullPath)) && (!(oBackupFile = new FileService(sBackupFileFullPath)).exists() || oBackupFile.exists() && (double)oBackupFile.length() != (double)oSrcFile.length())) {
            this.completeCopyFile(sSrcFilePathName, oSrcFile, sBackupFileFullPath, oBackupFile);
        }
        boolean bNeedDistribute = true;
        String oTargetFilePath = sLocalPath + _sNewFileName;
        FileService oTargetFile = new FileService(oTargetFilePath);
        if (!oTargetFile.exists() || oTargetFile.exists() && (double)oTargetFile.length() != (double)oSrcFile.length()) {
            this.completeCopyFile(sSrcFilePathName, oSrcFile, oTargetFilePath, oTargetFile);
        } else {
            bNeedDistribute = false;
            logger.debug((Object)"\u6e90\u6587\u4ef6\u5df2\u7ecf\u5b58\u5728\uff0c\u6b64\u65f6\u4e0d\u518d\u590d\u5236");
        }
        if (!bPreview && bNeedDistribute) {
            _context.getFileDistributeShip().distributeFile(sBackupFileFullPath, _upperHost);
        }
    }

    private void completeCopyFile(String sSrcFilePathName, FileStore oSrcFile, String sBackupFileFullPath, FileStore oBackupFile) throws WCMException {
        for (int i = 0; i < n_maxRepeatTimes; ++i) {
            try {
                CMyFile.copyFile(sSrcFilePathName, sBackupFileFullPath);
                if ((double)oBackupFile.length() == (double)oSrcFile.length()) break;
                logger.error((Object)("\u6267\u884c\u6587\u4ef6\u62f7\u8d1d\u5931\u8d25[CHANNELID=" + this.m_oDocument.getChannelId() + ",DOCID=" + this.m_oDocument.getDocId() + "]"));
                continue;
            }
            catch (CMyException e) {
                logger.error((Object)"\u62f7\u8d1d\u6587\u4ef6\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
                if (i != 99) continue;
                String sError = "\u6587\u4ef6[CHANNELID=" + this.m_oDocument.getChannelId() + ",DOCID=" + this.m_oDocument.getDocId() + "]\u62f7\u8d1d\u51fa\u73b0\u5f02\u5e38\u5e76\u4e2d\u6b62";
                logger.error((Object)sError);
                throw new WCMException(sError);
            }
        }
    }

    private String findSrcPathName(Appendix appendix) throws WCMException {
        String sSrcFilePathName = "";
        String sFileName = appendix.getFile();
        if (CMyString.isEmpty(sFileName)) {
            return null;
        }
        sSrcFilePathName = FilesMan.getFilesMan().mapFilePath(sFileName, 0) + sFileName;
        return sSrcFilePathName;
    }

    private Appendixes getAllAppendixes(PublishTagContext _context, int nAppType) throws WCMException {
        BaseObjs aApps = null;
        for (int i = 0; i < n_maxRepeatTimes; ++i) {
            try {
                aApps = this.getAppMgr().getAppendixes(this.m_oDocument, nAppType);
                break;
            }
            catch (WCMException e) {
                logger.error((Object)"\u8bfb\u53d6\u6570\u636e\u5e93\u4fe1\u606f\u5931\u8d25\uff01", (Throwable)e);
                if (i != 99) continue;
                aApps = null;
                String sError = "\u53d1\u5e03\u6587\u6863[CHANNELID=" + this.m_oDocument.getChannelId() + ",DOCID=" + this.m_oDocument.getDocId() + "]\u51fa\u9519\u5e76\u4e2d\u6b62\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u5e93\u8fde\u63a5\u662f\u5426\u6b63\u5e38";
                logger.error((Object)sError);
                throw new WCMException(sError);
            }
        }
        if (aApps == null || aApps.size() == 0) {
            return null;
        }
        return aApps;
    }

    private Document getDocument(PublishTagContext _context) throws WCMException {
        IPublishElement oElement = _context.getUpperHost();
        if (oElement instanceof PublishContentDocumentImpl) {
            return (Document)oElement.getSubstance();
        }
        if (oElement instanceof PublishContentViewDataImpl) {
            MetaViewData oViewData = (MetaViewData)oElement.getSubstance();
            return oViewData.getDocumnent();
        }
        return null;
    }

    public void clear() {
        if (this.m_tagItem != null) {
            this.m_tagItem = null;
        }
        if (this.m_oDocument != null) {
            this.m_oDocument = null;
        }
    }

    static {
        s_oAppendixTypeRegister.register("LINK", 40);
        s_oAppendixTypeRegister.register("FILE", 10);
        s_oAppendixTypeRegister.register("PIC", 20);
        s_oAppendixTypeRegister.register("ALL", 60);
        s_TagBeanInfo = null;
        n_maxRepeatTimes = 100;
    }
}

