/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish.tagparser;

import com.trs.components.common.publish.config.PublishServerConfigMapper;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.ITagParser;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.template.TemplateQuote;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.publish.tagparser.WCMTagParserHelper;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import org.apache.log4j.Logger;

public abstract class WCMTagParser4FolderHostBase
implements ITagParser {
    private static Logger logger = Logger.getLogger((String)WCMTagParser4FolderHostBase.class.getName());
    protected TagItem m_tagItem;

    @Override
    public void setTagItem(TagItem _item) {
        this.m_tagItem = _item;
    }

    protected abstract int getQuoteType();

    protected BaseChannel findHost(PublishTagContext _context, boolean _bMustBeChannel) throws WCMException {
        return WCMTagParserHelper.findFolderHost(this.m_tagItem, _context, _bMustBeChannel);
    }

    protected BaseChannel findHost(PublishTagContext _context, boolean _bMustBeChannel, boolean _bIsFromAllCata) throws WCMException {
        return WCMTagParserHelper.findFolderHost(this.m_tagItem, _context, _bMustBeChannel, _bIsFromAllCata);
    }

    @Override
    public TemplateQuote[] analyzeQuotes(IPublishFolder _root) throws WCMException {
        int nFamilyIndex = WCMTagParserHelper.getChildIndex(this.m_tagItem);
        int nChannelType = this.m_tagItem.getIntAttribute("CHANNELTYPE", 0);
        Channel channel = null;
        String sChannelName = this.m_tagItem.getAttributeTrim("ID");
        if (TagItem.isVariableParameter(sChannelName)) {
            return null;
        }
        if (sChannelName != null && sChannelName.length() > 0) {
            String sKey = "SITEID:";
            if (sChannelName.toUpperCase().startsWith(sKey)) {
                return null;
            }
            if (sChannelName.toUpperCase().startsWith("CHANNELID:")) {
                int nChannelId = 0;
                try {
                    nChannelId = Integer.parseInt(sChannelName.substring("CHANNELID:".length()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (nChannelId > 0) {
                    channel = Channel.findById(nChannelId);
                }
            } else {
                switch (sChannelName.toUpperCase().hashCode()) {
                    case 2545479: {
                        if (nFamilyIndex <= 0 && nChannelType != 1 && nChannelType != 2) {
                            return null;
                        }
                        channel = (Channel)_root.getSubstance();
                        break;
                    }
                    case -1942094678: {
                        if (nFamilyIndex >= 0 && nChannelType != 1 && nChannelType != 2) {
                            return null;
                        }
                        nFamilyIndex = -2;
                        break;
                    }
                    case 75627155: {
                        break;
                    }
                    default: {
                        channel = Channel.findByName(_root.getId(), sChannelName);
                        if (channel != null) break;
                        String sMsg = I18NMessage.get(WCMTagParser4FolderHostBase.class, "WCMTagParser4FolderHostBase.label1", "\u6307\u5b9a\u7ad9\u70b9\u4e2d\u6ca1\u6709\u540d\u79f0\u4e3a [") + sChannelName + "] in " + _root.getInfo() + I18NMessage.get(WCMTagParser4FolderHostBase.class, "WCMTagParser4FolderHostBase.label2", "\u7684\u9891\u9053! \u7f6e\u6807\u5185\u5bb9:") + this.m_tagItem.toString();
                        logger.error((Object)sMsg);
                        if (PublishServerConfigMapper.isIgnoreIfHostNotFound()) {
                            return null;
                        }
                        throw new WCMException(233, sMsg);
                    }
                }
            }
        }
        if (nChannelType == 1 || nChannelType == 2) {
            if (channel == null) {
                try {
                    channel = (Channel)WCMTagParserHelper.findTopNewsOrPicChannel((WebSite)_root.getSubstance(), nChannelType);
                }
                catch (Exception e) {
                    channel = null;
                }
            } else {
                channel = (Channel)WCMTagParserHelper.findTopNewsOrPicChannel(channel, nChannelType);
            }
        }
        if (channel == null && nFamilyIndex == -1) {
            return null;
        }
        TemplateQuote aQuote = new TemplateQuote();
        aQuote.setQuoteType(this.getQuoteType());
        if (channel == null) {
            aQuote.setQuotedFolder(0, 0, nFamilyIndex);
        } else {
            aQuote.setQuotedFolder(channel.getWCMType(), channel.getId(), nFamilyIndex);
        }
        return new TemplateQuote[]{aQuote};
    }
}

