/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.persistent;

import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.User;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.IChannelNameMgr;
import com.trs.components.wcm.content.persistent.Replaces;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.BizError;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyBitsValue;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class Channel
extends BaseChannel {
    private static final long serialVersionUID = 1L;
    private static Logger m_oLogger = Logger.getLogger(Channel.class);
    public static final int OBJ_TYPE = 101;
    public static final String DB_TABLE_NAME = "WCMCHANNEL";
    public static final String DB_ID_NAME = "CHANNELID";
    public static final int SET_ONLYSEARCH = 1;
    public static final int SET_CANPUB = 2;
    public static final int SET_ONLYMANAGER = 3;
    public static final int SET_INHERIT_DETAIL = 4;
    public static final int SET_INHERIT_OUTLINE = 5;
    public static final int SET_INHERIT_RIGHT = 6;
    public static final int SET_INHERIT_EXTEND = 7;
    public static final int SET_CLICK_PREVIEW = 8;
    public static final int SET_CHNL_USER = 9;
    public static final int DO_DEPT_FILTER = 11;
    public static final int TYPE_NORM = 0;
    public static final int TYPE_TOP_PICS = 1;
    public static final int TYPE_TOP_NEWS = 2;
    public static final int TYPE_LINK = 11;
    public static final int TYPE_SUREFORM = 12;
    public static final int TYPE_INFOVIEW = 13;
    public static final int TYPE_DEFINE_MAX = 20;
    public static final int EXCLUDE_FROM_ORDER_MAX = 10;
    public static final int MOVE_AS_BROTHER = 0;
    public static final int MOVE_AS_CHILD = 1;
    public static final String SUREFORM_ATTR = "SUREFORMFILE";
    public static final String DEFAULT_CONTENTLISTPAGE = "../document/document_list_of_channel.jsp";
    public static final String DEFAULT_CONTENTADDEDITPAGE = "../document/document_addedit.jsp";
    public static final String DEFAULT_CONTENTSHOWPAGE = "../document/document_show.jsp";
    public static final String DEFAULT_LINKCHANNELPAGE = "../document/document_list_of_linkchannel.jsp";
    public static final int DRAFT_CHANNEL_ID = 0;
    public static final Channel DRAFT_CHANNEL = new Channel(){

        @Override
        public String toString() {
            return I18NMessage.get(Channel.class, "Channel.label1", "\u8349\u7a3f\u7bb1");
        }
    };
    private byte[] DOC_ORDER_LOCK = new byte[0];
    public static final int TIME_LIMITED_NOT = 0;
    public static final int TIME_LIMITED_DEFAULT = 1;
    public static final int TIME_LIMITED_SPECIAL_RANGE = 2;
    public static final int TIME_LIMITED_SPECIAL_POINT = 3;
    private static final int DIRECTION_MOVE_FORWARD = 1;
    private static final int DIRECTION_MOVE_BACK = -1;
    private static final int DIRECTION_MOVE_NO = 0;

    @Override
    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    @Override
    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    @Override
    public int getWCMType() {
        return 101;
    }

    @Override
    public int getSiteId() {
        return this.getPropertyAsInt("SITEID", 0);
    }

    public int getIsPushable() {
        return this.getPropertyAsInt("ISPUSHABLE", 0);
    }

    public int getIsDistributable() {
        return this.getPropertyAsInt("ISDISTRIBUTABLE", 0);
    }

    @Override
    public WebSite getSite() throws WCMException {
        int nSiteId = this.getSiteId();
        if (nSiteId == 0) {
            return null;
        }
        return WebSite.findById(nSiteId);
    }

    public boolean setSite(int _nSiteId) throws WCMException {
        WebSite website = WebSite.findById(_nSiteId);
        return this.setSite(website);
    }

    public boolean setSite(WebSite _website) throws WCMException {
        if (!this.isAddMode()) {
            m_oLogger.debug((Object)I18NMessage.get(Channel.class, "Channel.label2", "\u5728\u9891\u9053\u4e0d\u662f\u65b0\u589e\u72b6\u6001\u4e0b\uff0c\u4fee\u6539\u4e86\u9891\u9053\u6240\u5c5e\u7ad9\u70b9\uff0c\u4e00\u822c\u7528\u4e8e\u9891\u9053\u8de8\u7ad9\u70b9\u79fb\u52a8\uff0c\u5176\u5b83\u64cd\u4f5c\u5e94\u4e3a\u975e\u6cd5\u3002"));
        }
        if (_website == null || !_website.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(Channel.class, "Channel.label3", "\u65e0\u6548\u7684\u7ad9\u70b9\u5bf9\u8c61(Channel.setSite)"));
        }
        return this.setProperty("SITEID", _website.getId());
    }

    @Override
    public String getName() {
        return (String)this.getProperty("CHNLNAME");
    }

    @Override
    public boolean setName(String _name) throws WCMException {
        return this.setProperty("CHNLNAME", _name);
    }

    @Override
    public String getDesc() {
        return (String)this.getProperty("CHNLDESC");
    }

    public boolean setDesc(String _desc) throws WCMException {
        return this.setProperty("CHNLDESC", _desc);
    }

    public String getTable() {
        return (String)this.getProperty("CHNLTABLE");
    }

    public boolean setTable(String _table) throws WCMException {
        return this.setProperty("CHNLTABLE", _table);
    }

    public String getQuery() {
        return (String)this.getProperty("CHNLQUERY");
    }

    public boolean setQuery(String _query) throws WCMException {
        return this.setProperty("CHNLQUERY", _query);
    }

    public int getChnlProperty() {
        return this.getPropertyAsInt("CHNLPROP", 0);
    }

    public boolean setChnlProperty(int _nProperty) throws WCMException {
        return this.setProperty("CHNLPROP", _nProperty);
    }

    @Override
    public int getParentId() {
        return this.getPropertyAsInt("PARENTID", 0);
    }

    public Channel getParent() throws WCMException {
        if (this.getParentId() <= 0) {
            return null;
        }
        return Channel.findById(this.getParentId());
    }

    public boolean setParent(BaseChannel _parent) throws WCMException {
        if (_parent == null || _parent.isSite()) {
            return this.setParent(0);
        }
        if (!_parent.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(Channel.class, "Channel.label4", "\u65e0\u6548\u7684\u7236\u9891\u9053\u5bf9\u8c61(Channel.setParent)"));
        }
        return this.setParent(_parent.getId());
    }

    @Override
    public boolean setParent(int _parentId) throws WCMException {
        return this.setProperty("PARENTID", _parentId);
    }

    @Override
    public int getOrder() {
        return this.getPropertyAsInt("CHNLORDER", 0);
    }

    public boolean setOrder(int _order) throws WCMException {
        return this.setProperty("CHNLORDER", _order);
    }

    public String getOrderBy() {
        return (String)this.getProperty("CHNLORDERBY");
    }

    public boolean setOrderBy(String _sOrderBy) throws WCMException {
        return this.setProperty("CHNLORDERBY", _sOrderBy);
    }

    @Override
    public int getStatus() {
        return this.getPropertyAsInt("STATUS", 0);
    }

    @Override
    public boolean setStatus(int _status) throws WCMException {
        return this.setProperty("STATUS", _status);
    }

    public int getType() {
        return this.getPropertyAsInt("CHNLTYPE", 0);
    }

    public String getTypeDesc() {
        String sTypeDesc = I18NMessage.get(Channel.class, "Channel.label5", "\u672a\u77e5\u7c7b\u578b");
        switch (this.getType()) {
            case 0: {
                sTypeDesc = I18NMessage.get(Channel.class, "Channel.label6", "\u666e\u901a");
                break;
            }
            case 1: {
                sTypeDesc = I18NMessage.get(Channel.class, "Channel.label7", "\u56fe\u7247");
                break;
            }
            case 2: {
                sTypeDesc = I18NMessage.get(Channel.class, "Channel.label8", "\u5934\u6761");
                break;
            }
            case 11: {
                sTypeDesc = I18NMessage.get(Channel.class, "Channel.label9", "\u94fe\u63a5");
                break;
            }
            case 13: {
                sTypeDesc = I18NMessage.get(Channel.class, "Channel.label10", "\u8868\u5355");
                break;
            }
        }
        return sTypeDesc;
    }

    public boolean setType(int _type) throws WCMException {
        return this.setProperty("CHNLTYPE", _type);
    }

    public boolean isNormType() {
        return this.getType() == 0;
    }

    public boolean isLink() {
        return this.getType() == 11;
    }

    public String getLinkUrl() {
        return this.getPropertyAsString("LINKURL");
    }

    public boolean setLinkUrl(String _sUrl) throws WCMException {
        return this.setProperty("LINKURL", _sUrl);
    }

    public boolean isOnlySearch() {
        return CMyBitsValue.getBit(this.getChnlProperty(), 1);
    }

    public boolean setOnlySearch(boolean _bOnlySearch) throws WCMException {
        return this.setChnlProp(1, _bOnlySearch);
    }

    public boolean isCanPub() {
        if (this.getType() == 2 || this.getType() == 1) {
            return true;
        }
        return CMyBitsValue.getBit(this.getChnlProperty(), 2);
    }

    public boolean setCanPub(boolean _bCanPub) throws WCMException {
        return this.setChnlProp(2, _bCanPub);
    }

    private boolean setChnlProp(int _index, boolean _bValue) throws WCMException {
        Object oValue;
        CMyBitsValue tempBits = new CMyBitsValue(this.getChnlProperty());
        if (!this.isAddMode() && (oValue = this.getNewProperty("CHNLPROP")) != null) {
            tempBits.setValue(((Number)oValue).longValue());
        }
        tempBits.setBit(_index, _bValue);
        return this.setChnlProperty(tempBits.getValueAsInt());
    }

    public boolean isOnlyManager() {
        return CMyBitsValue.getBit(this.getChnlProperty(), 3);
    }

    public boolean setOnlyManager(boolean _bOnlyManager) throws WCMException {
        return this.setChnlProp(3, _bOnlyManager);
    }

    public boolean isClickPreview() {
        return CMyBitsValue.getBit(this.getChnlProperty(), 8);
    }

    public boolean setClickPreview(boolean _bClickPreview) throws WCMException {
        return this.setChnlProp(8, _bClickPreview);
    }

    public boolean isToChnlUser() {
        return CMyBitsValue.getBit(this.getChnlProperty(), 9);
    }

    public boolean setToChnlUser(boolean _bToChnlUser) throws WCMException {
        return this.setChnlProp(9, _bToChnlUser);
    }

    public boolean isInheritDetail() {
        return CMyBitsValue.getBit(this.getChnlProperty(), 4);
    }

    public boolean setInheritDetail(boolean _bInheritDetail) throws WCMException {
        return this.setChnlProp(4, _bInheritDetail);
    }

    public boolean isInheritOutline() {
        return CMyBitsValue.getBit(this.getChnlProperty(), 5);
    }

    public boolean setInheritOutline(boolean _bInheritOutline) throws WCMException {
        return this.setChnlProp(5, _bInheritOutline);
    }

    public boolean isInheritRight() {
        return CMyBitsValue.getBit(this.getChnlProperty(), 6);
    }

    public boolean isInheritExtend() {
        return CMyBitsValue.getBit(this.getChnlProperty(), 7);
    }

    public boolean setInheritExtend(boolean _bInheritExtend) throws WCMException {
        return this.setChnlProp(7, _bInheritExtend);
    }

    public boolean isDoDeptFilter() {
        return CMyBitsValue.getBit(this.getChnlProperty(), 11);
    }

    public boolean setDoDeptFilter(boolean _bIsDoDeptFilter) throws WCMException {
        return this.setChnlProp(11, _bIsDoDeptFilter);
    }

    private synchronized int getMaxOrder() throws WCMException {
        int nParentId = this.getNewParentId();
        StringBuffer buff = new StringBuffer("SELECT max(ChnlOrder) FROM ");
        buff.append(DB_TABLE_NAME).append(" WHERE ParentId=").append(nParentId);
        buff.append(" AND (ChnlType>10 OR ChnlType=0)");
        if (nParentId == 0) {
            buff.append(" AND SiteID=").append(this.getSiteId());
        }
        return DBManager.getDBManager().sqlExecuteIntQuery(buff.toString());
    }

    private int getNewParentId() {
        int nParentId = this.getParentId();
        if (this.isChangeProperty("PARENTID")) {
            nParentId = this.getNewPropertyAsInt("PARENTID", 0);
        }
        return nParentId;
    }

    private int getNewSiteId() {
        int nSiteId = this.getSiteId();
        if (this.isChangeProperty("SiteId")) {
            nSiteId = this.getNewPropertyAsInt("SiteId", 0);
        }
        return nSiteId;
    }

    @Override
    public boolean isValid() throws WCMException {
        String sName = null;
        int nChnlType = 0;
        if (this.isAddMode()) {
            sName = (String)this.getProperty("CHNLNAME");
            if (sName == null) {
                throw new WCMException(1106, I18NMessage.get(Channel.class, "Channel.label11", "\u5c5e\u6027Name\u6ca1\u6709\u8bbe\u7f6e"));
            }
            if (this.getProperty("PARENTID") != null && this.getProperty("SITEID") == null) {
                Channel parent = Channel.findById(this.getParentId());
                if (parent == null) {
                    throw new WCMException(I18NMessage.get(Channel.class, "Channel.label12", "\u6307\u5b9a\u7684\u7236\u7ed3\u70b9[") + this.getParentId() + I18NMessage.get(Channel.class, "Channel.label13", "]\u4e0d\u5b58\u5728\uff01"));
                }
                this.setSite(parent.getSiteId());
            }
            if (this.getProperty("SITEID") == null) {
                throw new WCMException(1106, I18NMessage.get(Channel.class, "Channel.label14", "\u5c5e\u6027SiteId\u6ca1\u6709\u8bbe\u7f6e"));
            }
            if (this.getProperty("PARENTID") == null) {
                throw new WCMException(1106, I18NMessage.get(Channel.class, "Channel.label15", "\u5c5e\u6027ParentId\u6ca1\u6709\u8bbe\u7f6e"));
            }
            if (this.getProperty("CHNLTYPE") == null) {
                this.setType(0);
            }
            nChnlType = this.getType();
        } else {
            int nNewParentId;
            if (!this.isModified()) {
                throw new WCMException(1107, I18NMessage.get(Channel.class, "Channel.label16", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u4fee\u6539"));
            }
            nChnlType = this.isChangeProperty("CHNLTYPE") ? this.getNewPropertyAsInt("CHNLTYPE", nChnlType) : this.getType();
            sName = (String)this.getNewProperty("CHNLNAME");
            if (this.isChangeProperty("PARENTID") && (nNewParentId = this.getNewPropertyAsInt("PAERNTID", 0)) > 0) {
                Channel newParent = Channel.findById(nNewParentId);
                if (newParent == null) {
                    throw new WCMException(10, I18NMessage.get(Channel.class, "Channel.label17", "\u65b0\u8bbe\u7f6e\u7684\u7236\u680f\u76ee\u4e0d\u5b58\u5728!"));
                }
                this.validLoop(newParent);
            }
        }
        if (sName != null) {
            WCMFilter filter = new WCMFilter();
            filter.setFrom(DB_TABLE_NAME);
            StringBuilder where = new StringBuilder("SiteId = ? and ChnlName = ?");
            filter.addSearchValues(this.getSiteId());
            filter.addSearchValues(sName);
            if (!this.isAddMode()) {
                where.append(" and " + this.getIdFieldName() + " <> ? ");
                filter.addSearchValues(this.getId());
            }
            filter.setWhere(where.toString());
            if (DBManager.getDBManager().sqlExecuteCountQuery(filter) > 0) {
                throw new BizError("\u680f\u76ee\u552f\u4e00\u6807\u8bc6[" + sName + "]\u5df2\u7ecf\u5b58\u5728");
            }
        }
        this.changeOrder();
        return true;
    }

    private String getSpecialTypeName(int _nType) {
        switch (_nType) {
            case 2: {
                return I18NMessage.get(Channel.class, "Channel.label21", "\u5934\u6761\u65b0\u95fb");
            }
            case 1: {
                return I18NMessage.get(Channel.class, "Channel.label22", "\u56fe\u7247\u65b0\u95fb");
            }
        }
        return "";
    }

    protected int deleteMySelf(User _currUser) throws WCMException {
        return super.delete(_currUser);
    }

    @Override
    public int delete(User _currUser) throws WCMException {
        if (!this.isValidInstance()) {
            return 0;
        }
        return this.deleteMySelf(_currUser);
    }

    public boolean isVirtual() {
        return this.getType() == 2 || this.getType() == 1 || this.getType() == 11 || this.isOnlySearch();
    }

    public Replaces getReplaces(User _currUser) throws WCMException {
        Replaces aReplaces = new Replaces(_currUser);
        WCMFilter newFilter = new WCMFilter("", " CHNLID=" + this.getId(), "", "ReplaceId");
        aReplaces.open(newFilter);
        return aReplaces;
    }

    public boolean setInputFile(String _sFile) throws WCMException {
        return this.setAttribute("INPUTFILE", _sFile);
    }

    public String getInputFile() {
        String sDefault = "/wcm/doc/post_document.jsp";
        String sValue = this.getAttributeValue("INPUTFILE");
        if (sValue == null || sValue.trim().length() == 0) {
            return sDefault;
        }
        return sValue;
    }

    public boolean setEditFile(String _sFile) throws WCMException {
        return this.setAttribute("EDITFILE", _sFile);
    }

    public String getEditFile() {
        String sDefault = "/wcm/doc/edit_document.jsp";
        String sValue = this.getAttributeValue("EDITFILE");
        if (sValue == null || sValue.trim().length() == 0) {
            return sDefault;
        }
        return sValue;
    }

    public boolean setOutlineFile(String _sFile) throws WCMException {
        return this.setAttribute("OUTLINEFILE", _sFile);
    }

    public String getOutlineFile() {
        String sDefault = "/wcm/doc/list_document.jsp";
        String sValue = this.getAttributeValue("OUTLINEFILE");
        if (sValue == null || sValue.trim().length() == 0) {
            return sDefault;
        }
        return sValue;
    }

    public boolean setDetailFile(String _sFile) throws WCMException {
        return this.setAttribute("DETAILFILE", _sFile);
    }

    public String getDetailFile() {
        String sDefault = "/wcm/doc/show_doc.jsp";
        String sValue = this.getAttributeValue("DETAILFILE");
        if (sValue == null || sValue.trim().length() == 0) {
            return sDefault;
        }
        return sValue;
    }

    public String getTimeWhere() throws Exception {
        if (!this.isListByTimeRange()) {
            return "";
        }
        String sDateField = "WCMChnlDoc.CRTIME";
        String sStartDate = "";
        String sEndDate = "";
        int nTimeLimitedMode = this.getTimeLimitedMode();
        switch (nTimeLimitedMode) {
            case 1: 
            case 2: {
                int nTimeRange = this.getTimeRange(nTimeLimitedMode == 1);
                CMyDateTime dtStart = CMyDateTime.now().dateAdd(3, -nTimeRange);
                sStartDate = dtStart.toString("yyyy-MM-dd");
                sEndDate = CMyDateTime.now().toString("yyyy-MM-dd");
                break;
            }
            case 3: {
                sStartDate = this.getStartTime();
                sEndDate = this.getEndTime();
                break;
            }
            default: {
                return "";
            }
        }
        String sWhere = sDateField + ">=" + this.getDBManager().getDBType().sqlDateTime(sStartDate + " 00:00:00", "YYYY-MM-DD HH24:MI:SS");
        sWhere = sWhere + " and ";
        sWhere = sWhere + sDateField + "<=" + this.getDBManager().getDBType().sqlDateTime(sEndDate + " 23:59:59", "YYYY-MM-DD HH24:MI:SS");
        return sWhere;
    }

    public boolean isListByTimeRange() {
        return this.isListByTimeRange(false);
    }

    public boolean isListByTimeRange(boolean _bSystem) {
        if (_bSystem) {
            String sValue = ConfigServer.getServer().getInitProperty("LIST_BY_TIME_RANGE");
            if (sValue == null) {
                return false;
            }
            return sValue.trim().toUpperCase().equals("TRUE");
        }
        int nTimeLimitedMode = this.getTimeLimitedMode();
        if (nTimeLimitedMode == 1) {
            return this.isListByTimeRange(true);
        }
        return nTimeLimitedMode > 1;
    }

    public int getTimeRange() {
        return this.getTimeRange(false);
    }

    public int getTimeRange(boolean _bSystem) {
        if (_bSystem) {
            int nTimeRange = 0;
            String sValue = ConfigServer.getServer().getInitProperty("DAYS_IN_TIME_RANGE");
            if (sValue == null || sValue.trim().length() <= 0) {
                return nTimeRange;
            }
            try {
                nTimeRange = Integer.parseInt(sValue.trim());
            }
            catch (Exception ex) {
                nTimeRange = 7;
            }
            return nTimeRange;
        }
        int nTimeRange = 7;
        String sValue = this.getAttributeValue("DAYS_IN_TIME_RANGE");
        if (sValue == null) {
            return this.getTimeRange(true);
        }
        try {
            nTimeRange = Integer.parseInt(sValue.trim());
        }
        catch (Exception ex) {
            nTimeRange = this.getTimeRange(true);
        }
        return nTimeRange;
    }

    public void setTimeRange(int _nTimeRange) throws Exception {
        this.setAttribute("DAYS_IN_TIME_RANGE", String.valueOf(_nTimeRange));
    }

    public String getStartTime() {
        if (this == null) {
            return "";
        }
        String sValue = this.getAttributeValue("START_TIME_RANGE");
        if (sValue == null) {
            return "";
        }
        return sValue.trim();
    }

    public void setStartTime(CMyDateTime _dtStart) throws Exception {
        String sTemp = "";
        if (_dtStart != null && !_dtStart.isNull()) {
            sTemp = _dtStart.toString("yyyy-MM-dd");
        }
        this.setAttribute("START_TIME_RANGE", sTemp);
    }

    public String getEndTime() {
        String sValue = this.getAttributeValue("END_TIME_RANGE");
        if (sValue == null) {
            return "";
        }
        return sValue.trim();
    }

    public void setEndTime(CMyDateTime _dtEnd) throws Exception {
        String sTemp = "";
        if (_dtEnd != null && !_dtEnd.isNull()) {
            sTemp = _dtEnd.toString("yyyy-MM-dd");
        }
        this.setAttribute("END_TIME_RANGE", sTemp);
    }

    public int getTimeLimitedMode() {
        String sValue = this.getAttributeValue("TIME_LIMITED_MODE");
        if (sValue == null) {
            return 1;
        }
        try {
            return Integer.parseInt(sValue);
        }
        catch (Exception ex) {
            return 1;
        }
    }

    public void setTimeLimitedMode(int _nTimeLimitedMode) throws Exception {
        if (_nTimeLimitedMode < 0 || _nTimeLimitedMode > 3) {
            return;
        }
        this.setAttribute("TIME_LIMITED_MODE", String.valueOf(_nTimeLimitedMode));
    }

    @Override
    public boolean isSite() {
        return false;
    }

    @Override
    public synchronized void update(User _currUser) throws WCMException {
        int nParentId;
        int n = nParentId = this.isAddMode() ? this.getParentId() : this.getNewPropertyAsInt("PARENTID", 0);
        if (nParentId == this.getId()) {
            throw new WCMException(10, I18NMessage.get(Channel.class, "Channel.label23", "\u7531\u4e8e\u4e0d\u53ef\u9884\u77e5\u7684\u95ee\u9898\uff0c\u4f60\u5c06\u8981\u8fdb\u884c\u7684\u64cd\u4f5c\u4f1a\u5f71\u54cd\u7cfb\u7edf\u7684\u7a33\u5b9a\u6027\uff0c\u672c\u64cd\u4f5c\u5c06\u88ab\u53d6\u6d88\uff08Channel.update(parentid=id)\uff09\uff01\u8bf7\u60a8\u8bb0\u5f55\u4e0b\u60a8\u6b63\u5728\u8fdb\u884c\u7684\u64cd\u4f5c\u5e76\u548c\u7ba1\u7406\u5458\u8054\u7cfb\u3002\u8c22\u8c22\uff01"));
        }
        this.setProperty("OPERUSER", _currUser.getName());
        this.setProperty("OPERTIME", CMyDateTime.now());
        super.update(_currUser);
    }

    public static final Channel findById(int _nId) throws WCMException {
        if (_nId <= 0) {
            return null;
        }
        return (Channel)BaseObj.findById(Channel.class, _nId);
    }

    public static final Channel createNewInstance() throws WCMException {
        return (Channel)BaseObj.createNewInstance(Channel.class);
    }

    public static final Channel findByKey(Object _oKey) throws WCMException {
        return (Channel)BaseObj.findByKey(Channel.class, _oKey);
    }

    @Override
    public BaseChannel getHost() throws WCMException {
        if (this.getParentId() == 0) {
            return this.getSite();
        }
        return this.getParent();
    }

    private static IChannelNameMgr getChannelNameMgr() throws WCMException {
        IChannelNameMgr channelNameMgr = (IChannelNameMgr)DreamFactory.createObjectById("IChannelNameMgr");
        if (channelNameMgr == null) {
            throw new WCMException(10, "IChannelNameMgr Config Error!");
        }
        return channelNameMgr;
    }

    public static Channel findByName(int _nSiteId, String _sChannelName) {
        try {
            return Channel.getChannelNameMgr().findByName(_nSiteId, _sChannelName);
        }
        catch (WCMException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public String toString() {
        if (this.IS_ENGVERSION) {
            return this.getDesc();
        }
        return this.getDesc() + I18NMessage.get(Channel.class, "Channel.label24", "[\u680f\u76ee-") + this.getId() + "]";
    }

    public void validLoop() throws WCMException {
        this.validLoop(this.getParent());
    }

    protected void validLoop(Channel _parent) throws WCMException {
        if (_parent == null) {
            return;
        }
        ArrayList<Integer> listValidedChnls = new ArrayList<Integer>(1);
        listValidedChnls.add(this.getKey());
        _parent.validLoop(listValidedChnls);
    }

    protected void validLoop(List _listValidedChnls) throws WCMException {
        if (_listValidedChnls.indexOf(this.getKey()) >= 0) {
            throw new WCMException(10, I18NMessage.get(Channel.class, "Channel.label25", "\u680f\u76ee\u7684\u7236\u5b50\u7ee7\u627f\u6811\u4e0a\u6709\u56de\u8def!"));
        }
        if (this.getParent() == null) {
            return;
        }
        _listValidedChnls.add(this.getKey());
        this.getParent().validLoop(_listValidedChnls);
    }

    public boolean setSureFormFile(String _sSureFormFileName) throws WCMException {
        return this.setAttribute(SUREFORM_ATTR, _sSureFormFileName);
    }

    public String getSureFormFileName() {
        if (this.getType() != 12) {
            return null;
        }
        return this.getAttributeValue(SUREFORM_ATTR);
    }

    public String getNewSureFormFileName() {
        return this.getNewAttributeValue(SUREFORM_ATTR);
    }

    public String getContentListPage() {
        if (this.getType() == 11) {
            return DEFAULT_LINKCHANNELPAGE;
        }
        String sValue = this.getPropertyAsString("ContentListPage");
        if (CMyString.isEmpty(sValue)) {
            return DEFAULT_CONTENTLISTPAGE;
        }
        return sValue;
    }

    public String getContentAddEditPage() {
        String sValue = this.getPropertyAsString("ContentAddEditPage");
        if (CMyString.isEmpty(sValue)) {
            return DEFAULT_CONTENTADDEDITPAGE;
        }
        return sValue;
    }

    public String getContentShowPage() {
        String sValue = this.getPropertyAsString("ContentShowPage");
        if (CMyString.isEmpty(sValue)) {
            return DEFAULT_CONTENTSHOWPAGE;
        }
        return sValue;
    }

    @Override
    public String getInfo() {
        return "[channel-" + this.getId() + "]" + this.getName();
    }

    public String getOutlineFields() {
        String sValue = this.getPropertyAsString("OutlineFileds");
        if (sValue == null || sValue.trim().length() == 0) {
            return null;
        }
        return sValue;
    }

    public boolean setOutlineFields(String _sOutlineFields) throws WCMException {
        return this.setProperty("OutlineFileds", _sOutlineFields);
    }

    public boolean isCluster() {
        return this.getPropertyAsBoolean("IsCluster", false);
    }

    public boolean setCluster(boolean _bCluster) throws WCMException {
        return this.setProperty("IsCluster", _bCluster);
    }

    public boolean isContainsChildren() {
        return this.getPropertyAsBoolean("isContainsChildren", false);
    }

    public boolean setContainsChildren(boolean _bContainsChildren) throws WCMException {
        return this.setProperty("isContainsChildren", _bContainsChildren);
    }

    public String getMetaSynFields() {
        return this.getPropertyAsString("MetaSynFields", "docTitle=&docContent=");
    }

    public boolean setMetaSynFields(String _metaSynFieldValue) throws WCMException {
        return this.setProperty("MetaSynFields", _metaSynFieldValue);
    }

    private void changeOrder() throws WCMException {
        int nMaxOrder;
        int nNewOrder;
        if (this.getType() == 2 || this.getType() == 1) {
            if (this.isAddMode()) {
                this.setOrder(this.getMaxOrder() + 1);
            }
            return;
        }
        int nMoveBeginAt = 0;
        int nMoveEndAt = 0;
        int nMoveDirection = 0;
        if (this.isAddMode()) {
            nNewOrder = this.getOrder();
            nMaxOrder = this.getMaxOrder();
            if (nNewOrder == -1) {
                nNewOrder = nMaxOrder + 1;
            } else {
                nMoveDirection = 1;
                nMoveEndAt = nMaxOrder;
                nMoveBeginAt = nNewOrder;
            }
        } else {
            if (!this.isChangeProperty("ChnlOrder") && !this.isChangeProperty("PARENTID")) {
                return;
            }
            nNewOrder = this.getNewPropertyAsInt("ChnlOrder", -1);
            if (nNewOrder == -1) {
                nMaxOrder = this.getMaxOrder();
                if (this.isChangeProperty("PARENTID")) {
                    nNewOrder = nMaxOrder + 1;
                } else if (nMaxOrder == this.getOrder()) {
                    nNewOrder = this.getOrder();
                } else {
                    nMoveDirection = -1;
                    nMoveEndAt = nMaxOrder;
                    nMoveBeginAt = this.getOrder() + 1;
                    nNewOrder = nMaxOrder;
                }
            } else if (this.isChangeProperty("PARENTID")) {
                nNewOrder = this.getMaxOrder() + 1;
            } else if (nNewOrder > this.getOrder()) {
                nMoveDirection = -1;
                nMoveEndAt = --nNewOrder;
                nMoveBeginAt = this.getOrder() + 1;
            } else {
                nMoveDirection = 1;
                nMoveEndAt = this.getOrder() - 1;
                nMoveBeginAt = nNewOrder;
            }
        }
        String sRegionWhere = "ChnlOrder>=" + nMoveBeginAt + " AND ChnlOrder <= " + nMoveEndAt + " and ParentId=" + this.getNewParentId() + " and SiteId=" + this.getNewSiteId();
        String sMoveSql = "UPDATE WCMChannel SET ChnlOrder = ChnlOrder+(" + nMoveDirection + ") WHERE " + sRegionWhere;
        WCMFilter aFilter = new WCMFilter("", sRegionWhere, "ChnlOrder desc");
        Channels channels = Channels.openWCMObjs(null, aFilter);
        DBManager.getDBManager().sqlExecuteUpdate(sMoveSql);
        for (int i = 0; i < channels.size(); ++i) {
            Channel child = (Channel)channels.getAt(i);
            if (child == null) continue;
            child.refreshProperty("ChnlOrder", child.getOrder() + nMoveDirection);
        }
        this.setOrder(nNewOrder);
    }

    public boolean isUseDocLevel() {
        return this.getPropertyAsBoolean("UseDocLevel", false);
    }

    public boolean setUseDocLevel(boolean _bUseDocLevel) throws WCMException {
        return this.setProperty("UseDocLevel", _bUseDocLevel);
    }

    public Object getDocOrderLock() {
        return this.DOC_ORDER_LOCK;
    }

    public int hashCode() {
        int id = this.getId();
        return 31 + id ^ id >>> 32;
    }

    public String queryChnlNav() throws WCMException {
        String symbol = " > ";
        int slength = symbol.length();
        Channel channel = Channel.findById(this.getId());
        if (channel == null) {
            throw new WCMException("\u4f20\u5165\u53c2\u6570\u65e0\u6548,\u680f\u76eeID[" + this.getId() + "]");
        }
        StringBuffer resultStr = new StringBuffer("");
        ArrayList<String> chnlNameList = new ArrayList<String>();
        chnlNameList.add(channel.getDesc());
        for (BaseChannel parent = channel.getHost(); parent != null; parent = parent.getHost()) {
            chnlNameList.add(parent.getDesc());
        }
        for (int i = chnlNameList.size() - 1; i >= 0; --i) {
            resultStr.append((String)chnlNameList.get(i));
            resultStr.append(symbol);
        }
        resultStr.delete(resultStr.length() - slength, resultStr.length());
        return resultStr.toString();
    }
}

