/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.special;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.Right;
import com.trs.cms.auth.persistent.RightValue;
import com.trs.cms.auth.persistent.Role;
import com.trs.cms.auth.persistent.Roles;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.domain.template.ITemplateEmployCacheMgr;
import com.trs.components.common.publish.domain.template.TemplateExporter;
import com.trs.components.common.publish.domain.template.TemplateImporter;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.common.publish.persistent.template.TemplateEmploy;
import com.trs.components.common.publish.persistent.template.Templates;
import com.trs.components.common.publish.widget.IWidgetServer;
import com.trs.components.common.publish.widget.Master;
import com.trs.components.common.publish.widget.PageStyle;
import com.trs.components.special.ISpecialMgr;
import com.trs.components.special.Special;
import com.trs.components.special.SpecialServiceProvider;
import com.trs.components.special.Specials;
import com.trs.components.wcm.content.domain.ChannelExporter;
import com.trs.components.wcm.content.domain.ChannelImporter;
import com.trs.components.wcm.content.domain.ChannelMgr;
import com.trs.components.wcm.content.domain.DocumentImporter;
import com.trs.components.wcm.content.domain.DocumentMgr;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.DocumentFieldConfig;
import com.trs.components.wcm.content.persistent.DocumentXmlConverter;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.content.persistent.WebSites;
import com.trs.components.wcm.publish.WCMFolderPublishConfig;
import com.trs.infra.common.WCMException;
import com.trs.infra.config.XMLConfigServer;
import com.trs.infra.persistent.IdFilterSqlUtil;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.Reports;
import com.trs.wcag2.HTMLUtil;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class SpecialMgr
implements ISpecialMgr {
    public static final String SPEICAL_SITENAME = "\u4e13\u9898\u5e93";
    public static final String SPEICAL_ROLENAME = "\u4e13\u9898\u7ef4\u62a4\u4eba\u5458";
    public static final String SPEICAL_SITEDATAPATH = "special";
    private static Logger logger = Logger.getLogger(SpecialServiceProvider.class);
    private static final RightValue COMMON_RIGHT_VALUE = new RightValue();

    @Override
    public void delete(User _currUser, Special _special) throws WCMException {
        this.delete(_currUser, _special, false);
    }

    @Override
    public Special save(User _curruser, Special _special, String _sSpecialSiteHttp) throws Throwable {
        return this.save(_curruser, _special, _sSpecialSiteHttp, true);
    }

    private Special save(User _curruser, Special _special, String _sSpecialSiteHttp, boolean _bCreateTemp) throws Throwable {
        if (_special == null) {
            throw new WCMException(20, "\u65e0\u6548\u7684Special\u5bf9\u8c61\uff0c\u65e0\u6cd5\u4fdd\u5b58.");
        }
        User loginUser = ContextHelper.getLoginUser();
        if (_special.isAddMode()) {
            this.setHost(_curruser, _special, _sSpecialSiteHttp, _bCreateTemp);
            String sPicFileName = _special.getViewThumb();
            if (CMyString.isEmpty(sPicFileName)) {
                _special.setViewThumb("");
            } else {
                _special.setViewThumb(this.copyFileIfNeed(sPicFileName, false));
            }
        } else if (_special.isChangeProperty("VIEWTHUMB")) {
            String sNewPic = (String)_special.getNewProperty("VIEWTHUMB");
            if (CMyString.isEmpty(sNewPic)) {
                _special.setViewThumb("");
            } else {
                _special.setViewThumb(this.copyFileIfNeed(sNewPic, false));
            }
        }
        _special.save(loginUser);
        return _special;
    }

    private String copyFileIfNeed(String _sFile, boolean _isPath) throws WCMException {
        FilesMan filesMan = FilesMan.getFilesMan();
        if (!_isPath) {
            String sFileFlag = filesMan.getFileFlag(_sFile);
            String sNewFileName = _sFile;
            if (sFileFlag != "W0") {
                sNewFileName = filesMan.copyWCMFile(_sFile, "W0");
            }
            return sNewFileName;
        }
        return CMyFile.extractFileName(filesMan.copyFile(_sFile, "W0", true));
    }

    private void setHost(User _curruser, Special _special, String _sSpecialSiteHttp, boolean _bCreateTemp) throws Throwable {
        String sChannelName = _special.getSpecialName();
        String sMasterId = _special.getMasterIds();
        String[] sMasterIds = sMasterId.split(",");
        int nIndexMasterId = Integer.parseInt(sMasterIds[0]);
        int nOutlineMasterId = Integer.parseInt(sMasterIds[1]);
        int nDetailMasterId = Integer.parseInt(sMasterIds[2]);
        Master oIndexMaster = Master.findById(nIndexMasterId);
        Master oOutlineMaster = null;
        Master oDetailMaster = null;
        if (oIndexMaster == null) {
            throw new WCMException("\u9996\u9875\u57fa\u51c6\u6bcd\u677f\u4e0d\u5b58\u5728\uff01[ObjectId=" + sMasterIds[0] + "]");
        }
        if (nOutlineMasterId != 0) {
            oOutlineMaster = Master.findById(nOutlineMasterId);
        }
        if (nDetailMasterId != 0) {
            oDetailMaster = Master.findById(nDetailMasterId);
        }
        User loginUser = ContextHelper.getLoginUser();
        WCMFilter oFilter = new WCMFilter("WCMWEBSITE", "SiteName=?", "");
        oFilter.addSearchValues(0, SPEICAL_SITENAME);
        WebSites websites = WebSites.openWCMObjs(loginUser, oFilter);
        WebSite currWebSite = null;
        currWebSite = websites == null || websites.size() <= 0 ? this.createSite(_curruser, _special, _sSpecialSiteHttp) : (WebSite)websites.getAt(0);
        int nSiteId = currWebSite.getId();
        Channel newChannel = Channel.createNewInstance();
        newChannel.setName(this.getNewChnlName(sChannelName, currWebSite));
        newChannel.setDesc(sChannelName);
        newChannel.setSite(nSiteId);
        newChannel.setParent(0);
        newChannel.setCanPub(true);
        newChannel.save();
        _special.setHostId(newChannel.getId());
        _special.setHostType(101);
        if (_bCreateTemp) {
            this.setNewTemplate(newChannel, oIndexMaster, oOutlineMaster, oDetailMaster, loginUser);
        }
        this.setSpecialRight(newChannel);
    }

    private void setNewTemplate(Channel _oSrcChannel, Master _oIndexMaster, Master _oOutlineMaster, Master _oDetailMaster, User _curruser) throws WCMException {
        IPublishElement publishElement = PublishElementFactory.lookupElement(101, _oSrcChannel.getId());
        WCMFolderPublishConfig currPublishConfig = new WCMFolderPublishConfig((IPublishFolder)publishElement);
        currPublishConfig.setFolderType(101, _oSrcChannel.getId());
        currPublishConfig.setDataPath(_oSrcChannel.getId() + "");
        currPublishConfig.canEdit(_curruser);
        IWidgetServer oWidgetServer = (IWidgetServer)DreamFactory.createObjectById("IWidgetServer");
        try {
            Template outlineTemplate;
            int nDetailTemplateId;
            Template indexTemplate = null;
            Template detailTemplate = null;
            indexTemplate = oWidgetServer.createTemplateFromMaster((IPublishFolder)publishElement, _oIndexMaster, 1);
            if (indexTemplate != null) {
                indexTemplate.save(_curruser);
                currPublishConfig.setOutlineTemplateId(indexTemplate.getId() + "");
            }
            if (_oDetailMaster != null && (detailTemplate = oWidgetServer.createTemplateFromMaster((IPublishFolder)publishElement, _oDetailMaster, 3)) != null) {
                detailTemplate.save(_curruser);
                currPublishConfig.setDetailTemplateId(detailTemplate.getId());
            }
            if (detailTemplate == null && (nDetailTemplateId = this.findSiteDetailTemplate(_oSrcChannel)) != 0) {
                currPublishConfig.setDetailTemplateId(nDetailTemplateId);
            }
            if (_oOutlineMaster != null && _oSrcChannel.getParentId() == 0 && (outlineTemplate = oWidgetServer.createTemplateFromMaster((IPublishFolder)publishElement, _oOutlineMaster, 2)) != null) {
                outlineTemplate.save(_curruser);
            }
            currPublishConfig.save(_curruser);
        }
        catch (Exception e) {
            throw new WCMException("\u8bbe\u7f6e\u4e13\u9898\u680f\u76ee\u6a21\u677f\u65f6\u4ea7\u751f\u9519\u8bef\uff01" + e.getMessage());
        }
    }

    private int findSiteDetailTemplate(Channel _oChannel) throws WCMException {
        if (_oChannel == null) {
            return 0;
        }
        IPublishElement publishElement = PublishElementFactory.lookupElement(103, _oChannel.getSiteId());
        WCMFolderPublishConfig currPublishConfig = new WCMFolderPublishConfig((IPublishFolder)publishElement);
        int nDetailTemplateId = currPublishConfig.getDetailTemplateId();
        return nDetailTemplateId;
    }

    private WebSite createSite(User _curruser, Special _special, String _sSpecialSiteHttp) throws WCMException {
        User loginUser = ContextHelper.getLoginUser();
        WebSite newSite = WebSite.createNewInstance();
        newSite.setName(SPEICAL_SITENAME);
        newSite.setDesc(SPEICAL_SITENAME);
        newSite.setParent(0);
        newSite.save();
        IPublishElement publishElement = PublishElementFactory.lookupElement(103, newSite.getId());
        WCMFolderPublishConfig currPublishConfig = new WCMFolderPublishConfig((IPublishFolder)publishElement);
        currPublishConfig.setFolderType(103, newSite.getId());
        currPublishConfig.setDataPath(SPEICAL_SITEDATAPATH);
        currPublishConfig.setRootDomain(_sSpecialSiteHttp);
        currPublishConfig.canEdit(loginUser);
        currPublishConfig.setDefineStatus(true);
        currPublishConfig.setStatusesCanDoPub("10,1,2");
        currPublishConfig.setPageEncoding("utf-8");
        currPublishConfig.save(loginUser);
        this.setSpecialRight(newSite);
        return newSite;
    }

    private String getNewChnlName(String _sChnlName, BaseChannel _destSiteOrChnl) throws Throwable {
        String sChnlName = _sChnlName;
        if (!this.existsChnlName(sChnlName, _destSiteOrChnl)) {
            return sChnlName;
        }
        String sNewChnlName = sChnlName = sChnlName.replaceAll("(_\\d+)+", "");
        int nPostNumber = DBManager.getDBManager().sqlExecuteIntQuery("select max(channelid) from wcmchannel", new int[0]);
        while (this.existsChnlName(sNewChnlName, _destSiteOrChnl)) {
            sNewChnlName = sChnlName + "_" + nPostNumber;
            ++nPostNumber;
        }
        return sNewChnlName;
    }

    private boolean existsChnlName(String _sChnlName, BaseChannel _destSiteOrChnl) {
        return Channel.findByName(_destSiteOrChnl.getSiteId(), _sChnlName) != null;
    }

    private void setTemplate(Channel _oSrcChannel, Master _oMaster, User _curruser, Channel _oDestChannel, HashMap map) throws WCMException {
        String sDetailId;
        String sOutLineId;
        WCMFilter filter = new WCMFilter("", "", "lastModifiedTime asc");
        filter.setWhere("FolderId = ? and FolderType = 101");
        filter.addSearchValues(0, _oDestChannel.getId());
        Templates templates = Templates.openWCMObjs(_curruser, filter);
        IPublishElement publishElement = PublishElementFactory.lookupElement(101, _oSrcChannel.getId());
        WCMFolderPublishConfig currPublishConfig = new WCMFolderPublishConfig((IPublishFolder)publishElement);
        currPublishConfig.setFolderType(101, _oSrcChannel.getId());
        currPublishConfig.setDataPath(_oSrcChannel.getId() + "");
        Template indexTemplate = this.makeTemplate(currPublishConfig, 1, _oDestChannel);
        Template detailTemplate = this.makeTemplate(currPublishConfig, 2, _oDestChannel);
        TemplateExporter exporter = new TemplateExporter();
        TemplateImporter importer = new TemplateImporter();
        IPublishFolder sourceFolder = (IPublishFolder)PublishElementFactory.lookupElement(101, _oSrcChannel.getId());
        Templates tempTemplates = null;
        int j = templates.size();
        for (int i = 0; i < j; ++i) {
            Template temlate = (Template)templates.getAt(i);
            if (temlate == null) continue;
            tempTemplates = Templates.findByIds(_curruser, temlate.getId() + "");
            try {
                String sPath = exporter.export(tempTemplates);
                importer.importFromZip(sourceFolder, sPath, 3, 3, null);
                int nId = this.getRealId(_oSrcChannel, _curruser);
                map.put(temlate.getId() + "", nId + "");
                if (indexTemplate != null && indexTemplate.getId() == temlate.getId()) {
                    indexTemplate = null;
                    currPublishConfig.setOutlineTemplateId(nId + "");
                }
                if (detailTemplate == null || detailTemplate.getId() != temlate.getId()) continue;
                detailTemplate = null;
                currPublishConfig.setDetailTemplateId(nId);
                continue;
            }
            catch (Exception e) {
                throw new WCMException("\u8bbe\u7f6e\u4e13\u9898\u680f\u76ee\u6a21\u677f\u65f6\u4ea7\u751f\u9519\u8bef\uff01", e);
            }
        }
        if (indexTemplate != null && (sOutLineId = (String)map.get(indexTemplate.getId() + "")) != null && !sOutLineId.trim().equals("")) {
            currPublishConfig.setOutlineTemplateId(sOutLineId);
        }
        if (detailTemplate != null && (sDetailId = (String)map.get(detailTemplate.getId() + "")) != null && !sDetailId.trim().equals("")) {
            currPublishConfig.setDetailTemplateId(Integer.parseInt(sDetailId));
        }
        currPublishConfig.canEdit(_curruser);
        currPublishConfig.save(_curruser);
    }

    private int getRealId(Channel srcChannel, User _curruser) throws WCMException {
        WCMFilter filter = new WCMFilter("", "", "lastModifiedTime desc");
        filter.setWhere("FolderId = ? and FolderType = 101");
        filter.addSearchValues(0, srcChannel.getId());
        Templates templates = Templates.openWCMObjs(_curruser, filter);
        int nResult = 0;
        Template temp = null;
        try {
            int k = templates.size();
            for (int i = 0; i < k; ++i) {
                temp = (Template)templates.getAt(i);
                if (temp == null) continue;
                nResult = temp.getId();
                break;
            }
        }
        catch (Exception e) {
            throw new WCMException("\u83b7\u53d6\u680f\u76ee\u6a21\u677fID\u65f6\u4ea7\u751f\u9519\u8bef\uff01", e);
        }
        return nResult;
    }

    private Template makeTemplate(WCMFolderPublishConfig currPublishConfig, int templateType, Channel destChannel) throws WCMException {
        User loginUser = ContextHelper.getLoginUser();
        IPublishFolder destFolder = (IPublishFolder)PublishElementFactory.lookupElement(101, destChannel.getId());
        IPublishElement sourceFolder = PublishElementFactory.lookupElement(101, currPublishConfig.getFolderId());
        Template template = null;
        if (templateType == 2) {
            template = destFolder.getDetailTemplate();
        } else {
            Templates temps = destFolder.getOutlineTemplates();
            if (temps == null || temps.size() <= 0) {
                return null;
            }
            template = (Template)temps.getAt(0);
        }
        if (template == null) {
            return null;
        }
        if (template.getFolderId() != destFolder.getId() && template.getFolderType() == 103) {
            TemplateEmploy employ = new TemplateEmploy();
            employ.setEmployer(sourceFolder);
            employ.setDefault(true);
            employ.setTemplate(template);
            employ.save(loginUser);
            return null;
        }
        return template;
    }

    private void setSpecialRight(CMSObj _obj) throws WCMException {
        User loginUer = ContextHelper.getLoginUser();
        Right right = null;
        try {
            WCMFilter filter = new WCMFilter();
            filter.setWhere("RoleName = ?");
            filter.addSearchValues(0, SPEICAL_ROLENAME);
            Roles roles = Roles.openWCMObjs(loginUer, filter);
            if (roles.size() <= 0) {
                return;
            }
            Role role = (Role)roles.getAt(0);
            right = Right.findBy(_obj.getWCMType(), _obj.getId(), role.getWCMType(), role.getId());
            if (right == null) {
                right = Right.createNewInstance();
                right.setObject(_obj);
                right.setOperator(role);
            }
            right.setValue(RightValue.getAdministratorRightValue());
            right.save(loginUer);
            this.setCommonRight(_obj);
        }
        catch (Exception ex) {
            logger.error((Object)("\u8bbe\u7f6e\u4e13\u9898\u680f\u76ee\u4e0e\u7279\u5b9a\u89d2\u8272\u5173\u8054\u6743\u9650\u65f6\u51fa\u9519:" + ex.getMessage()));
        }
    }

    private void setCommonRight(CMSObj _obj) throws WCMException {
        Right right = null;
        Role tempRole = Role.findById(2);
        right = Right.findBy(_obj.getWCMType(), _obj.getId(), 203, 2);
        if (right == null) {
            right = Right.createNewInstance();
            right.setObject(_obj);
            right.setOperator(tempRole);
        }
        right.setValue(COMMON_RIGHT_VALUE.getValue());
        right.save(ContextHelper.getLoginUser());
    }

    @Override
    public Specials query(User _curruser, WCMFilter _filter) throws WCMException {
        return Specials.openWCMObjs(_curruser, _filter);
    }

    @Override
    public boolean existsSimilarName(int _nObjectId, String _specialName) throws Exception {
        if (CMyString.isEmpty(_specialName)) {
            return false;
        }
        User loginUser = ContextHelper.getLoginUser();
        String sWhere = "SPECIALNAME = ? and SPECIALID != ?";
        WCMFilter oFilter = new WCMFilter("XWCMSPECIAL", sWhere, "");
        oFilter.addSearchValues(0, _specialName);
        oFilter.addSearchValues(1, _nObjectId);
        Specials resultSpecials = Specials.openWCMObjs(loginUser, oFilter);
        return resultSpecials.size() > 0;
    }

    private Template getSpecialTemplate(Special special) throws WCMException {
        int nHostId = special.getHostId();
        Channel channel = Channel.findById(nHostId);
        if (channel == null) {
            throw new WCMException("\u4e13\u9898\u5173\u8054\u7684\u680f\u76ee\u4e0d\u5b58\u5728\uff01[ObjectId=" + nHostId + "]");
        }
        IPublishFolder publishFolder = (IPublishFolder)PublishElementFactory.makeElementFrom(channel);
        ITemplateEmployCacheMgr templateEmploy = (ITemplateEmployCacheMgr)DreamFactory.createObjectById("ITemplateEmployCacheMgr");
        Template template = templateEmploy.getDefaultOutlineTemplate(publishFolder);
        return template;
    }

    @Override
    public boolean setStyle(Special special, PageStyle pageStyle) throws Exception {
        User loginUser = ContextHelper.getLoginUser();
        if (this.getStyle(special) != null && this.getStyle(special).getId() == pageStyle.getId()) {
            return false;
        }
        special.setStyleName(pageStyle.getStyleName());
        special.save(loginUser);
        IWidgetServer oWidgetServer = (IWidgetServer)DreamFactory.createObjectById("IWidgetServer");
        Template template = this.getSpecialTemplate(special);
        try {
            oWidgetServer.insertStyleTag(special, template);
        }
        catch (WCMException e) {
            throw new WCMException("\u63d2\u5165\u9875\u9762\u7f6e\u6807\u5931\u8d25!", e);
        }
        return true;
    }

    @Override
    public PageStyle getStyle(Special special) throws Exception {
        Template template = this.getSpecialTemplate(special);
        String content = template.getText();
        String sStyleName = "";
        List tags = HTMLUtil.findTagOuterHTML(content, "TRS_PAGESTYLE");
        PageStyle pageStyle = null;
        if (tags.size() > 0) {
            int[] pos = (int[])tags.get(0);
            String temp = HTMLUtil.getEleAttrs(content, pos, "TRS_PAGESTYLE");
            int nIdIndex = temp.toUpperCase().indexOf("ID");
            int nNameIndex = temp.toUpperCase().indexOf("NAME");
            if (nIdIndex >= 0) {
                temp = temp.substring(nIdIndex);
                if (nNameIndex >= 1) {
                    temp = temp.substring(0, nNameIndex - 2);
                }
                int nStyleId = Integer.valueOf(temp.substring(4, temp.length() - 1));
                pageStyle = PageStyle.findById(nStyleId);
            } else {
                if (nNameIndex >= 0) {
                    temp = temp.substring(nNameIndex);
                }
                sStyleName = temp.substring(6, temp.length() - 1);
                pageStyle = PageStyle.findByName(sStyleName);
            }
        } else {
            throw new WCMException("\u672a\u8bbe\u7f6e\u9875\u9762\u98ce\u683c\u7f6e\u6807\uff01");
        }
        return pageStyle;
    }

    @Override
    public Special findSpecialByChnlId(User _oUser, int _nChnlId) throws WCMException {
        WCMFilter filter = new WCMFilter("", "HostId=?", "", "");
        filter.addSearchValues(_nChnlId);
        Specials _oSpecials = Specials.openWCMObjs(_oUser, filter);
        if (!_oSpecials.isEmpty()) {
            return (Special)_oSpecials.getAt(0);
        }
        return null;
    }

    @Override
    public Specials findSpecialsByChnlIds(User _oUser, String _sChnlIds) throws WCMException {
        String sWhere = IdFilterSqlUtil.makeAsString("HOSTID", _sChnlIds);
        WCMFilter filter = new WCMFilter("", sWhere, "", "");
        Specials _oSpecials = Specials.openWCMObjs(_oUser, filter);
        if (!_oSpecials.isEmpty()) {
            return _oSpecials;
        }
        return null;
    }

    @Override
    public boolean createFrom(Special special) throws Throwable {
        User currUser = ContextHelper.getLoginUser();
        Special newSpecial = new Special();
        String[] pLogicFields = new String[]{"SpecialDesc", "ViewThumb", "MasterId", "MasterIds", "StyleName"};
        int j = pLogicFields.length;
        for (int i = 0; i < j; ++i) {
            newSpecial.setProperty(pLogicFields[i], special.getProperty(pLogicFields[i]));
        }
        int nPostNumber = DBManager.getDBManager().sqlExecuteIntQuery("select max(specialId) from xwcmspecial", new int[0]);
        String sSpecialName = special.getSpecialName() + "_" + nPostNumber;
        while (this.existsSimilarName(0, sSpecialName)) {
            sSpecialName = sSpecialName + "_" + nPostNumber;
            ++nPostNumber;
        }
        newSpecial.setSpecialName(sSpecialName);
        this.save(currUser, newSpecial, null, false);
        Channel srcChannel = Channel.findById(newSpecial.getHostId());
        if (srcChannel == null) {
            throw new WCMException("\u6307\u5b9a\u7684\u680f\u76ee\u4e0d\u5b58\u5728\uff01[ObjectId=" + newSpecial.getHostId() + "]");
        }
        Channel destChannel = Channel.findById(special.getHostId());
        if (destChannel == null) {
            throw new WCMException("\u6307\u5b9a\u7684\u680f\u76ee\u4e0d\u5b58\u5728\uff01[ObjectId=" + special.getHostId() + "]");
        }
        HashMap map = new HashMap();
        this.setTemplate(srcChannel, null, currUser, destChannel, map);
        this.likeCopyChannel(srcChannel, destChannel, currUser, map);
        return true;
    }

    private void likeCopyChannel(Channel srcChannel, Channel destChannel, User currUser, HashMap map) throws WCMException {
        DocumentImporter docImporter = (DocumentImporter)DreamFactory.createObjectById("DocumentImporter");
        WCMFilter oSelectFieldsFilter = new WCMFilter("", "", "", this.getExportFields());
        String sTempXmlFile = this.likeCopyDocuments(srcChannel, destChannel, oSelectFieldsFilter);
        docImporter.importFromFile(sTempXmlFile, srcChannel, null, false, true);
        WCMFilter filter = new WCMFilter();
        filter.setWhere("Parentid = ? and Status>=0");
        filter.addSearchValues(0, destChannel.getId());
        Channels channels = Channels.openWCMObjs(currUser, filter);
        if (channels.size() <= 0) {
            return;
        }
        ChannelExporter exporter = (ChannelExporter)DreamFactory.createObjectById("ChannelExporter");
        ChannelImporter importer = (ChannelImporter)DreamFactory.createObjectById("ChannelImporter");
        int j = channels.size();
        for (int i = 0; i < j; ++i) {
            Channel channel = (Channel)channels.getAt(i);
            if (channel == null) continue;
            try {
                String sXmlFile = exporter.export(channel, false, true);
                Reports reports = importer.importFromFile(sXmlFile, null, srcChannel);
                int nSrcId = reports.getResultIds()[0];
                Channel temp = Channel.findById(nSrcId);
                if (temp == null) {
                    throw new WCMException("\u6307\u5b9a\u7684\u680f\u76ee\u4e0d\u5b58\u5728\uff01[ObjectId=" + nSrcId + "]");
                }
                this.setTemplate(temp, null, currUser, channel, map);
                int nChildNum = DBManager.getDBManager().sqlExecuteIntQuery("select count(*) from wcmchannel where Parentid=? and Status>=0", new int[]{channel.getId()});
                if (nChildNum > 0) {
                    this.likeCopyChannel(temp, channel, currUser, map);
                    continue;
                }
                sTempXmlFile = this.likeCopyDocuments(temp, channel, oSelectFieldsFilter);
                docImporter.importFromFile(sTempXmlFile, temp, null, false, true);
                continue;
            }
            catch (Exception e) {
                throw new WCMException(1100, "\u4ece\u680f\u76ee[" + channel.getDesc() + "]\u7c7b\u4f3c\u521b\u5efa\u5230[" + srcChannel.getDesc() + "\u5931\u8d25!", e);
            }
        }
    }

    private String likeCopyDocuments(Channel srcChannel, Channel destChannel, WCMFilter selectFieldsFilter) throws WCMException {
        DocumentMgr m_oDocumentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
        Documents documents = m_oDocumentMgr.getDocuments(destChannel, selectFieldsFilter);
        FilesMan filesMan = FilesMan.getFilesMan();
        String sTempXmlFile = filesMan.getNextFileName("ST", "xml", null, true);
        DocumentXmlConverter m_docconverter = new DocumentXmlConverter();
        m_docconverter.setWithAppendix(true);
        m_docconverter.toXMLFile(documents, sTempXmlFile, null, this.getExportFields());
        return sTempXmlFile;
    }

    private String getExportFields() {
        List list = XMLConfigServer.getInstance().getConfigObjects(DocumentFieldConfig.class);
        StringBuffer sbSelected = new StringBuffer();
        DocumentFieldConfig currDocumentFieldConfig2 = null;
        for (DocumentFieldConfig currDocumentFieldConfig2 : list) {
            if (currDocumentFieldConfig2 == null || currDocumentFieldConfig2.getType() == 3) continue;
            if (currDocumentFieldConfig2.getType() == 1 || currDocumentFieldConfig2.getType() == 4) {
                if (sbSelected.length() == 0) {
                    sbSelected.append(currDocumentFieldConfig2.getFields());
                    continue;
                }
                sbSelected.append(",").append(currDocumentFieldConfig2.getFields());
                continue;
            }
            if (currDocumentFieldConfig2.getType() != 3 || !currDocumentFieldConfig2.getFields().toUpperCase().equals("DOCORDER")) continue;
            if (sbSelected.length() == 0) {
                sbSelected.append(currDocumentFieldConfig2.getFields());
                continue;
            }
            sbSelected.append(",").append(currDocumentFieldConfig2.getFields());
        }
        return sbSelected.toString();
    }

    @Override
    public void delete(User _currUser, Special _special, boolean _bDrop) throws WCMException {
        if (_special == null) {
            throw new WCMException(20, "\u65e0\u6548\u7684Special\u5bf9\u8c61\uff0c\u65e0\u6cd5\u5220\u9664.");
        }
        if (!_special.canEdit(_currUser)) {
            throw new WCMException(1013, "\u5bf9\u8c61\u5df2\u88ab[" + _special.getLockerUser() + "\u9501\u5b9a,\u7528\u6237[" + _currUser.getName() + "]\u65e0\u6cd5\u5bf9\u9501\u5b9a\u5bf9\u8c61\u8fdb\u884c\u64cd\u4f5c!");
        }
        Channel currChannel = Channel.findById(_special.getHostId());
        if (currChannel == null) {
            throw new WCMException("\u672a\u627e\u5230Id\u4e3a" + _special.getHostId() + "\u7684\u680f\u76ee!");
        }
        ChannelMgr m_oChannelMgr = (ChannelMgr)DreamFactory.createObjectById("ChannelMgr");
        m_oChannelMgr.delete(currChannel, _bDrop);
        if (_bDrop) {
            _special.delete(_currUser);
        } else {
            _special.setStatus(-1);
            _special.save(_currUser);
        }
    }

    @Override
    public void restore(User _currUser, Special _special) throws WCMException {
        if (_special == null) {
            throw new WCMException(20, "\u65e0\u6548\u7684Special\u5bf9\u8c61\uff0c\u65e0\u6cd5\u5220\u9664.");
        }
        if (!_special.canEdit(_currUser)) {
            throw new WCMException(1013, "\u5bf9\u8c61\u5df2\u88ab[" + _special.getLockerUser() + "\u9501\u5b9a,\u7528\u6237[" + _currUser.getName() + "]\u65e0\u6cd5\u5bf9\u9501\u5b9a\u5bf9\u8c61\u8fdb\u884c\u64cd\u4f5c!");
        }
        Channel currChannel = Channel.findById(_special.getHostId());
        if (currChannel == null) {
            throw new WCMException("\u672a\u627e\u5230\u4e13\u9898\u5bf9\u5e94\u7684Id\u4e3a" + _special.getHostId() + "\u7684\u680f\u76ee![" + _special + "]\u4e0d\u80fd\u6062\u590d");
        }
        ChannelMgr m_oChannelMgr = (ChannelMgr)DreamFactory.createObjectById("ChannelMgr");
        m_oChannelMgr.restore(currChannel);
        _special.setStatus(0);
        _special.save(_currUser);
    }

    static {
        COMMON_RIGHT_VALUE.setBit(15, true);
    }
}

