/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.definition.excel;

import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.User;
import com.trs.components.metadata.definition.IMetaDataDefMgr;
import com.trs.components.metadata.definition.MetaDBTable;
import com.trs.components.metadata.definition.MetaView;
import com.trs.components.metadata.definition.MetaViewField;
import com.trs.components.metadata.definition.excel.ExcelForStructImporter;
import com.trs.components.metadata.definition.excel.FieldInfo;
import com.trs.components.metadata.definition.excel.FieldInfos;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyFile;
import org.apache.log4j.Logger;

public class DefaultTabelsForHaier {
    private static Logger logger = Logger.getLogger(ExcelForStructImporter.class);
    private static StringBuffer sbDropSQL = new StringBuffer();
    public static FieldInfos DEFAULT_FIELDS_GS = new FieldInfos();
    public static FieldInfos DEFAULT_FIELDS_SM;
    public static FieldInfos DEFAULT_FIELDS_FAQ;
    public static FieldInfos DEFAULT_FIELDS_DRIVE;
    public static FieldInfos[] pDefaultFields;
    public static String[] pTableAnotherNames;
    public static String[] pTableNames;

    private static MetaViewField createDBFieldFromDataType(FieldInfo dataType) throws WCMException {
        MetaViewField dbField = MetaViewField.createNewInstance();
        if (dataType.getEnumValues() != null) {
            dbField.setEnmValue(dataType.getEnumValues());
        }
        dbField.setNotNull(dataType.isNotNull());
        dbField.setHidden(dataType.isHidden());
        dbField.setInOutline(dataType.isInOutline());
        dbField.setTitleField(dataType.isTitle());
        dbField.setSearchField(dataType.isSearchField());
        dbField.setAnotherName(dataType.getDataTypeDesc());
        dbField.setName(dataType.getKey());
        dbField.setType(dataType.getDataType());
        dbField.setDBType(dataType.getSqlDataType());
        return dbField;
    }

    private static MetaDBTable createTable(String _sTableAnotherName, String _sTableName, FieldInfos _fields) throws WCMException {
        sbDropSQL.append("drop table WCMMetaTable" + _sTableName + ";");
        sbDropSQL.append("\n");
        IMetaDataDefMgr oMetaDataDefMgr = (IMetaDataDefMgr)DreamFactory.createObjectById("IMetaDataDefMgr");
        User currUser = User.findByName("admin");
        MetaDBTable currTable = MetaDBTable.createNewInstance();
        currTable.setAnotherName(_sTableAnotherName);
        currTable.setName(_sTableName);
        oMetaDataDefMgr.save(currUser, currTable);
        MetaView view = DefaultTabelsForHaier.createViewFrom(currTable);
        oMetaDataDefMgr.save(currUser, view);
        int nSize = _fields.getDataTypesCount();
        for (int i = 0; i < nSize; ++i) {
            MetaViewField dbField = DefaultTabelsForHaier.createDBFieldFromDataType(_fields.getDataTypeAt(i));
            try {
                oMetaDataDefMgr.save(currUser, view, dbField);
                continue;
            }
            catch (Exception e) {
                oMetaDataDefMgr.delete(currUser, currTable);
                logger.error((Object)(I18NMessage.get(DefaultTabelsForHaier.class, "DefaultTabelsForHaier.label19", "\u5904\u7406\u5b57\u6bb5\u51fa\u73b0\u5f02\u5e38\uff01[") + _sTableAnotherName + "." + _sTableName + "." + dbField.getAnotherName() + "." + dbField.getName() + "]"), (Throwable)e);
                break;
            }
        }
        return currTable;
    }

    public static void createDefaultTables() throws Exception {
        for (int i = 0; i < pTableAnotherNames.length; ++i) {
            DefaultTabelsForHaier.createTable(pTableAnotherNames[i], pTableNames[i], pDefaultFields[i]);
        }
        CMyFile.writeFile("c:\\drop_default_tables.sql", sbDropSQL.toString());
    }

    private static MetaView createViewFrom(MetaDBTable currTable) throws WCMException {
        MetaView view = MetaView.createNewInstance();
        view.setMainTable(currTable);
        view.setDesc(currTable.getAnotherName());
        view.setName(currTable.getName());
        return view;
    }

    static {
        FieldInfo fieldInfo = DEFAULT_FIELDS_GS.register(3, I18NMessage.get(DefaultTabelsForHaier.class, "DefaultTabelsForHaier.label1", "\u6807\u9898"), "GName", 12, 60);
        fieldInfo.setNotNull(true);
        fieldInfo.setInOutline(true);
        fieldInfo.setTitle(true);
        fieldInfo.setSearchField(true);
        fieldInfo = DEFAULT_FIELDS_GS.register(4, I18NMessage.get(DefaultTabelsForHaier.class, "DefaultTabelsForHaier.label2", "\u63cf\u8ff0"), "GDesc", 12, 140);
        fieldInfo.setSearchField(true);
        DEFAULT_FIELDS_GS.register(8, I18NMessage.get(DefaultTabelsForHaier.class, "DefaultTabelsForHaier.label3", "\u56fe\u6807"), "Icon", 12, 20);
        fieldInfo = DEFAULT_FIELDS_GS.register(1, I18NMessage.get(DefaultTabelsForHaier.class, "DefaultTabelsForHaier.label4", "\u5916\u90e8\u6570\u636eID"), "HOutputId", 4, 0);
        fieldInfo.setInOutline(true);
        DEFAULT_FIELDS_SM = new FieldInfos();
        fieldInfo = DEFAULT_FIELDS_SM.register(3, I18NMessage.get(DefaultTabelsForHaier.class, "DefaultTabelsForHaier.label5", "\u540d\u79f0"), "GName", 12, 80);
        fieldInfo.setNotNull(true);
        fieldInfo.setInOutline(true);
        fieldInfo.setTitle(true);
        fieldInfo.setSearchField(true);
        fieldInfo = DEFAULT_FIELDS_SM.register(3, I18NMessage.get(DefaultTabelsForHaier.class, "DefaultTabelsForHaier.label6", "\u6587\u4ef6\u540d"), "GFileName", 12, 40);
        fieldInfo.setNotNull(true);
        fieldInfo.setInOutline(true);
        fieldInfo.setSearchField(true);
        fieldInfo = DEFAULT_FIELDS_SM.register(11, I18NMessage.get(DefaultTabelsForHaier.class, "DefaultTabelsForHaier.label7", "\u53d1\u5e03\u65e5\u671f"), "GPubDate", 93, 40);
        fieldInfo.setNotNull(true);
        fieldInfo.setInOutline(true);
        fieldInfo = DEFAULT_FIELDS_SM.register(8, I18NMessage.get(DefaultTabelsForHaier.class, "DefaultTabelsForHaier.label8", "\u8bf4\u660e\u4e66\u6587\u4ef6"), "GFile", 12, 20);
        fieldInfo.setNotNull(true);
        fieldInfo.setInOutline(true);
        DEFAULT_FIELDS_SM.register(1, I18NMessage.get(DefaultTabelsForHaier.class, "DefaultTabelsForHaier.label4", "\u5916\u90e8\u6570\u636eID"), "HOutputId", 4, 0);
        DEFAULT_FIELDS_FAQ = new FieldInfos();
        fieldInfo = DEFAULT_FIELDS_FAQ.register(3, I18NMessage.get(DefaultTabelsForHaier.class, "DefaultTabelsForHaier.label9", "\u95ee\u9898"), "FName", 12, 80);
        fieldInfo.setNotNull(true);
        fieldInfo.setInOutline(true);
        fieldInfo.setTitle(true);
        fieldInfo.setSearchField(true);
        fieldInfo = DEFAULT_FIELDS_FAQ.register(4, I18NMessage.get(DefaultTabelsForHaier.class, "DefaultTabelsForHaier.label10", "\u7b54\u6848"), "FFileName", 12, 2000);
        fieldInfo.setNotNull(true);
        fieldInfo.setInOutline(true);
        fieldInfo.setSearchField(true);
        DEFAULT_FIELDS_FAQ.register(1, I18NMessage.get(DefaultTabelsForHaier.class, "DefaultTabelsForHaier.label4", "\u5916\u90e8\u6570\u636eID"), "HOutputId", 4, 0);
        DEFAULT_FIELDS_DRIVE = new FieldInfos();
        fieldInfo = DEFAULT_FIELDS_DRIVE.register(3, I18NMessage.get(DefaultTabelsForHaier.class, "DefaultTabelsForHaier.label11", "\u9a71\u52a8\u540d\u79f0"), "DName", 12, 80);
        fieldInfo.setNotNull(true);
        fieldInfo.setInOutline(true);
        fieldInfo.setTitle(true);
        fieldInfo.setSearchField(true);
        fieldInfo = DEFAULT_FIELDS_DRIVE.register(6, I18NMessage.get(DefaultTabelsForHaier.class, "DefaultTabelsForHaier.label12", "\u64cd\u4f5c\u7cfb\u7edf"), "DOS", 4, 0);
        fieldInfo.setEnumValues(I18NMessage.get(DefaultTabelsForHaier.class, "DefaultTabelsForHaier.label13", "Windows XP`1~Windows Visto`2~Windows 7`3~\u5176\u5b83`4"));
        fieldInfo.setNotNull(true);
        fieldInfo.setInOutline(true);
        fieldInfo = DEFAULT_FIELDS_DRIVE.register(3, I18NMessage.get(DefaultTabelsForHaier.class, "DefaultTabelsForHaier.label14", "\u4e0b\u8f7d\u8def\u5f84"), "DFilePath", 12, 300);
        fieldInfo.setNotNull(true);
        fieldInfo.setInOutline(true);
        DEFAULT_FIELDS_DRIVE.register(1, I18NMessage.get(DefaultTabelsForHaier.class, "DefaultTabelsForHaier.label4", "\u5916\u90e8\u6570\u636eID"), "HOutputId", 4, 0);
        pDefaultFields = new FieldInfos[]{DEFAULT_FIELDS_GS, DEFAULT_FIELDS_SM, DEFAULT_FIELDS_FAQ, DEFAULT_FIELDS_DRIVE};
        pTableAnotherNames = new String[]{I18NMessage.get(DefaultTabelsForHaier.class, "DefaultTabelsForHaier.label15", "\u4ea7\u54c1\u6982\u8ff0"), I18NMessage.get(DefaultTabelsForHaier.class, "DefaultTabelsForHaier.label16", "\u8bf4\u660e\u4e66"), I18NMessage.get(DefaultTabelsForHaier.class, "DefaultTabelsForHaier.label17", "\u5e38\u89c1\u95ee\u9898"), I18NMessage.get(DefaultTabelsForHaier.class, "DefaultTabelsForHaier.label18", "\u9a71\u52a8\u4e0b\u8f7d")};
        pTableNames = new String[]{"HCN_CHAN_PING_GAI_SU", "HCN_SHUO_MIN_SHU", "HCN_FAQ", "HCN_DRIVER"};
    }
}

