/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.infoview.process;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.cms.process.definition.FlowAction;
import com.trs.cms.process.engine.ExecuteContext;
import com.trs.cms.process.engine.IActionHandler;
import com.trs.cms.process.engine.handlers.ActionParametersAnalyser;
import com.trs.components.infoview.InfoViewDataHelper;
import com.trs.components.infoview.db.InfoviewXMLDataUpdator;
import com.trs.components.infoview.process.WorkDaysCounter;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class AutoInsertRepeatTableForToUsers
implements IActionHandler {
    private static Logger logger = Logger.getLogger(AutoInsertRepeatTableForToUsers.class);

    @Override
    public boolean execute(ExecuteContext _context, FlowAction _action) throws WCMException {
        Users users = _context.getCurrFlowDoc().getToUsers(null);
        if (users == null || users.size() == 0) {
            return false;
        }
        ActionParametersAnalyser parameters = new ActionParametersAnalyser(_action.getParams());
        String sVacationDays = parameters.getParameterValue("VacationDays");
        List vacationDaysList = this.makeVacationDaysList(sVacationDays);
        String sWorkDays = parameters.getParameterValue("WorkDays");
        int nWorkDays = 10;
        if (!CMyString.isEmpty(sWorkDays)) {
            nWorkDays = Integer.parseInt(sWorkDays);
        }
        String sUserFieldName = parameters.getParameterValue("ReplyDep");
        String sDateFieldName = parameters.getParameterValue("Deadline");
        String sFieldName = parameters.getParameterValue("RepeatField");
        Document document = (Document)_context.getFlowContent().getSubinstance();
        String currDate = CMyDateTime.now().toString("yyyy-MM-dd");
        String sDateTime = this.makeDeadLine(vacationDaysList, currDate, nWorkDays);
        InfoviewXMLDataUpdator oUpdator = new InfoviewXMLDataUpdator(document.getContent());
        List userFieldNames = oUpdator.getFieldValue(sUserFieldName);
        this.synRepeatFieldForUsers(userFieldNames, oUpdator, users, sFieldName, sUserFieldName, sDateFieldName, sDateTime);
        String sNewContent1 = oUpdator.update(null);
        document.setContent(sNewContent1);
        document.save(null);
        return false;
    }

    private void synRepeatFieldForUsers(List _fieldUserNames, InfoviewXMLDataUpdator _oUpdator, Users _currUsers, String _sRepeatFieldName, String sUserFieldName, String _sTimeField, String _sDeadline) throws WCMException {
        String sSelfFieldName = _sRepeatFieldName.split("_")[1];
        boolean bUpdateFirstRepeatField = false;
        if (_fieldUserNames.size() == 1 && CMyString.isEmpty((String)_fieldUserNames.get(0))) {
            bUpdateFirstRepeatField = true;
        }
        int nGroupSize = _oUpdator.getRepeatFieldSize(sSelfFieldName);
        for (int i = 0; i < _currUsers.size(); ++i) {
            User user = (User)_currUsers.getAt(i);
            if (user == null) continue;
            boolean bHasInRepeatField = false;
            for (int j = 0; j < _fieldUserNames.size(); ++j) {
                String sUsers = (String)_fieldUserNames.get(j);
                if (!sUsers.equals(user.getName())) continue;
                bHasInRepeatField = true;
            }
            if (bHasInRepeatField) continue;
            if (nGroupSize == 1 && i == 0 && bUpdateFirstRepeatField) {
                _oUpdator.setRepeatField(sUserFieldName, user.getName(), i + 1);
                _oUpdator.setRepeatField(_sTimeField, _sDeadline, i + 1);
                continue;
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(sUserFieldName, user.getName());
            map.put(_sTimeField, _sDeadline);
            if (nGroupSize > 0) {
                _oUpdator.addRepeatFieldLine(sSelfFieldName, map);
                continue;
            }
            _oUpdator.addRepeatFieldGroup(_sRepeatFieldName, map);
        }
    }

    private void clearRepeatFieldInfo(List _fieldUserNames, String sRemoveFieldName, InfoviewXMLDataUpdator _oUpdator, Users _currUsers) {
        for (int k = 0; k < _fieldUserNames.size(); ++k) {
            String sUserFieldName = (String)_fieldUserNames.get(k);
            if (CMyString.isEmpty(sUserFieldName) && k > 0) {
                _oUpdator.setRemoveField(sRemoveFieldName, k + 1);
                continue;
            }
            boolean bFindUser = false;
            for (int m = 0; m < _currUsers.size(); ++m) {
                String sUserName;
                User user = (User)_currUsers.getAt(m);
                if (user == null || !sUserFieldName.equals(sUserName = user.getName())) continue;
                bFindUser = true;
            }
            if (bFindUser || CMyString.isEmpty(sUserFieldName)) continue;
            _oUpdator.setRemoveField(sRemoveFieldName, k + 1);
        }
    }

    private String makeDeadLine(List oVacationList, String sBasicDate, int nWorkDays) {
        Date dDeadLine = new Date();
        try {
            WorkDaysCounter workDaysCounter = new WorkDaysCounter();
            workDaysCounter.setVacationList(oVacationList);
            dDeadLine = workDaysCounter.getWorkDayAsDate(sBasicDate, nWorkDays);
        }
        catch (ParseException e) {
            logger.error((Object)"\u8ba1\u7b97\u56de\u590d\u65f6\u95f4\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
        CMyDateTime deadLinedateTime = new CMyDateTime();
        deadLinedateTime.setDateTime(dDeadLine);
        return deadLinedateTime.toString("yyyy-MM-dd");
    }

    private String getBasicDateFieldValue(Document oDocument, String sFieldName) throws WCMException {
        String sValue = InfoViewDataHelper.getProperty(oDocument, sFieldName);
        if (CMyString.isEmpty(sValue)) {
            return CMyDateTime.now().toString("yyyy-MM-dd");
        }
        CMyDateTime dateTime = new CMyDateTime();
        try {
            dateTime.setDateTimeWithString(sValue);
        }
        catch (CMyException e) {
            throw new WCMException("\u5f53\u524d\u8868\u5355\u5b57\u6bb5\u3010" + sFieldName + "\u3011\u7684\u503c\u3010" + sValue + "\u3011\u4e3a\u975e\u6cd5\u7684\u65f6\u95f4\u683c\u5f0f", e);
        }
        return sValue;
    }

    private List makeVacationDaysList(String sVacationDays) {
        ArrayList<String> oVacationList = new ArrayList<String>();
        if (CMyString.isEmpty(sVacationDays)) {
            return oVacationList;
        }
        String[] days = sVacationDays.split(";");
        for (int i = 0; i < days.length; ++i) {
            oVacationList.add(days[i]);
        }
        return oVacationList;
    }

    public static void main(String[] args) throws WCMException {
        ContextHelper.initContext(User.findByName("admin"));
        AutoInsertRepeatTableForToUsers handler = new AutoInsertRepeatTableForToUsers();
        handler.execute(null, null);
    }
}

