/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.filter;

import com.trs.components.filter.AllQueryFilter;
import com.trs.components.filter.DayQueryFilter;
import com.trs.components.filter.IQueryFilter;
import com.trs.components.filter.IQueryFilterFactory;
import com.trs.components.filter.MonthQueryFilter;
import com.trs.components.filter.NewQueryFilter;
import com.trs.components.filter.NoQueryFilter;
import com.trs.components.filter.PublishQueryFilter;
import com.trs.components.filter.PublishedQueryFilter;
import com.trs.components.filter.SelfQueryFilter;
import com.trs.components.filter.WeekQueryFilter;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import java.util.Hashtable;
import java.util.Map;

public class QueryFilterFactory
implements IQueryFilterFactory {
    private Map mFilterMapping = new Hashtable();
    private static IQueryFilterFactory instance = null;

    private QueryFilterFactory() {
        this.register(0, AllQueryFilter.class);
        this.register(1, NewQueryFilter.class);
        this.register(2, PublishQueryFilter.class);
        this.register(3, PublishedQueryFilter.class);
        this.register(8, NoQueryFilter.class);
        this.register(4, SelfQueryFilter.class);
        this.register(5, DayQueryFilter.class);
        this.register(6, WeekQueryFilter.class);
        this.register(7, MonthQueryFilter.class);
    }

    public static synchronized IQueryFilterFactory getInstance() {
        if (instance == null) {
            instance = new QueryFilterFactory();
        }
        return instance;
    }

    @Override
    public void register(int nFilterType, Class OQueryFilterCls) {
        this.mFilterMapping.put(new Integer(nFilterType), OQueryFilterCls);
    }

    @Override
    public IQueryFilter createQueryFilter(int nFilterType) throws WCMException {
        Class oFilterClass = (Class)this.mFilterMapping.get(new Integer(nFilterType));
        if (oFilterClass == null) {
            throw new WCMException(I18NMessage.get(QueryFilterFactory.class, "QueryFilterFactory.label1", "\u6ca1\u6709\u6ce8\u518c\u7c7b\u578b\u4e3a[") + nFilterType + I18NMessage.get(QueryFilterFactory.class, "QueryFilterFactory.label2", "]\u7684\u8fc7\u6ee4\u5668"));
        }
        IQueryFilter oQueryFilter = null;
        try {
            oQueryFilter = (IQueryFilter)oFilterClass.newInstance();
        }
        catch (Exception e) {
            throw new WCMException(I18NMessage.get(QueryFilterFactory.class, "QueryFilterFactory.label3", "\u52a0\u8f7d\u8fc7\u6ee4\u5668\u7c7b[") + oFilterClass + I18NMessage.get(QueryFilterFactory.class, "QueryFilterFactory.label4", "]\u51fa\u73b0\u5f02\u5e38"));
        }
        return oQueryFilter;
    }
}

