/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.widget;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.domain.tagparser.TagDocument;
import com.trs.components.common.publish.domain.tagparser.TagDocumentReader;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.common.publish.widget.IWidgetInstanceMgr;
import com.trs.components.common.publish.widget.WidgetInstance;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.persistent.listener.IObjectLCListenerOnBeforeAdd;
import com.trs.infra.persistent.listener.IObjectLCListenerOnDel;
import com.trs.infra.persistent.listener.IObjectLCListenerOnModify;
import com.trs.infra.util.CMyString;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class TemplateLCListenerVisualTemplate
implements IObjectLCListenerOnBeforeAdd,
IObjectLCListenerOnDel,
IObjectLCListenerOnModify {
    private static Logger logger = Logger.getLogger(TemplateLCListenerVisualTemplate.class);
    private static Pattern m_oInstancePattern = Pattern.compile("(?im)(<trs_widget[^>]+)id=[\"'](\\d+)[\"']([^>]*>)");
    private static IWidgetInstanceMgr m_oWidgetInstMgr = (IWidgetInstanceMgr)DreamFactory.createObjectById("IWidgetInstanceMgr");
    private static final int NORMAL_TEMPLATE = 0;
    private static final int CLONE_INSTANCE = 2;
    private static final int UPDATE_TEMPLATE_ID = 4;

    @Override
    public void notifyOnDelObj(BaseObj objDeleted, int eventType) throws WCMException {
        if (!(objDeleted instanceof Template)) {
            return;
        }
        Template template = (Template)objDeleted;
        if (!template.getPropertyAsBoolean("VISUAL", false)) {
            return;
        }
        int nTemplateId = template.getId();
        StringBuffer sbSQL4Param = new StringBuffer();
        sbSQL4Param.append("delete from ");
        sbSQL4Param.append("XWCMWIDGETINSTPARAMETER");
        sbSQL4Param.append(" where WidgetInstId in ( select WidgetInstanceId from ");
        sbSQL4Param.append("XWCMWIDGETINSTANCE");
        sbSQL4Param.append(" where templateid=").append(nTemplateId);
        sbSQL4Param.append(")");
        try {
            DBManager.getDBManager().sqlExecuteUpdate(sbSQL4Param.toString());
        }
        catch (Exception e) {
            logger.info((Object)"\u5220\u9664\u4e13\u9898\u540e\uff0c\u6267\u884c\u5220\u9664\u8d44\u6e90\u5b9e\u4f8b\u53d8\u91cf\u7684sql\u51fa\u9519", (Throwable)e);
        }
        StringBuffer sbSQL4Widget = new StringBuffer();
        sbSQL4Widget.append("delete from ");
        sbSQL4Widget.append("XWCMWIDGETINSTANCE");
        sbSQL4Widget.append(" where TEMPLATEID=");
        sbSQL4Widget.append(nTemplateId);
        try {
            DBManager.getDBManager().sqlExecuteUpdate(sbSQL4Widget.toString());
        }
        catch (Exception e) {
            logger.info((Object)"\u5220\u9664\u4e13\u9898\u540e\uff0c\u6267\u884c\u5220\u9664\u8d44\u6e90\u5b9e\u4f8b\u7684sql\u51fa\u9519", (Throwable)e);
        }
    }

    @Override
    public void notifyOnBeforeAddObj(BaseObj objAdded) throws WCMException {
        logger.debug((Object)"buildRelationBetweenTempAndWidget...");
        if (!(objAdded instanceof Template)) {
            return;
        }
        Template template = (Template)objAdded;
        if (!template.getPropertyAsBoolean("VISUAL", false)) {
            return;
        }
        if (objAdded.getId() == 0) {
            objAdded.setNextId();
        }
        switch (this.guessMode(template)) {
            case 4: {
                this.updateWidgetInstanceTemplate(template);
                break;
            }
            case 2: {
                String sTempText = this.cloneWidgetInstanceAndUpdateTemplateText(template);
                template.setText(sTempText);
                break;
            }
        }
    }

    @Override
    public void notifyOnModifyObj(BaseObj objModified, int eventType) throws WCMException {
        this.notifyOnBeforeAddObj(objModified);
    }

    private int guessMode(Template template) {
        String sVisualText = template.getFinalPropertyAsString("TempText");
        if (CMyString.isEmpty(sVisualText)) {
            return 0;
        }
        try {
            TagDocument tagDoc = TagDocumentReader.read(sVisualText);
            Iterator iterator = tagDoc.findItems("TRS_WIDGET");
            if (!iterator.hasNext()) {
                return 0;
            }
            TagItem item = (TagItem)iterator.next();
            String sWidgetInstanceId = item.getAttribute("id");
            if (CMyString.isEmpty(sWidgetInstanceId)) {
                logger.error((Object)"\u731c\u6d4b\u6a21\u677f\u521b\u5efa\u65b9\u5f0f\u65f6\uff0c\u51fa\u73b0\u4e86\u6ca1\u6709\u9884\u671f\u7684\u60c5\u51b5\uff0c\u8fd9\u79cd\u60c5\u51b5\u662f\u4e0d\u5e94\u8be5\u5b58\u5728\u7684\uff1a[\u53ef\u89c6\u5316\u6a21\u677f\u4e2d\u7f6e\u6807TRS_Widget\u7684\u5b9e\u4f8bid\u7adf\u7136\u6ca1\u6709\u51fa\u73b0]");
                return 0;
            }
            WidgetInstance instance = WidgetInstance.findById(Integer.parseInt(sWidgetInstanceId));
            if (instance == null) {
                logger.error((Object)"\u731c\u6d4b\u6a21\u677f\u521b\u5efa\u65b9\u5f0f\u65f6\uff0c\u51fa\u73b0\u4e86\u6ca1\u6709\u9884\u671f\u7684\u60c5\u51b5\uff0c\u8fd9\u79cd\u60c5\u51b5\u662f\u4e0d\u5e94\u8be5\u5b58\u5728\u7684\uff1a[\u53ef\u89c6\u5316\u6a21\u677f\u4e2d\u7f6e\u6807TRS_Widget\u7684\u5b9e\u4f8bid\u5bf9\u5e94\u7684\u5bf9\u8c61\u7adf\u7136\u4e0d\u5b58\u5728]");
                return 0;
            }
            if (instance.getTemplateId() == 0) {
                return 4;
            }
            if (instance.getTemplateId() != template.getId()) {
                return 2;
            }
        }
        catch (Exception e) {
            logger.info((Object)"\u731c\u6d4b\u6a21\u677f\u521b\u5efa\u65b9\u5f0f\u65f6\uff0c\u83b7\u53d6\u6a21\u677f\u4e2d\u7684\u8d44\u6e90\u5b9e\u4f8b\u7f6e\u6807TRS_WIDGET\u51fa\u73b0\u9519\u8bef", (Throwable)e);
        }
        return 0;
    }

    private String cloneWidgetInstanceAndUpdateTemplateText(Template template) throws WCMException {
        String sVisualHtml = template.getFinalPropertyAsString("TEMPTEXT");
        if (CMyString.isEmpty(sVisualHtml)) {
            return "";
        }
        StringBuffer sbVisualHtml = new StringBuffer(sVisualHtml.length());
        User user = ContextHelper.getLoginUser();
        Matcher matcher = m_oInstancePattern.matcher(sVisualHtml);
        int nInstanceId = 0;
        int nStartIndex = 0;
        int nEndIndex = 0;
        while (matcher.find()) {
            nStartIndex = matcher.start();
            sbVisualHtml.append(sVisualHtml.substring(nEndIndex, nStartIndex));
            nEndIndex = matcher.end();
            sbVisualHtml.append(matcher.group(1));
            nInstanceId = Integer.parseInt(matcher.group(2));
            WidgetInstance widgetInstance = WidgetInstance.findById(nInstanceId);
            widgetInstance = m_oWidgetInstMgr.clone(widgetInstance);
            widgetInstance.setTemplateId(template.getId());
            widgetInstance.save(user);
            sbVisualHtml.append("id=\"").append(widgetInstance.getId()).append("\"");
            sbVisualHtml.append(matcher.group(3));
        }
        if (nEndIndex < sVisualHtml.length()) {
            sbVisualHtml.append(sVisualHtml.substring(nEndIndex));
        }
        return sbVisualHtml.toString();
    }

    private void updateWidgetInstanceTemplate(Template template) {
        String sVisualText = template.getFinalPropertyAsString("TempText");
        if (CMyString.isEmpty(sVisualText)) {
            return;
        }
        StringBuffer sbWhere = new StringBuffer();
        StringBuffer sbIds = new StringBuffer();
        try {
            TagDocument tagDoc = TagDocumentReader.read(sVisualText);
            Iterator iterator = tagDoc.findItems("TRS_WIDGET");
            while (iterator.hasNext()) {
                TagItem item = (TagItem)iterator.next();
                sbWhere.append("?,");
                sbIds.append(item.getIntAttribute("id", 0)).append(",");
            }
        }
        catch (Exception e) {
            logger.info((Object)"\u4fdd\u5b58\u53ef\u89c6\u5316\u6a21\u677f\u65f6\uff0c\u83b7\u53d6\u6a21\u677f\u4e2d\u7684\u8d44\u6e90\u5b9e\u4f8b\u7f6e\u6807TRS_WIDGET\u51fa\u73b0\u9519\u8bef", (Throwable)e);
        }
        if (sbWhere.length() <= 0) {
            return;
        }
        sbWhere.setLength(sbWhere.length() - 1);
        sbIds.setLength(sbIds.length() - 1);
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append("update ").append("XWCMWIDGETINSTANCE");
        sbSQL.append(" set templateid=? ");
        sbSQL.append(" where ").append("WIDGETINSTANCEID");
        sbSQL.append(" in (");
        sbSQL.append(sbWhere);
        sbSQL.append(")");
        sbIds.insert(0, template.getId() + ",");
        try {
            DBManager.getDBManager().sqlExecuteUpdate(new String[]{sbSQL.toString()}, CMyString.splitToInt(sbIds.toString(), ","));
        }
        catch (WCMException e) {
            logger.info((Object)"\u4fdd\u5b58\u53ef\u89c6\u5316\u6a21\u677f\u65f6\uff0c\u6267\u884csql\u66f4\u65b0\u5efa\u7acb\u6a21\u677f\u4e0e\u8d44\u6e90\u5b9e\u4f8bid\u7684\u5173\u8054\u65f6\u51fa\u73b0\u9519\u8bef", (Throwable)e);
        }
    }
}

