/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.widget;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.widget.BaseStyle;
import com.trs.components.common.publish.widget.ContentStyle;
import com.trs.components.common.publish.widget.ContentStyles;
import com.trs.components.common.publish.widget.IContentStyleMgr;
import com.trs.components.common.publish.widget.IResourceStyleMgr;
import com.trs.components.common.publish.widget.PageStyle;
import com.trs.components.common.publish.widget.ResourceStyle;
import com.trs.components.common.publish.widget.ResourceStyles;
import com.trs.components.common.publish.widget.StyleItem;
import com.trs.components.common.publish.widget.StyleItems;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjToXmlConverter;
import com.trs.infra.persistent.ObjToXmlConverter;
import com.trs.infra.persistent.WCMFilter;
import org.dom4j.Element;

public class PageStyleXmlConverter
extends BaseObjToXmlConverter {
    private ObjToXmlConverter m_converter;

    @Override
    protected Element[] getChildElement(BaseObj _baseObj) throws WCMException {
        if (_baseObj == null) {
            throw new WCMException(10, "\u65e0\u6548\u7684\u5bf9\u8c61[null]!");
        }
        if (_baseObj instanceof StyleItem) {
            return null;
        }
        Element[] childElements = null;
        if (_baseObj instanceof PageStyle) {
            PageStyle currPageStyle = (PageStyle)_baseObj;
            Element pageStyleItemElement = this.getPageStyleItemElement(currPageStyle);
            Element resourceStyleElement = this.getPageResourceStyleElement(currPageStyle);
            Element contentStyleElement = this.getPageContentStyleElement(currPageStyle);
            childElements = new Element[]{pageStyleItemElement, resourceStyleElement, contentStyleElement};
        } else if (_baseObj instanceof ResourceStyle) {
            ResourceStyle currResourceStyle = (ResourceStyle)_baseObj;
            StyleItems resourceStyleItems = this.getBaseStyleItems(currResourceStyle);
            Element resourceStyleItemElement = this.toXmlElement(resourceStyleItems, null);
            childElements = new Element[]{resourceStyleItemElement};
        } else if (_baseObj instanceof ContentStyle) {
            ContentStyle currContentStyle = (ContentStyle)_baseObj;
            StyleItems contentStyleItems = this.getBaseStyleItems(currContentStyle);
            Element contentStyleItemElement = this.toXmlElement(contentStyleItems, null);
            childElements = new Element[]{contentStyleItemElement};
        }
        return childElements;
    }

    private Element getPageStyleItemElement(PageStyle _currPageStyle) throws WCMException {
        if (_currPageStyle == null) {
            throw new WCMException("\u4f20\u5165\u7684_currPageStyle\u5bf9\u8c61\u4e3anull\uff01");
        }
        StyleItems pageStyleItems = this.getBaseStyleItems(_currPageStyle);
        return this.toXmlElement(pageStyleItems, null);
    }

    private Element getPageResourceStyleElement(PageStyle _currPageStyle) throws WCMException {
        if (_currPageStyle == null) {
            throw new WCMException("\u4f20\u5165\u7684_currPageStyle\u5bf9\u8c61\u4e3anull\uff01");
        }
        IResourceStyleMgr resourceStyleMgr = (IResourceStyleMgr)DreamFactory.createObjectById("IResourceStyleMgr");
        ResourceStyles currResourceStyles = resourceStyleMgr.query(_currPageStyle, null);
        if (currResourceStyles == null || currResourceStyles.isEmpty()) {
            return null;
        }
        return this.toXmlElement(currResourceStyles, null);
    }

    private Element getPageContentStyleElement(PageStyle _currPageStyle) throws WCMException {
        if (_currPageStyle == null) {
            throw new WCMException("\u4f20\u5165\u7684_currPageStyle\u5bf9\u8c61\u4e3anull\uff01");
        }
        IContentStyleMgr contentStyleMgr = (IContentStyleMgr)DreamFactory.createObjectById("IContentStyleMgr");
        ContentStyles currContentStyles = contentStyleMgr.query(_currPageStyle, null);
        if (currContentStyles == null || currContentStyles.isEmpty()) {
            return null;
        }
        return this.toXmlElement(currContentStyles, null);
    }

    private StyleItems getBaseStyleItems(BaseStyle _baseStyle) throws WCMException {
        if (_baseStyle == null) {
            throw new WCMException("\u4f20\u5165\u7684BaseStyle\u5bf9\u8c61\u4e3anull\uff01");
        }
        WCMFilter aFilter = new WCMFilter("", "StyleObjType=? and StyleObjId=?", "");
        if (_baseStyle instanceof PageStyle) {
            PageStyle aPageStyle = (PageStyle)_baseStyle;
            aFilter.addSearchValues(0, aPageStyle.getWCMType());
            aFilter.addSearchValues(1, aPageStyle.getId());
        } else if (_baseStyle instanceof ResourceStyle) {
            ResourceStyle aResourceStyle = (ResourceStyle)_baseStyle;
            aFilter.addSearchValues(0, aResourceStyle.getWCMType());
            aFilter.addSearchValues(1, aResourceStyle.getId());
        } else if (_baseStyle instanceof ContentStyle) {
            ContentStyle aContentStyle = (ContentStyle)_baseStyle;
            aFilter.addSearchValues(0, aContentStyle.getWCMType());
            aFilter.addSearchValues(1, aContentStyle.getId());
        } else {
            throw new WCMException("\u5bf9\u8c61[" + _baseStyle.getClass().getName() + "]\u4e0d\u662f\u7ee7\u627fBaseStyle\uff01");
        }
        return StyleItems.openWCMObjs(this.getLoginUser(), aFilter);
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }
}

