/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.widget;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.widget.ContentStyle;
import com.trs.components.common.publish.widget.ContentStyleXmlConverter;
import com.trs.components.common.publish.widget.ContentStyles;
import com.trs.components.common.publish.widget.IPageStyleMgr;
import com.trs.components.common.publish.widget.PageStyle;
import com.trs.components.common.publish.widget.PageStyles;
import com.trs.components.common.publish.widget.StyleItem;
import com.trs.components.common.publish.widget.StyleItems;
import com.trs.components.common.publish.widget.StylePathHelper;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CMyZip;
import com.trs.infra.util.store.FileService;
import com.trs.infra.util.store.FileStore;
import java.io.File;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class ContentStyleExporter {
    private static Logger logger = Logger.getLogger(ContentStyleExporter.class);
    private String m_sXMLEncoding = "utf-8";
    private String[] m_aImageClassNameStyleItems = new String[]{"p_w_list_li_background", "p_doc_title_background", "c_line_background_image", "doc_new_icon_background_image"};
    private IPageStyleMgr m_oPageStyleMgr = (IPageStyleMgr)DreamFactory.createObjectById("IPageStyleMgr");

    public String export(ContentStyles _currContentStyles, int _nPageStyleId) throws Exception {
        if (_currContentStyles == null) {
            throw new WCMException("\u5bfc\u51fa\u7684ContentStyle\u5bf9\u8c61\u4e3anull!");
        }
        FilesMan filesMan = FilesMan.getFilesMan();
        String sZipFile = filesMan.getNextFileName("ST", "zip", null, true);
        CMyZip myZip = new CMyZip();
        myZip.setZipFileName(sZipFile);
        String sTempFilePath = CMyFile.extractFilePath(sZipFile);
        CMyDateTime nowDateTime = CMyDateTime.now();
        String sTempPath = sTempFilePath + nowDateTime.toString("yyyy-MM-dd") + "_" + System.currentTimeMillis() + "_temp";
        CMyFile.makeDir(sTempPath, true);
        try {
            int i;
            if (_nPageStyleId > 0) {
                PageStyle pageStyle = PageStyle.findById(_nPageStyleId);
                this.exportContentStylesForOnePageStyle(_currContentStyles, pageStyle, sTempPath);
            } else {
                PageStyles pageStyles = this.m_oPageStyleMgr.query(null);
                int nSize = pageStyles.size();
                for (i = 0; i < nSize; ++i) {
                    PageStyle pageStyle = (PageStyle)pageStyles.getAt(i);
                    if (pageStyle == null) continue;
                    int nPageStyleId = pageStyle.getId();
                    ContentStyles contentStyles = new ContentStyles(this.getLoginUser());
                    int nContentStyleSize = _currContentStyles.size();
                    for (int j = 0; j < nContentStyleSize; ++j) {
                        String sCssFlag;
                        ContentStyles oSameNameContentstyles;
                        ContentStyle content = (ContentStyle)_currContentStyles.getAt(j);
                        if (content == null || (oSameNameContentstyles = ContentStyles.findSameCssFlagStyles(sCssFlag = content.getCssFlag(), nPageStyleId)) == null || oSameNameContentstyles.size() == 0) continue;
                        contentStyles.addElement(oSameNameContentstyles.getAt(0));
                    }
                    this.exportContentStylesForOnePageStyle(contentStyles, pageStyle, sTempPath);
                }
            }
            myZip.setZipWithChildDirPath(true);
            FileStore[] files = CMyFile.listSubDirectories(sTempPath);
            for (i = 0; i < files.length; ++i) {
                FileStore oFile = files[i];
                String sPath = oFile.getAbsolutePath();
                myZip.addToZip(sPath, false);
            }
            myZip.done();
        }
        catch (Exception e) {
            logger.error((Object)"failed to zip files!", (Throwable)e);
            CMyFile.deleteFile(sZipFile);
            throw new WCMException(1100, "\u538b\u7f29\u6587\u4ef6\u5931\u8d25!", e);
        }
        finally {
            CMyFile.deleteDir(sTempPath);
        }
        return CMyFile.extractFileName(sZipFile);
    }

    private void exportContentStylesForOnePageStyle(ContentStyles _ContentStyles2, PageStyle _oPageStyle, String _sTempPath) throws Exception {
        FilesMan filesMan = FilesMan.getFilesMan();
        String sXmlFile = filesMan.getNextFileName("ST", "xml", null, true);
        ContentStyleXmlConverter contentStyleXmlConvertor = new ContentStyleXmlConverter();
        contentStyleXmlConvertor.setXmlEncoding(this.m_sXMLEncoding);
        contentStyleXmlConvertor.toXMLFile(_ContentStyles2, sXmlFile);
        String sPageStyleName = _oPageStyle.getStyleName();
        String sStylePath = _sTempPath + File.separator + sPageStyleName + File.separator;
        CMyFile.makeDir(sStylePath, true);
        String sXmlFileName = CMyFile.extractFileName(sXmlFile);
        CMyFile.copyFile(sXmlFile, sStylePath + sXmlFileName);
        CMyFile.deleteFile(sXmlFile);
        for (int m = 0; m < _ContentStyles2.size(); ++m) {
            ContentStyle oContent = (ContentStyle)_ContentStyles2.getAt(m);
            if (oContent == null) continue;
            String sTempThumbPath = sStylePath + "thumb" + File.separator;
            if (!CMyFile.fileExists(sTempThumbPath)) {
                CMyFile.makeDir(sTempThumbPath, true);
            }
            this.addContentStyleThumbFolder(oContent, sTempThumbPath);
            String sStyleCommonDir = StylePathHelper.getStyleCommonDir();
            String sCustomStyle = oContent.getCustomStyle();
            if (CMyString.isEmpty(sCustomStyle)) {
                this.addStyleItemImagesFolder(oContent, sStyleCommonDir, _sTempPath);
                continue;
            }
            this.addCustomStyleContentImagesFolder(sCustomStyle, sStyleCommonDir, _sTempPath);
        }
    }

    private void addCustomStyleContentImagesFolder(String _sCustomStyle, String _sConmmonDir, String _sTempPath) throws CMyException {
        if (CMyString.isEmpty(_sCustomStyle)) {
            return;
        }
        Pattern oPattern = Pattern.compile("(../style_common/\\w+/\\w+.(gif|png|jpeg|bmp|jpg))");
        Matcher matcher = oPattern.matcher(_sCustomStyle);
        matcher.reset();
        while (matcher.find()) {
            FileService currFile;
            String urlPath = _sCustomStyle.substring(matcher.start(), matcher.end());
            String sImageAbsolutePath = this.calculteStyleItemImage(_sConmmonDir, urlPath);
            if (CMyString.isEmpty(sImageAbsolutePath) || !CMyFile.fileExists(sImageAbsolutePath) || !(currFile = new FileService(sImageAbsolutePath)).exists()) continue;
            String sFileName = currFile.getName();
            String sFilePath = CMyFile.extractFilePath(sImageAbsolutePath);
            sFilePath = sFilePath.substring(0, sFilePath.length() - 1);
            int nLastIndex = sFilePath.lastIndexOf(File.separatorChar);
            String _sTargetTempPath = CMyString.setStrEndWith(_sTempPath, File.separatorChar);
            String sLastFileName = sFilePath.substring(nLastIndex + 1);
            if (!CMyFile.fileExists(_sTargetTempPath = _sTargetTempPath + sLastFileName + File.separatorChar + "resource" + File.separatorChar)) {
                CMyFile.makeDir(_sTargetTempPath, true);
            }
            CMyFile.copyFile(sImageAbsolutePath, _sTargetTempPath + sFileName, false);
        }
    }

    private void addContentStyleThumbFolder(ContentStyle _currContentStyle, String _sTempPageStylePath) throws Exception {
        if (_currContentStyle == null) {
            return;
        }
        String sStyleThumb = _currContentStyle.getStyleThumb();
        if (CMyString.isEmpty(sStyleThumb)) {
            return;
        }
        FilesMan filesMan = FilesMan.getFilesMan();
        String sContentStyleThumb = filesMan.mapFilePath(sStyleThumb, 0) + sStyleThumb;
        CMyFile.copyFile(sContentStyleThumb, _sTempPageStylePath + sStyleThumb);
    }

    private void addStyleItemImagesFolder(ContentStyle _currContentStyle, String _sCommonDir, String _sTempPath) throws Exception {
        if (_currContentStyle == null) {
            return;
        }
        ArrayList thumbAndImageList = this.getContentStyleItemImages(_currContentStyle, _sCommonDir);
        for (int i = 0; i < thumbAndImageList.size(); ++i) {
            FileService currFile;
            String sThumbFilePath = (String)thumbAndImageList.get(i);
            if (CMyString.isEmpty(sThumbFilePath) || !(currFile = new FileService(sThumbFilePath)).exists()) continue;
            String sFileName = currFile.getName();
            String sFilePath = CMyFile.extractFilePath(sThumbFilePath);
            sFilePath = sFilePath.substring(0, sFilePath.length() - 1);
            int nLastIndex = sFilePath.lastIndexOf(File.separatorChar);
            String _sTargetTempPath = CMyString.setStrEndWith(_sTempPath, File.separatorChar);
            String sLastFileName = sFilePath.substring(nLastIndex + 1);
            if (!CMyFile.fileExists(_sTargetTempPath = _sTargetTempPath + sLastFileName + File.separatorChar + "resource" + File.separatorChar)) {
                CMyFile.makeDir(_sTargetTempPath, true);
            }
            CMyFile.copyFile(sThumbFilePath, _sTargetTempPath + sFileName, false);
        }
    }

    public ArrayList getContentStyleItemImages(ContentStyle _currContentStyle, String _sConmmonDir) throws WCMException {
        if (_currContentStyle == null) {
            throw new WCMException("\u4f20\u5165\u7684\u5185\u5bb9\u6837\u5f0f\u5bf9\u8c61\u4e3anull\uff01");
        }
        if (_sConmmonDir == null) {
            throw new WCMException("\u8bf7\u4f20\u5165\u5f53\u524d\u5185\u5bb9\u6837\u5f0f\u7f29\u7565\u56fe\u5b58\u653e\u7684\u8def\u5f84\uff01");
        }
        ArrayList<String> thumbFilesList = new ArrayList<String>();
        WCMFilter aFilter = new WCMFilter("", "StyleObjType=? and StyleObjId=?", "");
        aFilter.addSearchValues(0, _currContentStyle.getWCMType());
        aFilter.addSearchValues(1, _currContentStyle.getId());
        StyleItems allStyleItems = StyleItems.openWCMObjs(this.getLoginUser(), aFilter);
        if (CMyString.isEmpty(_sConmmonDir)) {
            throw new WCMException("\u83b7\u53d6\u8d44\u6e90\u98ce\u683c[Id=" + _currContentStyle.getId() + "]\u7684styleItem\u7684\u8def\u5f84\u5931\u8d25\uff01");
        }
        for (int i = 0; i < allStyleItems.size(); ++i) {
            String sImageAbsolutePath;
            String sItemClassValue;
            StyleItem aStyleItem = (StyleItem)allStyleItems.getAt(i);
            if (aStyleItem == null || !this.isImageStyleItem(aStyleItem) || CMyString.isEmpty(sItemClassValue = aStyleItem.getClassValue()) || CMyString.isEmpty(sImageAbsolutePath = this.calculteStyleItemImage(_sConmmonDir, sItemClassValue)) || !CMyFile.fileExists(sImageAbsolutePath)) continue;
            thumbFilesList.add(sImageAbsolutePath);
        }
        return thumbFilesList;
    }

    private String calculteStyleItemImage(String _sStyleItemImagePath, String _sItemClassValue) {
        if (CMyString.isEmpty(_sStyleItemImagePath) || CMyString.isEmpty(_sItemClassValue)) {
            return null;
        }
        _sItemClassValue = _sItemClassValue.replace('\\', File.separatorChar);
        _sItemClassValue = _sItemClassValue.replace('/', File.separatorChar);
        String sFileName = CMyFile.extractFileName(_sItemClassValue);
        String sFilePath = CMyFile.extractFilePath(_sItemClassValue);
        int nLastIndex = (sFilePath = sFilePath.substring(0, sFilePath.length() - 1)).lastIndexOf(File.separatorChar);
        if (nLastIndex < 0 || nLastIndex + 1 >= _sItemClassValue.length()) {
            return null;
        }
        String sLastFileName = sFilePath.substring(nLastIndex + 1);
        return CMyString.setStrEndWith(_sStyleItemImagePath, File.separatorChar) + sLastFileName + File.separatorChar + sFileName;
    }

    private boolean isImageStyleItem(StyleItem _styleItm) {
        if (_styleItm == null) {
            return false;
        }
        for (int i = 0; i < this.m_aImageClassNameStyleItems.length; ++i) {
            if (!this.m_aImageClassNameStyleItems[i].equalsIgnoreCase(_styleItm.getClassName())) continue;
            return true;
        }
        return false;
    }

    public void setXMLEncoding(String _sXMLEncoding) {
        this.m_sXMLEncoding = _sXMLEncoding;
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    public static void main(String[] args) throws Exception {
        ContextHelper.initContext(User.findByName("admin"));
        ContentStyleExporter export = new ContentStyleExporter();
        ContentStyles styles = ContentStyles.findByIds(ContextHelper.getLoginUser(), "19690");
        String spath = export.export(styles, 0);
        System.out.println("------------" + spath);
    }
}

