/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.parser;

import com.trs.components.common.publish.domain.publisher.PublishPathCompass;
import com.trs.components.common.publish.domain.publisher.PublishSyncGlobalTuner;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.metadata.publish.WCMTagParserViewData;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.support.file.FileHelper;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.html.HtmlElement;
import com.trs.infra.util.html.HtmlElementFinder;
import com.trs.infra.util.html.HtmlUtil;
import com.trs.infra.util.store.FileService;
import com.trs.wcm.publish.ImgFileParserHelper;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class HTMLContentParseHelper {
    private static Logger logger = Logger.getLogger(HTMLContentParseHelper.class);
    private static String[] HTML_TAG_NAMES;
    private static String[] HTML_TAG_SRCS;

    public String makeHTMLContentParsed(PublishTagContext _context, String _sHTMLContent) throws WCMException {
        ArrayList<String> lNeedDistributeFiles;
        IPublishContent content = (IPublishContent)_context.getUpperHost();
        String[] pImgPathPre = this.makeImgPrePath(_context, content);
        String sResult = HTMLContentParseHelper.parseHTMLContent(_context, _sHTMLContent, pImgPathPre, lNeedDistributeFiles = new ArrayList<String>(20));
        if (!CMyString.isEmpty(sResult)) {
            HTMLContentParseHelper.distributionHTMLContentFiles(lNeedDistributeFiles, content, _context);
        }
        return sResult;
    }

    private String[] makeImgPrePath(PublishTagContext _context, IPublishContent _content) throws WCMException {
        boolean bStartImagesSite;
        boolean bImageURLDisanbledByConfig = false;
        int nWebSiteid = _context.getRoot().getId();
        logger.debug((Object)"get into IMAGE_INDEPENT_URL_DISABLE_BY_SITEIDS");
        String imageUrlFilterBySiteIds = ConfigServer.getServer().getSysConfigValue("IMAGE_INDEPENT_URL_DISABLE_BY_SITEIDS", "");
        if (("," + imageUrlFilterBySiteIds + ",").indexOf("," + String.valueOf(nWebSiteid) + ",") >= 0) {
            bImageURLDisanbledByConfig = true;
        }
        if ((bStartImagesSite = "TRUE".equalsIgnoreCase(ConfigServer.getServer().getSysConfigValue("START_IMAGE_SITE", "false"))) && !_context.isPreview() && !bImageURLDisanbledByConfig) {
            String sImageSiteCount = ConfigServer.getServer().getSysConfigValue("IMAGE_SITE_COUNT", "1");
            int nImageSiteCount = Integer.parseInt(sImageSiteCount);
            return HTMLContentParseHelper.convertURL2ImageURL(PublishPathCompass.calFullDataPath(_content, false), nImageSiteCount);
        }
        String sImagePath1 = _context.getPathCompass().getAbsoluteHttpPath(_content.getRealHome());
        String sImagePath2 = PublishPathCompass.calSubDirectory(_content, false);
        String sImagePath = sImagePath1 + sImagePath2;
        if (_context.getAttribute("UrlIsABS", false)) {
            if (_context.isPreview()) {
                return new String[]{_context.getPathCompass().getPreviewHttpPath(_content.getRealHome()) + sImagePath2};
            }
            return new String[]{sImagePath};
        }
        return new String[]{HtmlUtil.calRelativePath(sImagePath, _context.getPageHttpPath())};
    }

    private static String[] convertURL2ImageURL(String _sContentFullDataPath, int _nCount) throws WCMException {
        String sImgSitePre = ConfigServer.getServer().getSysConfigValue("IMAGE_SITE_PRE", "images");
        String sImgMainDomain = ConfigServer.getServer().getSysConfigValue("IMAGE_SITE_MAIN_DOMAIN", "trs.com.cn");
        String[] pResult = new String[_nCount];
        if ("TRUE".equalsIgnoreCase(ConfigServer.getServer().getSysConfigValue("IMAGE_PUBLISH_IN52", "FALSE"))) {
            for (int i = 0; i < _nCount; ++i) {
                pResult[i] = "http://" + sImgSitePre + (i + 1) + "." + sImgMainDomain + "/" + _sContentFullDataPath;
            }
        } else {
            pResult[0] = "http://" + sImgSitePre + "." + sImgMainDomain + "/" + _sContentFullDataPath;
            for (int i = 1; i < _nCount; ++i) {
                pResult[i] = "http://" + sImgSitePre + i + "." + sImgMainDomain + "/" + _sContentFullDataPath;
            }
        }
        return pResult;
    }

    private static void distributionHTMLContentFiles(List<String> _listFiles, IPublishContent _publishContent, PublishTagContext _context) {
        try {
            boolean bCheckDstExists = "1".equalsIgnoreCase(ConfigServer.getServer().getSysConfigValue("CHECK_DST_EXISTS", "1"));
            List<String> listFiles = _listFiles;
            int nSize = listFiles.size();
            if (nSize <= 0) {
                return;
            }
            boolean bPreview = _context.isPreview();
            PublishPathCompass compass = _context.getPathCompass();
            IPublishFolder oldFolder = _publishContent.getFolder();
            _publishContent.setFolder(_publishContent.getRealHome());
            for (int i = 0; i < nSize; ++i) {
                String sSrcFilePathName = listFiles.get(i);
                if (!CMyFile.fileExists(sSrcFilePathName)) continue;
                String sFileName = CMyFile.extractFileName(sSrcFilePathName);
                String sLocalPath = compass.getLocalPath(_publishContent, bPreview);
                String sDstFile = sLocalPath + sFileName;
                if (bCheckDstExists && CMyFile.fileExists(sDstFile)) continue;
                PublishSyncGlobalTuner.insureLocalPathExists(sLocalPath);
                CMyFile.copyFile(sSrcFilePathName, sDstFile);
                if (bPreview) continue;
                _context.getFileDistributeShip().distributeFile(sSrcFilePathName, _publishContent, null, true);
            }
            _publishContent.setFolder(oldFolder);
        }
        catch (Exception ex) {
            String sErrorDesc = I18NMessage.get(WCMTagParserViewData.class, "WCMTagParserViewData.label13", "\u53d1\u5e03") + _publishContent + I18NMessage.get(WCMTagParserViewData.class, "WCMTagParserViewData.label14", "\u7684HTML\u6b63\u6587\u56fe\u7247\u5931\u8d25\uff01");
            logger.error((Object)sErrorDesc, (Throwable)ex);
            _context.getPageContext().addErrorLog(0, sErrorDesc, ex);
        }
    }

    private static String parseHTMLContent(PublishTagContext _context, String _sHTMLContent, String[] _pImgSrcPre, List<String> _lNeedDistributeImgeFiles) throws WCMException {
        String sResult = _sHTMLContent;
        String[] arTagName = HTMLContentParseHelper.getTagNames();
        String[] arTagSrcName = HTMLContentParseHelper.getTagSrcs();
        if (arTagName == null || arTagSrcName == null) {
            return _sHTMLContent;
        }
        int nTagSize = arTagName.length > arTagSrcName.length ? arTagName.length : arTagSrcName.length;
        try {
            int nImageSrcPreIndex = 0;
            for (int nTagIndex = 0; nTagIndex < nTagSize; ++nTagIndex) {
                HtmlElement element;
                String currTagName = arTagName[nTagIndex];
                String currTagSrcName = arTagSrcName[nTagIndex];
                HtmlElementFinder imgFinder = new HtmlElementFinder(sResult);
                while ((element = imgFinder.findNextElement(currTagName, true)) != null) {
                    String sFileName = element.getAttributeValue(currTagSrcName);
                    if (sFileName == null || sFileName.length() == 0) {
                        imgFinder.putElement(element);
                        continue;
                    }
                    if (!FilesMan.isValidFile(sFileName, "W0")) {
                        imgFinder.putElement(element);
                        continue;
                    }
                    int nPos = sFileName.lastIndexOf(47);
                    if (nPos > 0) {
                        sFileName = sFileName.substring(nPos + 1);
                    }
                    String _sImgSrcPre = _pImgSrcPre[nImageSrcPreIndex++];
                    if (nImageSrcPreIndex >= _pImgSrcPre.length) {
                        nImageSrcPreIndex = 0;
                    }
                    String sAbsoluteFieldName = "";
                    sAbsoluteFieldName = ConfigServer.getServer().getSysConfigValue("Image_Convert_Quality", "false").trim().equalsIgnoreCase("true") ? ImgFileParserHelper.makeAbsoluteFilePathAndConvert(sFileName, _context) : FileHelper.makeAbsoluteFilePathOfImage(sFileName, _context.getAttribute("InWidth", 0));
                    sFileName = CMyFile.extractFileName(sAbsoluteFieldName);
                    FileService file = new FileService(sAbsoluteFieldName);
                    if (!file.exists()) continue;
                    if (_lNeedDistributeImgeFiles != null) {
                        _lNeedDistributeImgeFiles.add(sAbsoluteFieldName);
                    }
                    element.setAttribute(currTagSrcName, _sImgSrcPre + sFileName);
                    imgFinder.putElement(element);
                }
                sResult = imgFinder.getContent();
            }
            return sResult;
        }
        catch (Exception ex) {
            throw new WCMException("\u6784\u9020HTML\u5185\u5bb9\u4e2d\u7684\u56fe\u7247\u524d\u7f00\u5931\u8d25", ex);
        }
    }

    private static String[] getTagNames() {
        if (HTML_TAG_NAMES != null) {
            return HTML_TAG_NAMES;
        }
        ConfigServer configServer = ConfigServer.getServer();
        String sTagNames = configServer.getInitProperty("DOC_HTML_TAG_NAMES");
        if (sTagNames == null || sTagNames.length() == 0) {
            return null;
        }
        try {
            HTML_TAG_NAMES = CMyString.split(sTagNames, ",");
        }
        catch (Exception ex) {
            HTML_TAG_NAMES = null;
        }
        return HTML_TAG_NAMES;
    }

    private static String[] getTagSrcs() {
        if (HTML_TAG_SRCS != null) {
            return HTML_TAG_SRCS;
        }
        ConfigServer configServer = ConfigServer.getServer();
        String sTagSrcs = configServer.getInitProperty("DOC_HTML_TAG_SRCS");
        if (sTagSrcs == null || sTagSrcs.length() == 0) {
            return null;
        }
        try {
            HTML_TAG_SRCS = CMyString.split(sTagSrcs, ",");
        }
        catch (Exception ex) {
            HTML_TAG_SRCS = null;
        }
        return HTML_TAG_SRCS;
    }
}

