/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.bookmark;

import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.Role;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.address.Contact;
import com.trs.components.common.address.ContactGrp;
import com.trs.components.common.address.ContactGrps;
import com.trs.components.common.address.Contacts;
import com.trs.components.common.bookmark.BookMark;
import com.trs.components.common.bookmark.BookMarks;
import com.trs.components.common.bookmark.MarkKind;
import com.trs.components.common.bookmark.MarkKinds;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;

public class MarkShare
extends CMSObj {
    public static final int OBJ_TYPE = 308;
    public static final String DB_TABLE_NAME = "WCMMARKSHARE";
    public static final String DB_ID_NAME = "SHAREID";
    public static final int MARKSHARE_STATE_ALLUSER = 0;

    @Override
    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    @Override
    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    @Override
    public int getWCMType() {
        return 308;
    }

    public int getObjType() {
        return this.getPropertyAsInt("OBJTYPE", 0);
    }

    public boolean setObjType(int _objType) throws WCMException {
        if (_objType != 303 && _objType != 307) {
            throw new WCMException(10, I18NMessage.get(MarkShare.class, "MarkShare.label1", "\u65e0\u6548\u7684\u7c7b\u578b\u8bbe\u7f6e\uff08MarkShare.setObjType\uff09"));
        }
        return this.setProperty("OBJTYPE", _objType);
    }

    public int getObjId() {
        return this.getPropertyAsInt("OBJID", 0);
    }

    public boolean setObjId(int _objId) throws WCMException {
        if (_objId < 0) {
            throw new WCMException(1104, I18NMessage.get(MarkShare.class, "MarkShare.label2", "ObjId\u503c\u65e0\u6548(MarkShare.setObjId)"));
        }
        return this.setProperty("OBJID", _objId);
    }

    public int getViewerType() {
        return this.getPropertyAsInt("VIEWERTYPE", 0);
    }

    public boolean setViewerType(int _viewerType) throws WCMException {
        if (_viewerType != 204 && _viewerType != 201 && _viewerType != 203 && _viewerType != 304 && _viewerType != 305 && _viewerType != 0) {
            throw new WCMException(10, I18NMessage.get(MarkShare.class, "MarkShare.label3", "\u65e0\u6548\u7684\u7c7b\u578b\u8bbe\u7f6e\uff08MarkShare.setViewerType\uff09"));
        }
        return this.setProperty("VIEWERTYPE", _viewerType);
    }

    public int getViewerId() {
        return this.getPropertyAsInt("VIEWERID", 0);
    }

    public boolean setViewerId(int _viewerId) throws WCMException {
        if (_viewerId < 0) {
            throw new WCMException(1104, I18NMessage.get(MarkShare.class, "MarkShare.label4", "ViewerId\u503c\u65e0\u6548(MarkShare.setViewerId)"));
        }
        return this.setProperty("VIEWERID", _viewerId);
    }

    @Override
    public String getAttribute() {
        return (String)this.getProperty("ATTRIBUTE");
    }

    @Override
    public boolean setAttribute(String _attribute) throws WCMException {
        return this.setProperty("Attribute", _attribute);
    }

    @Override
    public boolean isValid() throws WCMException {
        Number iObjType = null;
        Number iObjId = null;
        Number iViewerType = null;
        Number iViewerId = null;
        if (this.isAddMode()) {
            iObjType = (Number)this.getAllProperty().get("OBJTYPE");
            iObjId = (Number)this.getAllProperty().get("OBJID");
            iViewerType = (Number)this.getAllProperty().get("VIEWERTYPE");
            iViewerId = (Number)this.getAllProperty().get("VIEWERID");
            if (iObjType == null) {
                throw new WCMException(1106, I18NMessage.get(MarkShare.class, "MarkShare.label5", "\u5c5e\u6027ObjType\u6ca1\u6709\u8bbe\u7f6e(MarkShare.isValid)"));
            }
            if (iObjId == null) {
                throw new WCMException(1106, I18NMessage.get(MarkShare.class, "MarkShare.label6", "\u5c5e\u6027ObjId\u6ca1\u6709\u8bbe\u7f6e(MarkShare.isValid)"));
            }
            if (iViewerType == null) {
                throw new WCMException(1106, I18NMessage.get(MarkShare.class, "MarkShare.label7", "\u5c5e\u6027ViewerType\u6ca1\u6709\u8bbe\u7f6e(MarkShare.isValid)"));
            }
            if (iViewerId == null) {
                throw new WCMException(1106, I18NMessage.get(MarkShare.class, "MarkShare.label8", "\u5c5e\u6027ViewerId\u6ca1\u6709\u8bbe\u7f6e(MarkShare.isValid)"));
            }
        } else {
            if (!this.isModified()) {
                throw new WCMException(1107, I18NMessage.get(MarkShare.class, "MarkShare.label9", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(MarkShare.isValid)"));
            }
            iObjType = (Number)this.getNewProperty("OBJTYPE");
            iObjId = (Number)this.getNewProperty("OBJID");
            iViewerType = (Number)this.getNewProperty("VIEWERTYPE");
            iViewerId = (Number)this.getNewProperty("VIEWERID");
            if (iObjType == null) {
                iObjType = (Number)this.getAllProperty().get("OBJTYPE");
            }
            if (iObjId == null) {
                iObjId = (Number)this.getAllProperty().get("OBJID");
            }
            if (iViewerType == null) {
                iViewerType = (Number)this.getAllProperty().get("VIEWERTYPE");
            }
            if (iViewerId == null) {
                iViewerId = (Number)this.getAllProperty().get("VIEWERID");
            }
        }
        if (iObjType != null || iObjId != null || iViewerType != null || iViewerId != null) {
            String strCondition = "ObjType=" + iObjType + " and ObjId=" + iObjId + " and ViewerType=" + iViewerType + " and ViewerId=" + iViewerId;
            if (!this.isAddMode()) {
                strCondition = strCondition + " and " + this.getIdFieldName() + "<>" + this.getId();
            }
            if (this.checkExists(strCondition = strCondition + " and CrUser='" + this.getCrUserName() + "'")) {
                throw new WCMException(1108, I18NMessage.get(MarkShare.class, "MarkShare.label10", "\u76f8\u540c\u5171\u4eab\u5df2\u7ecf\u5b58\u5728\uff08MarkShare.isValid\uff09"));
            }
        }
        return true;
    }

    @Override
    public void insert(User _currUser) throws WCMException {
        if (this.isAddMode() && this.getAllProperty() != null) {
            this.setCrTime();
            super.insert(_currUser);
        }
    }

    public void setViewer(CMSObj _viewer) throws WCMException {
        int nType;
        if (_viewer == null || !_viewer.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(MarkShare.class, "MarkShare.label11", "\u65e0\u6548\u53c2\u6570(MarkShare.setViewer)"));
        }
        if (_viewer instanceof User) {
            nType = 204;
        } else if (_viewer instanceof Group) {
            nType = 201;
        } else if (_viewer instanceof Role) {
            nType = 203;
        } else if (_viewer instanceof Contact) {
            nType = 304;
        } else if (_viewer instanceof ContactGrp) {
            nType = 305;
        } else {
            throw new WCMException(10, I18NMessage.get(MarkShare.class, "MarkShare.label12", "\u5bf9\u8c61\u7c7b\u578b\u65e0\u6548(MarkShare.setObject)"));
        }
        this.setViewerType(nType);
        this.setViewerId(_viewer.getId());
    }

    public CMSObj getViewer(User _currUser) throws WCMException {
        switch (this.getViewerType()) {
            case 204: {
                return User.findById(this.getViewerId());
            }
            case 203: {
                return Role.findById(this.getViewerId());
            }
            case 201: {
                return Group.findById(this.getViewerId());
            }
            case 304: {
                WCMFilter filter = new WCMFilter("", "ContactId=" + this.getViewerId(), "");
                Contacts contacts = new Contacts(_currUser, 1, 1);
                Contact contact = null;
                try {
                    contacts.open(filter);
                    contact = (Contact)(contacts.isEmpty() ? null : contacts.getAt(0));
                    contacts.clear();
                    return contact;
                }
                catch (WCMException ex) {
                    throw new WCMException(1100, I18NMessage.get(MarkShare.class, "MarkShare.label13", "\u53d6\u5171\u4eab\u5bf9\u8c61\u65f6\u51fa\u9519(MarkShare.getObject)"), ex);
                }
            }
            case 305: {
                WCMFilter filter = new WCMFilter("", "GroupId=" + this.getViewerId(), "");
                ContactGrps contactGrps = new ContactGrps(_currUser, 1, 1);
                ContactGrp contactGrp = null;
                try {
                    contactGrps.open(filter);
                    contactGrp = (ContactGrp)(contactGrps.isEmpty() ? null : contactGrps.getAt(0));
                    contactGrps.clear();
                    return contactGrp;
                }
                catch (WCMException ex) {
                    throw new WCMException(1100, I18NMessage.get(MarkShare.class, "MarkShare.label13", "\u53d6\u5171\u4eab\u5bf9\u8c61\u65f6\u51fa\u9519(MarkShare.getObject)"), ex);
                }
            }
        }
        return null;
    }

    public CMSObj getObject(User _currUser) throws WCMException {
        switch (this.getObjType()) {
            case 303: {
                return this.getBookMark(_currUser);
            }
            case 307: {
                return this.getMarkKind(_currUser);
            }
        }
        throw new WCMException(1100, I18NMessage.get(MarkShare.class, "MarkShare.label14", "\u65e0\u6548\u7684\u5171\u4eab\u5bf9\u8c61\u7c7b\u578b\uff08MarkShare.getObject\uff09"));
    }

    private BookMark getBookMark(User _currUser) throws WCMException {
        WCMFilter filter = new WCMFilter("", "MARKID=" + this.getObjId(), "");
        BookMarks bookMarks = new BookMarks(_currUser);
        BookMark bookMark = null;
        try {
            bookMarks.open(filter);
            bookMark = bookMarks.isEmpty() ? null : (BookMark)bookMarks.getAt(0);
            return bookMark;
        }
        catch (WCMException ex) {
            throw new WCMException(1100, I18NMessage.get(MarkShare.class, "MarkShare.label15", "\u53d6\u4e66\u7b7e\u5171\u4eab\u4e2d\u7684\u4e66\u7b7e\u5bf9\u8c61\u65f6\u51fa\u9519(MarkShare.getBookMark)"), ex);
        }
    }

    private MarkKind getMarkKind(User _currUser) throws WCMException {
        WCMFilter filter = new WCMFilter("", "KINDID=" + this.getObjId(), "");
        MarkKinds aMarkKinds = new MarkKinds(_currUser);
        MarkKind aMarkKind = null;
        try {
            aMarkKinds.open(filter);
            aMarkKind = aMarkKinds.isEmpty() ? null : (MarkKind)aMarkKinds.getAt(0);
            return aMarkKind;
        }
        catch (WCMException ex) {
            throw new WCMException(1100, I18NMessage.get(MarkShare.class, "MarkShare.label16", "\u53d6\u4e66\u7b7e\u5171\u4eab\u4e2d\u7684\u4e66\u7b7e\u7c7b\u522b\u5bf9\u8c61\u65f6\u51fa\u9519(MarkShare.getMarkKind)"), ex);
        }
    }
}

