/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.comment.domain;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

public class SignUtil {
    private Signature m_signat;
    private Signature m_verify;
    private static SignUtil defaultSignat;
    private static SignUtil defaultVerify;
    private static final char[] encode_array;
    private static final byte[] decode_array;

    private SignUtil() {
    }

    public byte[] decodeRadix64(byte[] inbuf) {
        int size = inbuf.length / 4 * 3;
        if (size == 0) {
            return inbuf;
        }
        if (inbuf[inbuf.length - 1] == 46) {
            --size;
            if (inbuf[inbuf.length - 2] == 46) {
                --size;
            }
        }
        byte[] outbuf = new byte[size];
        int inpos = 0;
        int outpos = 0;
        for (size = inbuf.length; size > 0; size -= 4) {
            byte a = decode_array[inbuf[inpos++] & 0xFF];
            byte b = decode_array[inbuf[inpos++] & 0xFF];
            outbuf[outpos++] = (byte)(a << 2 & 0xFC | b >>> 4 & 3);
            if (inbuf[inpos] == 46) {
                return outbuf;
            }
            a = b;
            b = decode_array[inbuf[inpos++] & 0xFF];
            outbuf[outpos++] = (byte)(a << 4 & 0xF0 | b >>> 2 & 0xF);
            if (inbuf[inpos] == 46) {
                return outbuf;
            }
            a = b;
            b = decode_array[inbuf[inpos++] & 0xFF];
            outbuf[outpos++] = (byte)(a << 6 & 0xC0 | b & 0x3F);
        }
        return outbuf;
    }

    String encodeRadix64(byte[] inbuf) {
        if (inbuf.length == 0) {
            return "";
        }
        byte[] outbuf = new byte[(inbuf.length + 2) / 3 * 4];
        int inpos = 0;
        int outpos = 0;
        for (int size = inbuf.length; size > 0; size -= 3) {
            byte c;
            byte b;
            byte a;
            if (size == 1) {
                a = inbuf[inpos++];
                b = 0;
                c = 0;
                outbuf[outpos++] = (byte)encode_array[a >>> 2 & 0x3F];
                outbuf[outpos++] = (byte)encode_array[(a << 4 & 0x30) + (b >>> 4 & 0xF)];
                outbuf[outpos++] = 46;
                outbuf[outpos++] = 46;
                continue;
            }
            if (size == 2) {
                a = inbuf[inpos++];
                b = inbuf[inpos++];
                c = 0;
                outbuf[outpos++] = (byte)encode_array[a >>> 2 & 0x3F];
                outbuf[outpos++] = (byte)encode_array[(a << 4 & 0x30) + (b >>> 4 & 0xF)];
                outbuf[outpos++] = (byte)encode_array[(b << 2 & 0x3C) + (c >>> 6 & 3)];
                outbuf[outpos++] = 46;
                continue;
            }
            a = inbuf[inpos++];
            b = inbuf[inpos++];
            c = inbuf[inpos++];
            outbuf[outpos++] = (byte)encode_array[a >>> 2 & 0x3F];
            outbuf[outpos++] = (byte)encode_array[(a << 4 & 0x30) + (b >>> 4 & 0xF)];
            outbuf[outpos++] = (byte)encode_array[(b << 2 & 0x3C) + (c >>> 6 & 3)];
            outbuf[outpos++] = (byte)encode_array[c & 0x3F];
        }
        return new String(outbuf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SignUtil getSign() throws Exception {
        InputStream is = null;
        ByteArrayOutputStream os = null;
        if (defaultSignat == null) {
            try {
                SignUtil su = new SignUtil();
                is = su.getClass().getResourceAsStream("/sign/prikey.dat");
                if (is == null) {
                    throw new Exception("miss file \"/sign/prikey.dat\"");
                }
                os = new ByteArrayOutputStream(256);
                int iLength = 0;
                byte[] buff = new byte[512];
                while ((iLength = is.read(buff)) != -1) {
                    os.write(buff, 0, iLength);
                }
                is.close();
                buff = os.toByteArray();
                PKCS8EncodedKeySpec priPKCS8 = new PKCS8EncodedKeySpec(buff);
                KeyFactory keyf = KeyFactory.getInstance("DSA");
                PrivateKey prikey = keyf.generatePrivate(priPKCS8);
                Signature signtemp = Signature.getInstance("DSA");
                signtemp.initSign(prikey);
                su.m_signat = signtemp;
                defaultSignat = su;
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception exception) {}
                }
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return defaultSignat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SignUtil getVerify() throws Exception {
        InputStream is = null;
        ByteArrayOutputStream os = null;
        if (defaultVerify == null) {
            try {
                SignUtil su = new SignUtil();
                is = su.getClass().getResourceAsStream("/sign/pubkey.dat");
                if (is == null) {
                    throw new Exception("miss file \"/sign/pubkey.dat\"");
                }
                os = new ByteArrayOutputStream(256);
                int iLength = 0;
                byte[] buff = new byte[512];
                while ((iLength = is.read(buff)) != -1) {
                    os.write(buff, 0, iLength);
                }
                is.close();
                buff = os.toByteArray();
                X509EncodedKeySpec pubX509 = new X509EncodedKeySpec(buff);
                KeyFactory keyf = KeyFactory.getInstance("DSA");
                PublicKey pubkey = keyf.generatePublic(pubX509);
                Signature verify = Signature.getInstance("DSA");
                verify.initVerify(pubkey);
                su.m_verify = verify;
                defaultVerify = su;
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception exception) {}
                }
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return defaultVerify;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] sign(byte[] buff) throws Exception {
        Signature s;
        Signature signature = s = this.m_signat;
        synchronized (signature) {
            s.update(buff);
            return s.sign();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verify(byte[] data, int iLength) throws Exception {
        Signature v;
        int iOffset = data.length - iLength;
        byte[] sign = new byte[iLength];
        System.arraycopy(data, iOffset, sign, 0, iLength);
        Signature signature = v = this.m_verify;
        synchronized (signature) {
            v.update(data, 0, iOffset - 4);
            return v.verify(sign);
        }
    }

    static {
        int i;
        defaultSignat = null;
        defaultVerify = null;
        encode_array = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '-', '_'};
        decode_array = new byte[256];
        for (i = 0; i < 255; ++i) {
            SignUtil.decode_array[i] = -1;
        }
        for (i = 0; i < encode_array.length; ++i) {
            SignUtil.decode_array[SignUtil.encode_array[i]] = (byte)i;
        }
    }
}

