/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.comment.domain;

import com.trs.components.comment.domain.SignUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;

public class Management {
    private int m_iSiteID;
    private String m_sSiteName;
    private int m_iChannelID;
    private String m_sChannelName;
    private int m_iNewsID;
    private String m_sNewsTitle;
    private int m_iUserID;
    private String m_sUserName;
    private String m_sDataWithSign;
    private int m_nTopicId;
    private String m_sTopicTitle;

    public Management() {
    }

    public Management(String s) throws Exception {
        byte[] buff = s.getBytes("ISO8859_1");
        SignUtil su = SignUtil.getVerify();
        buff = su.decodeRadix64(buff);
        DataInputStream is = new DataInputStream(new ByteArrayInputStream(buff));
        this.m_iUserID = is.readInt();
        this.m_iSiteID = is.readInt();
        this.m_iChannelID = is.readInt();
        this.m_iNewsID = is.readInt();
        this.m_sUserName = is.readUTF();
        this.m_sSiteName = is.readUTF();
        this.m_sChannelName = is.readUTF();
        this.m_sNewsTitle = is.readUTF();
        this.m_nTopicId = is.readInt();
        this.m_sTopicTitle = is.readUTF();
        if (!su.verify(buff, is.readInt())) {
            throw new Exception("sign error");
        }
    }

    public String getDataWithSign() throws Exception {
        if (this.m_sDataWithSign == null) {
            if (this.m_iUserID <= 0 || this.m_sUserName == null) {
                throw new Exception("setUser must call");
            }
            if (this.m_iSiteID <= 0 || this.m_sSiteName == null) {
                throw new Exception("setSite must call");
            }
            if (this.m_sChannelName == null) {
                this.m_sChannelName = "";
            }
            if (this.m_sNewsTitle == null) {
                this.m_sNewsTitle = "";
            }
            if (this.m_sTopicTitle == null) {
                this.m_sTopicTitle = "";
            }
            SignUtil su = SignUtil.getSign();
            ByteArrayOutputStream bos = new ByteArrayOutputStream(512);
            DataOutputStream dos = new DataOutputStream(bos);
            dos.writeInt(this.m_iUserID);
            dos.writeInt(this.m_iSiteID);
            dos.writeInt(this.m_iChannelID);
            dos.writeInt(this.m_iNewsID);
            dos.writeUTF(this.m_sUserName);
            dos.writeUTF(this.m_sSiteName);
            dos.writeUTF(this.m_sChannelName);
            dos.writeUTF(this.m_sNewsTitle);
            dos.writeInt(this.m_nTopicId);
            dos.writeUTF(this.m_sTopicTitle);
            dos.flush();
            byte[] buff = su.sign(bos.toByteArray());
            dos.writeInt(buff.length);
            dos.write(buff);
            dos.flush();
            this.m_sDataWithSign = su.encodeRadix64(bos.toByteArray());
        }
        return this.m_sDataWithSign;
    }

    public int getNewsID() {
        return this.m_iNewsID;
    }

    public String getNewsTitle() {
        return this.m_sNewsTitle;
    }

    public void setNewsId(int iNewsID) {
        this.setNews(iNewsID, null);
    }

    public void setNews(int iNewsID, String sNewsTitle) {
        this.m_iNewsID = iNewsID;
        this.m_sNewsTitle = sNewsTitle;
        this.m_sDataWithSign = null;
    }

    public int getChannelID() {
        return this.m_iChannelID;
    }

    public String getChannelName() {
        return this.m_sChannelName;
    }

    public void setChannel(int iChannelID, String sChannelName) {
        this.m_iChannelID = iChannelID;
        this.m_sChannelName = sChannelName;
        this.m_sDataWithSign = null;
    }

    public int getSiteID() {
        return this.m_iSiteID;
    }

    public String getSiteName() {
        return this.m_sSiteName;
    }

    public void setSite(int iSiteID, String sSiteName) {
        this.m_iSiteID = iSiteID;
        this.m_sSiteName = sSiteName;
        this.m_sDataWithSign = null;
    }

    public int getUserID() {
        return this.m_iUserID;
    }

    public String getUserName() {
        return this.m_sUserName;
    }

    public void setUser(int iUserID, String sUserName) {
        this.m_iUserID = iUserID;
        this.m_sUserName = sUserName;
        this.m_sDataWithSign = null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(256);
        sb.append("User:");
        sb.append(this.m_iUserID);
        sb.append('/');
        sb.append(this.m_sUserName);
        sb.append(",Site:");
        sb.append(this.m_iSiteID);
        sb.append('/');
        sb.append(this.m_sSiteName);
        sb.append(",Channel:");
        sb.append(this.m_iChannelID);
        sb.append('/');
        sb.append(this.m_sChannelName);
        sb.append(",NewsID:");
        sb.append(this.m_iNewsID);
        sb.append('/');
        sb.append(this.m_sNewsTitle);
        return sb.toString();
    }

    public int getTopicId() {
        return this.m_nTopicId;
    }

    public void setTopicId(int topicId) {
        this.m_nTopicId = topicId;
    }

    public String getTopicTitle() {
        return this.m_sTopicTitle;
    }

    public void setTopicTitle(String topicTitle) {
        this.m_sTopicTitle = topicTitle;
    }
}

