/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.process.engine;

import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;

public class FlowUserHelper {
    public static Users getDeptMgrsOfUserx(User _user) throws WCMException {
        if (_user == null) {
            return new Users(null, 1, 1);
        }
        String sWhere = "exists(select A.UserId from WCMGrpUser A where A.IsAdministrator=1 and WCMUser.UserId=A.UserId and exists(select B.GroupId from WCMGrpUser B where B.UserId=? and A.GroupId=B.GroupId))";
        WCMFilter filter = new WCMFilter("WCMUser", sWhere, "");
        filter.addSearchValues(_user.getId());
        Users users = Users.openWCMObjs(null, filter);
        if (!users.isEmpty()) {
            return users;
        }
        Groups groups = _user.getGroups();
        Groups parentGroups = new Groups(null);
        int nSize = groups.size();
        for (int i = 0; i < nSize; ++i) {
            int nParentId;
            Group group = (Group)groups.getAt(i);
            if (group == null || parentGroups.indexOf(nParentId = group.getParentId()) >= 0) continue;
            parentGroups.addElement(nParentId);
        }
        if (parentGroups.isEmpty()) {
            return users;
        }
        sWhere = "exists(select A.UserId from WCMGrpUser A where A.IsAdministrator=1 and WCMUser.UserId=A.UserId and A.GroupId in(" + parentGroups.getIdListAsString() + "))";
        filter = new WCMFilter("WCMUser", sWhere, "");
        return Users.openWCMObjs(null, filter);
    }

    public static Users getDeptMgrsByGrpName(String _sGroupName) throws WCMException {
        if (_sGroupName == null || (_sGroupName = _sGroupName.trim()).length() == 0) {
            return new Users(null, 1, 1);
        }
        String sWhere = "exists(select A.UserId from WCMGrpUser A where A.IsAdministrator=1 and WCMUser.UserId=A.UserId and exists(select B.GroupId from WCMGroup B where B.GName=? and A.GroupId=B.GroupId))";
        WCMFilter filter = new WCMFilter("", sWhere, "");
        filter.addSearchValues(_sGroupName);
        return Users.openWCMObjs(null, filter);
    }

    public static Users getDeptMgrsByGrpIds(String _sGroupIds) throws WCMException {
        if (_sGroupIds == null || (_sGroupIds = _sGroupIds.trim()).length() == 0) {
            return new Users(null, 1, 1);
        }
        WCMFilter filter = new WCMFilter("", "", "");
        String[] nGroupIds = _sGroupIds.split(",");
        StringBuffer sbGroups = new StringBuffer(nGroupIds.length * 2 + 300);
        sbGroups.append("exists(select GU.UserId");
        sbGroups.append(" from WCMGrpUser GU");
        sbGroups.append(" where GU.IsAdministrator=1 and WCMUser.UserId=GU.UserId and GU.GroupId IN(");
        int nSize = nGroupIds.length;
        for (int i = 0; i < nSize; ++i) {
            int iId = Integer.parseInt(nGroupIds[i]);
            if (iId == 0) continue;
            sbGroups.append("?,");
            filter.addSearchValues(iId);
        }
        sbGroups.setCharAt(sbGroups.length() - 1, ')');
        sbGroups.append(")");
        filter.setWhere(sbGroups.toString());
        return Users.openWCMObjs(null, filter);
    }
}

