/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cluster;

import com.trs.DreamFactory;
import com.trs.cluster.FileMsgProcessor;
import com.trs.cluster.IClusterMsgCenter;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.infra.cluster.Extension;
import com.trs.infra.cluster.Member;
import com.trs.infra.support.config.ConfigServer;
import java.util.Hashtable;
import org.apache.log4j.Logger;

public class TRSClusterExtensionImpl
implements Extension {
    private static Logger logger = Logger.getLogger(TRSClusterExtensionImpl.class);
    private String m_sExtensionId = null;
    private IClusterMsgCenter m_oWCMClusterMsgCenter = null;
    private int m_nRetryTimes = 5;
    private int m_nRetryInterval = 0;

    public TRSClusterExtensionImpl(String _sExtensionId) {
        this.m_sExtensionId = _sExtensionId;
    }

    public Object callByCluster(Object _oArgs, Member _oCaller) {
        return this.callByClusterWithRetry(_oArgs, _oCaller);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object callByClusterWithRetry(Object args, Member caller) {
        if (this.m_oWCMClusterMsgCenter == null) {
            this.m_oWCMClusterMsgCenter = (IClusterMsgCenter)DreamFactory.createObjectById("IClusterMsgCenter");
            ConfigServer conf = ConfigServer.getServer();
            try {
                this.m_nRetryTimes = Integer.parseInt(conf.getSysConfigValue("cluster.retrytimes", "5"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.m_nRetryInterval = Integer.parseInt(conf.getSysConfigValue("cluster.retryinterval", "300"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!this.m_oWCMClusterMsgCenter.isStarted()) {
            return null;
        }
        ContextHelper.initContext(User.getSystem());
        boolean ok = false;
        boolean waitSomeMills = this.m_nRetryInterval > 0;
        try {
            for (int retry = 1; retry <= this.m_nRetryTimes && !ok; ++retry) {
                ok = this.callByCluster0(args, caller, retry);
                if (!waitSomeMills || ok) continue;
                try {
                    Thread.sleep(this.m_nRetryInterval);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        finally {
            ContextHelper.clear();
        }
        return null;
    }

    private boolean callByCluster0(Object args, Member caller, int nthretry) {
        try {
            if (args instanceof int[]) {
                int[] pArgs = (int[])args;
                if (pArgs.length < 3) {
                    logger.error((Object)("The message that the cluster[" + caller + "] sended is valid!The length of int array is small!Need: 3,actal: " + pArgs.length + "."));
                    return true;
                }
                this.m_oWCMClusterMsgCenter.receive(pArgs[0], pArgs[1], pArgs[2]);
            } else if (args instanceof String[]) {
                String[] pArgs = (String[])args;
                if (pArgs.length < 2) {
                    logger.error((Object)("The message that the cluster[" + caller + "] sended is valid!The length of int array is small!Need: 2,actal: " + pArgs.length + "."));
                    return true;
                }
                String sContent = pArgs[0];
                String[] pParameters = new String[pArgs.length - 1];
                System.arraycopy(pArgs, 1, pParameters, 0, pParameters.length);
                this.m_oWCMClusterMsgCenter.receive(sContent, pParameters);
            } else if (args instanceof Object[]) {
                Object[] pArgs = (Object[])args;
                if (pArgs.length < 4) {
                    if (pArgs.length == 3 && "FILE.UPD".equals(pArgs[0])) {
                        FileMsgProcessor.receive(pArgs);
                        return true;
                    }
                    logger.error((Object)("The message that the cluster[" + caller + "] sended is valid!The length of int array is small!Need: 4,actal: " + pArgs.length + "."));
                    return true;
                }
                int nObjType = (Integer)pArgs[0];
                int nObjId = (Integer)pArgs[1];
                int nEventType = (Integer)pArgs[2];
                Hashtable hProperties = (Hashtable)pArgs[3];
                this.m_oWCMClusterMsgCenter.receive(nObjType, nObjId, nEventType, hProperties);
            } else {
                logger.error((Object)("The message that the cluster[" + caller + "] sended is valid!Unkown the type of message!"));
            }
            return true;
        }
        catch (Exception ex) {
            if (nthretry == this.m_nRetryTimes) {
                logger.error((Object)("Failed to process the msg from " + caller), (Throwable)ex);
            } else if (logger.isDebugEnabled()) {
                logger.error((Object)(nthretry + " try process the msg from " + caller), (Throwable)ex);
            }
            return false;
        }
    }

    public String getExtensionId() {
        return this.m_sExtensionId;
    }
}

