/*
 * Decompiled with CFR 0.152.
 */
package com.trs.webframework.context;

import com.trs.cms.ContextHelper;
import com.trs.infra.util.CMyString;
import com.trs.webframework.xmlserver.parser.ServletInputStreamWrapper;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class ServiceContext {
    public static boolean IS_CONSOLE_TEST = false;
    private boolean m_bReturnJSON = false;
    private boolean m_bReturnHTML = false;
    private Map m_mapParameterNames = null;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private static ServiceContext currInstance;
    private ServletInputStreamWrapper m_oInputStreamWrapper;
    private static Logger logger;

    public ServiceContext() {
    }

    public ServiceContext(HttpServletRequest _request, HttpServletResponse _response) {
        this.request = _request;
        this.response = _response;
        currInstance = ServiceContext.create(_request, _response);
    }

    public static ServiceContext create(HttpServletRequest _request, HttpServletResponse _response) {
        ServiceContext instance = new ServiceContext();
        instance.request = _request;
        instance.response = _response;
        return instance;
    }

    public static ServiceContext getCurrentServiceContext() {
        if (currInstance == null) {
            currInstance = new ServiceContext();
        }
        return currInstance;
    }

    public String[] getParameterValues(String _sParameterName) {
        String sParameterName = this.getRequestParameterName(_sParameterName);
        if (sParameterName == null) {
            return new String[0];
        }
        String[] pValues = this.request.getParameterValues(sParameterName);
        if (pValues == null) {
            return new String[0];
        }
        String[] pResult = new String[pValues.length];
        for (int i = 0; i < pValues.length; ++i) {
            pResult[i] = CMyString.getStr(pValues[i]);
        }
        return pResult;
    }

    public String getParameterValue(String _sParameterName) {
        String sParameterName = this.getRequestParameterName(_sParameterName);
        if (sParameterName == null) {
            return null;
        }
        String[] pValues = this.getParameterValues(sParameterName);
        if (pValues == null || pValues.length == 0) {
            return null;
        }
        return pValues[0];
    }

    private String getRequestParameterName(String _sName) {
        if (this.m_mapParameterNames == null) {
            logger.debug((Object)"init....");
            this.m_mapParameterNames = new HashMap();
            Enumeration enNames = this.request.getParameterNames();
            while (enNames.hasMoreElements()) {
                String sParamName = (String)enNames.nextElement();
                logger.debug((Object)sParamName);
                this.m_mapParameterNames.put(sParamName.toUpperCase(), sParamName);
            }
        }
        return (String)this.m_mapParameterNames.get(_sName.toUpperCase());
    }

    public Enumeration getParameterNames() {
        return this.request.getParameterNames();
    }

    public Map getParameters() {
        return this.request.getParameterMap();
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public ServletInputStreamWrapper getInputStreamWrapper() {
        return this.m_oInputStreamWrapper;
    }

    public void setInputStreamWrapper(ServletInputStreamWrapper _isw) {
        this.m_oInputStreamWrapper = _isw;
    }

    public InputStream getInputStream() {
        if (this.m_oInputStreamWrapper == null) {
            return null;
        }
        return this.m_oInputStreamWrapper.getInputSteam();
    }

    public void setContentTypeIsHTML() {
        this.setContentType("test/html;charset=utf-8");
    }

    public void setContentType(String _sContentType) {
        if (this.response == null || CMyString.isEmpty(_sContentType)) {
            return;
        }
        this.response.setContentType(_sContentType);
        this.response.setHeader("SelfDefinedContentType", "1");
    }

    public Object getSessionValue(String _sSessionKey) {
        if (IS_CONSOLE_TEST) {
            return ContextHelper.getLoginUser();
        }
        return this.request.getSession().getAttribute(_sSessionKey);
    }

    public boolean isReturnJSON() {
        return this.m_bReturnJSON || "json".equals(this.request.getHeader("dataType")) || "json".equals(this.request.getParameter("__dataType__"));
    }

    public void setReturnJSON(boolean returnJSON) {
        this.m_bReturnJSON = returnJSON;
    }

    public boolean isReturnHTML() {
        return this.m_bReturnHTML;
    }

    public void setReturnHTML(boolean returnHTML) {
        this.m_bReturnHTML = returnHTML;
    }

    static {
        logger = Logger.getLogger(ServiceContext.class);
    }
}

