/*
 * Decompiled with CFR 0.152.
 */
package com.trs.template.analyse;

import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.common.publish.persistent.template.Templates;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class TemplateAddAnalyseMgr {
    private static Logger logger = Logger.getLogger(TemplateAddAnalyseMgr.class);

    public Map<String, List<String>> addAnalyseCode(WCMFilter _filter, String _match) throws WCMException {
        Templates templates = this.queryTemplates(_filter);
        HashMap<String, List<String>> messageMap = new HashMap<String, List<String>>();
        messageMap.put("lock", new ArrayList());
        messageMap.put("undo", new ArrayList());
        messageMap.put("sucess", new ArrayList());
        if (templates == null || templates.isEmpty()) {
            return messageMap;
        }
        if (_match == null || "".equals(_match)) {
            throw new WCMException("\u8bf7\u8f93\u5165\u9700\u8981\u67e5\u8be2\u503c");
        }
        for (int i = 0; i < templates.size(); ++i) {
            Template template = (Template)templates.getAt(i);
            try {
                String tempText = template.getText();
                if (tempText.indexOf("//ta.trs.cn/") != -1) {
                    ((List)messageMap.get("undo")).add("Id\u4e3a[" + template.getId() + "]\u540d\u79f0[" + template.getName() + "]");
                    continue;
                }
                String newTemp = tempText.replaceFirst("(?i)</body>", _match + "$0");
                if (newTemp.equals(tempText)) continue;
                template.setText(newTemp);
                ((List)messageMap.get("sucess")).add("Id\u4e3a[" + template.getId() + "]\u540d\u79f0[" + template.getName() + "]");
                template.save();
                continue;
            }
            catch (WCMException e) {
                if (e.getErrNo() == 200006) {
                    ((List)messageMap.get("lock")).add("Id\u4e3a[" + template.getId() + "]\u540d\u79f0[" + template.getName() + "]\u6b63\u5728\u7f16\u8f91\u9501\u5b9a");
                }
                logger.info((Object)("Id\u4e3a[" + template.getId() + "]\u540d\u79f0[" + template.getName() + "]\u6b63\u5728\u7f16\u8f91\u9501\u5b9a"));
            }
        }
        return messageMap;
    }

    public Map<String, List<String>> rollBackTemplate(WCMFilter _filter) throws WCMException {
        Templates templates = this.queryTemplates(_filter);
        HashMap<String, List<String>> messageMap = new HashMap<String, List<String>>();
        messageMap.put("lock", new ArrayList());
        messageMap.put("sucess", new ArrayList());
        if (templates == null || templates.isEmpty()) {
            return messageMap;
        }
        for (int i = 0; i < templates.size(); ++i) {
            Template template = (Template)templates.getAt(i);
            try {
                String tempText = template.getText();
                String newTemp = tempText.replaceAll("(?is)<(script>|noscript>).*?(//ta.trs.cn/)+.*?(</\\1)", "");
                if (newTemp.equals(tempText)) continue;
                template.setText(newTemp);
                ((List)messageMap.get("sucess")).add("Id\u4e3a[" + template.getId() + "]\u540d\u79f0[" + template.getName() + "]");
                template.save();
                continue;
            }
            catch (WCMException e) {
                if (e.getErrNo() == 200006) {
                    ((List)messageMap.get("lock")).add("Id\u4e3a[" + template.getId() + "]\u540d\u79f0[" + template.getName() + "]\u6b63\u5728\u7f16\u8f91\u9501\u5b9a");
                }
                logger.info((Object)("Id\u4e3a[" + template.getId() + "]\u540d\u79f0[" + template.getName() + "]\u6b63\u5728\u7f16\u8f91\u9501\u5b9a"));
            }
        }
        return messageMap;
    }

    private Templates queryTemplates(WCMFilter _extraFilter) {
        Templates templates = null;
        try {
            templates = Templates.openWCMObjs(null, _extraFilter);
        }
        catch (WCMException e) {
            e.printStackTrace();
        }
        return templates;
    }
}

