/*
 * Decompiled with CFR 0.152.
 */
package com.trs.servlet.acl;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.resource.Keyword;
import com.trs.infra.common.WCMException;
import com.trs.presentation.util.RequestHelper;
import com.trs.servlet.Acl;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class KeywordAddEdit
extends Acl {
    @Override
    protected boolean check(HttpServletRequest request, HttpServletResponse response) throws WCMException {
        User loginUser = ContextHelper.getLoginUser();
        if (loginUser == null) {
            return false;
        }
        if (loginUser.isAdministrator()) {
            return true;
        }
        RequestHelper helper = new RequestHelper(request, response, request.getSession().getServletContext());
        int nId = helper.getInt("KeywordId", 0);
        int nSiteId = 0;
        if (nId > 0) {
            Keyword word = Keyword.findById(nId);
            if (word == null) {
                return true;
            }
            nSiteId = word.getSITEID();
        } else {
            nSiteId = helper.getInt("siteId", 0);
        }
        if (nSiteId == 0) {
            return false;
        }
        WebSite site = WebSite.findById(nSiteId);
        if (site == null) {
            return false;
        }
        return AuthServer.hasRight(loginUser, (CMSObj)site, 1);
    }
}

