/*
 * Decompiled with CFR 0.152.
 */
package com.trs.mas;

import com.trs.components.video.VSConfig;
import com.trs.infra.common.WCMException;
import com.trs.infra.config.TRSConfigServer;
import com.trs.infra.util.CMyString;
import com.trs.mas.MASClientServer;
import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;

public class MediaHelper {
    private static Logger logger = Logger.getLogger(MediaHelper.class);
    private static String METHOD_NAME_GET_MEDIAINFO = "exQuery";
    public static final String KEY_MAS_ID = "masId";
    public static final String KEY_ERROR_INFO = "err";
    public static final String Video_Default_Type = "vod";
    private static final String MAS_OPEN_API = "openapi/pages.do";
    static final String CACHE_KEY = "MASObjects";

    public static String getMasAppKey() {
        return VSConfig.getAppKey();
    }

    public static String getMasUrl() {
        return CMyString.setStrEndWith(VSConfig.getUploadJavaAppIntranetUrl(), '/') + MAS_OPEN_API;
    }

    public static String getMasInternetUrl() {
        return CMyString.setStrEndWith(VSConfig.getUploadJavaAppUrl(), '/') + MAS_OPEN_API;
    }

    public static String getMasThumbServiceURL(String _sId) {
        return MediaHelper.getMasInternetUrl() + "?method=exThumb&appKey=" + VSConfig.getAppKey() + "&id=" + _sId;
    }

    public static Map[] getMediaInfo(String _sURLOfMASApp, String _sAppKey, String _sMediaIds) throws Exception {
        return MediaHelper.getMediaInfo(_sURLOfMASApp, _sAppKey, _sMediaIds, Video_Default_Type);
    }

    public static Map[] getMediaInfo(String _sURLOfMASApp, String _sAppKey, String _sMediaIds, String _sType) throws Exception {
        return MediaHelper.getMediaInfo(_sURLOfMASApp, _sAppKey, _sMediaIds, _sType, "-1");
    }

    public static Map[] getMediaInfo(String _sURLOfMASApp, String _sAppKey, String _sMediaIds, String _sType, String _sDocId) throws Exception {
        MASClientServer oClientServer;
        String sResponseText;
        StringBuffer sbParameters = new StringBuffer();
        sbParameters.append("method=").append(METHOD_NAME_GET_MEDIAINFO);
        sbParameters.append("&id=").append(_sMediaIds);
        sbParameters.append("&appKey=").append(_sAppKey);
        sbParameters.append("&type=").append(_sType);
        sbParameters.append("&docId=").append(_sDocId);
        String sURL = _sURLOfMASApp + "?" + sbParameters;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)sURL);
        }
        if ((sResponseText = (oClientServer = (MASClientServer)TRSConfigServer.findConfigServerById(MASClientServer.class.getName())).getContentFromURL(sURL)) == null) {
            throw new Exception("\u6307\u5b9a\u7684MAS\u7684URL\u65e0\u6548\uff1f[\u670d\u52a1\u5730\u5740=" + sURL + "]");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("[ " + sResponseText + " ]"));
        }
        Map[] pResult = null;
        try {
            ObjectMapper oJSONMap = new ObjectMapper();
            pResult = (Map[])oJSONMap.readValue(sResponseText, Map[].class);
        }
        catch (Exception e) {
            try {
                ObjectMapper oJSONMap = new ObjectMapper();
                pResult = new Map[]{(Map)oJSONMap.readValue(sResponseText, Map.class)};
            }
            catch (Exception e2) {
                throw new WCMException("MAS\u8fd4\u56de\u503c\u4e0d\u7b26\u5408\u9884\u671f\uff1f[\u670d\u52a1\u5730\u5740=" + _sURLOfMASApp + "?" + sbParameters + "][" + sResponseText + "]", e);
            }
        }
        if (pResult == null || pResult.length <= 0) {
            throw new WCMException("MAS\u8fd4\u56de\u503c\u4e0d\u7b26\u5408\u9884\u671f\uff1f[\u670d\u52a1\u5730\u5740=" + _sURLOfMASApp + "?" + sbParameters + "][" + sResponseText + "]");
        }
        ArrayList<Map> listResult = new ArrayList<Map>();
        for (int i = 0; i < pResult.length; ++i) {
            Map hResult = pResult[i];
            if (hResult.containsKey(KEY_ERROR_INFO)) {
                logger.info((Object)("MAS Return Error:[url=" + _sURLOfMASApp + "?" + sbParameters + "][err:" + hResult.get(KEY_ERROR_INFO) + "]"));
                continue;
            }
            if (!hResult.containsKey(KEY_MAS_ID)) {
                throw new WCMException("Mas\u6539\u53d8\u7ea6\u5b9a\u7684\u89c4\u5219\uff01[\u670d\u52a1\u5730\u5740=" + _sURLOfMASApp + "?" + sbParameters + "]\u8fd4\u56de\u5185\u5bb9\u4e3a" + sResponseText);
            }
            listResult.add(hResult);
        }
        return listResult.toArray(new Map[0]);
    }

    public static Map getMediaInfo(String _sURLOfMASApp, String _sAppKey, int _nMediaId, String _sType, String _sDocID) throws Exception {
        Map[] pResult = MediaHelper.getMediaInfo(_sURLOfMASApp, _sAppKey, String.valueOf(_nMediaId), _sType, _sDocID);
        return pResult[0];
    }

    public static Map getMediaInfo(String _sURLOfMASApp, String _sAppKey, int _nMediaId, String _sType) throws Exception {
        Map[] pResult = MediaHelper.getMediaInfo(_sURLOfMASApp, _sAppKey, String.valueOf(_nMediaId), _sType);
        return pResult[0];
    }

    public static Map getMediaInfo(String _sURLOfMASApp, String _sAppKey, int _nMediaId) throws Exception {
        Map[] pResult = MediaHelper.getMediaInfo(_sURLOfMASApp, _sAppKey, String.valueOf(_nMediaId), Video_Default_Type);
        return pResult[0];
    }
}

