/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.jazzlib;

import com.trs.infra.util.jazzlib.Inflater;
import com.trs.infra.util.jazzlib.InflaterInputStream;
import com.trs.infra.util.jazzlib.ZipConstants;
import com.trs.infra.util.jazzlib.ZipEntry;
import com.trs.infra.util.jazzlib.ZipException;
import com.trs.infra.util.store.FileStore;
import com.trs.infra.util.store.RandomAccessFileService;
import com.trs.infra.util.store.RandomAccessFileStore;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class ZipFile
implements ZipConstants {
    public static final int OPEN_READ = 1;
    public static final int OPEN_DELETE = 2;
    private String name;
    RandomAccessFileStore raf;
    ZipEntry[] entries;
    private String encoding = null;

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String _encoding) {
        this.encoding = _encoding;
    }

    public ZipFile(String name) throws ZipException, IOException {
        this.raf = new RandomAccessFileService(name, "r");
        this.name = name;
        this.readEntries();
    }

    public ZipFile(String name, String enc) throws ZipException, IOException {
        this.encoding = enc;
        this.raf = new RandomAccessFileService(name, "r");
        this.name = name;
        this.readEntries();
    }

    public ZipFile(FileStore file) throws ZipException, IOException {
        this.raf = new RandomAccessFileService(file, "r");
        this.name = file.getName();
        this.readEntries();
    }

    public ZipFile(FileStore file, int mode) throws ZipException, IOException {
        if ((mode & 2) != 0) {
            throw new IllegalArgumentException("OPEN_DELETE mode not supported yet in java.util.zip.ZipFile");
        }
        this.raf = new RandomAccessFileService(file, "r");
        this.name = file.getName();
        this.readEntries();
    }

    private final int readLeShort() throws IOException {
        int value = this.raf.readUnsignedByte() | this.raf.readUnsignedByte() << 8;
        return value;
    }

    private final int readLeInt() throws IOException {
        return this.readLeShort() | this.readLeShort() << 16;
    }

    private void readEntries() throws ZipException, IOException {
        long pos = this.raf.length() - 22L;
        do {
            if (pos < 0L) {
                throw new ZipException("central directory not found, probably not a zip file");
            }
            this.raf.seek(pos--);
        } while (this.readLeInt() != 101010256);
        if (this.raf.skipBytes(6) != 6) {
            throw new EOFException();
        }
        int count = this.readLeShort();
        if (this.raf.skipBytes(4) != 4) {
            throw new EOFException();
        }
        int centralOffset = this.readLeInt();
        this.entries = new ZipEntry[count];
        this.raf.seek(centralOffset);
        for (int i = 0; i < count; ++i) {
            if (this.readLeInt() != 33639248) {
                throw new ZipException("Wrong Central Directory signature");
            }
            if (this.raf.skipBytes(6) != 6) {
                throw new EOFException();
            }
            int method = this.readLeShort();
            int dostime = this.readLeInt();
            int crc = this.readLeInt();
            int csize = this.readLeInt();
            int size = this.readLeInt();
            int nameLen = this.readLeShort();
            int extraLen = this.readLeShort();
            int commentLen = this.readLeShort();
            if (this.raf.skipBytes(8) != 8) {
                throw new EOFException();
            }
            int offset = this.readLeInt();
            byte[] buffer = new byte[Math.max(nameLen, commentLen)];
            this.raf.readFully(buffer, 0, nameLen);
            String name = this.encoding == null ? new String(buffer, 0, nameLen) : new String(buffer, 0, nameLen, this.encoding);
            ZipEntry entry = new ZipEntry(name);
            entry.setMethod(method);
            entry.setCrc((long)crc & 0xFFFFFFFFL);
            entry.setSize((long)size & 0xFFFFFFFFL);
            entry.setCompressedSize((long)csize & 0xFFFFFFFFL);
            entry.setDOSTime(dostime);
            if (extraLen > 0) {
                byte[] extra = new byte[extraLen];
                this.raf.readFully(extra);
                entry.setExtra(extra);
            }
            if (commentLen > 0) {
                this.raf.readFully(buffer, 0, commentLen);
                entry.setComment(this.encoding == null ? new String(buffer, 0, commentLen) : new String(buffer, 0, commentLen, this.encoding));
            }
            entry.zipFileIndex = i;
            entry.offset = offset;
            this.entries[i] = entry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        this.entries = null;
        RandomAccessFileStore randomAccessFileStore = this.raf;
        synchronized (randomAccessFileStore) {
            this.raf.close();
        }
    }

    public Enumeration entries() {
        if (this.entries == null) {
            throw new IllegalStateException("ZipFile has closed");
        }
        return new ZipEntryEnumeration(this.entries);
    }

    private int getEntryIndex(String name) {
        for (int i = 0; i < this.entries.length; ++i) {
            if (!name.equals(this.entries[i].getName())) continue;
            return i;
        }
        return -1;
    }

    public ZipEntry getEntry(String name) {
        if (this.entries == null) {
            throw new IllegalStateException("ZipFile has closed");
        }
        int index = this.getEntryIndex(name);
        return index >= 0 ? (ZipEntry)this.entries[index].clone() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long checkLocalHeader(ZipEntry entry) throws IOException {
        RandomAccessFileStore randomAccessFileStore = this.raf;
        synchronized (randomAccessFileStore) {
            this.raf.seek(entry.offset);
            if (this.readLeInt() != 67324752) {
                throw new ZipException("Wrong Local header signature");
            }
            if (this.raf.skipBytes(4) != 4) {
                throw new EOFException();
            }
            if (entry.getMethod() != this.readLeShort()) {
                throw new ZipException("Compression method mismatch");
            }
            if (this.raf.skipBytes(16) != 16) {
                throw new EOFException();
            }
            int nameLength = entry.getName().getBytes().length;
            if (nameLength != this.readLeShort()) {
                throw new ZipException("file name length mismatch");
            }
            int extraLen = nameLength + this.readLeShort();
            return entry.offset + 30 + extraLen;
        }
    }

    public InputStream getInputStream(ZipEntry entry) throws IOException {
        if (this.entries == null) {
            throw new IllegalStateException("ZipFile has closed");
        }
        int index = entry.zipFileIndex;
        if ((index < 0 || index >= this.entries.length || this.entries[index].getName() != entry.getName()) && (index = this.getEntryIndex(entry.getName())) < 0) {
            throw new NoSuchElementException();
        }
        long start = this.checkLocalHeader(this.entries[index]);
        int method = this.entries[index].getMethod();
        PartialInputStream is = new PartialInputStream(this.raf, start, this.entries[index].getCompressedSize());
        switch (method) {
            case 0: {
                return is;
            }
            case 8: {
                return new InflaterInputStream(is, new Inflater(true));
            }
        }
        throw new ZipException("Unknown compression method " + method);
    }

    public String getName() {
        return this.name;
    }

    public int size() {
        try {
            return this.entries.length;
        }
        catch (NullPointerException ex) {
            throw new IllegalStateException("ZipFile has closed");
        }
    }

    private static class PartialInputStream
    extends InputStream {
        RandomAccessFileStore raf;
        long filepos;
        long end;

        public PartialInputStream(RandomAccessFileStore raf, long start, long len) {
            this.raf = raf;
            this.filepos = start;
            this.end = start + len;
        }

        @Override
        public int available() {
            long amount = this.end - this.filepos;
            if (amount > Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            return (int)amount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read() throws IOException {
            if (this.filepos == this.end) {
                return -1;
            }
            RandomAccessFileStore randomAccessFileStore = this.raf;
            synchronized (randomAccessFileStore) {
                this.raf.seek(this.filepos++);
                return this.raf.read();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if ((long)len > this.end - this.filepos && (len = (int)(this.end - this.filepos)) == 0) {
                return -1;
            }
            RandomAccessFileStore randomAccessFileStore = this.raf;
            synchronized (randomAccessFileStore) {
                this.raf.seek(this.filepos);
                int count = this.raf.read(b, off, len);
                if (count > 0) {
                    this.filepos += (long)len;
                }
                return count;
            }
        }

        @Override
        public long skip(long amount) {
            if (amount < 0L) {
                throw new IllegalArgumentException();
            }
            if (amount > this.end - this.filepos) {
                amount = this.end - this.filepos;
            }
            this.filepos += amount;
            return amount;
        }
    }

    private static class ZipEntryEnumeration
    implements Enumeration {
        ZipEntry[] array;
        int ptr = 0;

        public ZipEntryEnumeration(ZipEntry[] arr) {
            this.array = arr;
        }

        @Override
        public boolean hasMoreElements() {
            return this.ptr < this.array.length;
        }

        public Object nextElement() {
            try {
                return this.array[this.ptr++].clone();
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                throw new NoSuchElementException();
            }
        }
    }
}

